/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.MozillaJSS;

import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.pkcs10.CertificationRequest;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Certification.CSRGeneration;
import th.co.oga.security.pki.Certification.CSRGenerator;
import th.co.oga.security.pki.Certification.CSRProfile;
import th.co.oga.security.pki.Certification.CertRequestEncodeException;
import th.co.oga.security.pki.Certification.CertificationRequestException;
import th.co.oga.security.pki.HouseKeeping.AgentProfileNotInitializedException;
import th.co.oga.security.pki.HouseKeeping.CryptoTokenException;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operation.SecureStoreSoftException;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSAlgorithm;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.X500.DName;

public class JSSCSRGenerator
extends CSRGenerator
implements CSRGeneration {
    public JSSCSRGenerator(SecureStoreOperator sso) throws CryptoTokenException {
        super(sso);
        try {
            JSSAlgorithm algos = new JSSAlgorithm();
            this.keyAlgoSet = algos.getKeyPairAlgorithm();
            this.signatureAlgoSet = algos.getSignatureAlgorithm();
        }
        catch (Exception e) {
            throw new CryptoTokenException("Error occur while get the support algorithm table as : " + e.toString());
        }
    }

    public CSRProfile genCertRequest(String signAlgo) throws CertificationRequestException, AgentProfileNotInitializedException, AlgorithmSupportException {
        this.signatureAlgo = this.signatureAlgoSet.findByOID(signAlgo);
        return this.genCertRequest();
    }

    public CSRProfile genCertRequest() throws CertificationRequestException, AgentProfileNotInitializedException {
        this.buildCertificationRequestInfo();
        try {
            SignatureAlgorithm signAlgo = SignatureAlgorithm.fromOID((OBJECT_IDENTIFIER)new OBJECT_IDENTIFIER(this.signatureAlgo.getOID()));
            CertificationRequest csr = new CertificationRequest(this.certRequestInfo, this.keyPair.getPrivate(), signAlgo);
            csr.verify();
            int hash = new String(this.certRequestInfo.getSubjectPublicKeyInfo().getEncoded()).hashCode();
            String sn = "" + Math.abs(hash);
            DName name = new DName(this.certRequestInfo.getSubject());
            return CSRProfile.getNewProfile(sn, ASN1Util.encode((ASN1Value)csr), name.getFriendlyName());
        }
        catch (Exception e) {
            throw new CertificationRequestException("JSSCertRequestor", "Error while generate CSR, " + e.toString());
        }
    }

    public void beginWork() throws CertificationRequestException {
        if (!this.isInternalKey) {
            try {
                this.storeMgr.importPrivateKey(this.keyPair.getPrivate().getEncoded(), this.keyAlgo.getAlgorithmName());
            }
            catch (SecureStoreException e) {
                throw new CertificationRequestException("JSSCertRequestor", "Error while import external private key to key store, " + e.getMessage());
            }
            catch (SecureStoreSoftException secureStoreSoftException) {
                // empty catch block
            }
        }
        super.beginWork();
    }

    public void rollbackWork() {
        try {
            if (this.isBegin()) {
                this.storeMgr.deletePrivateKey(this.keyPair);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSNFromCSR(byte[] CSRDerStream) throws CertRequestEncodeException {
        try {
            CertificationRequest req = (CertificationRequest)ASN1Util.decode((ASN1Template)CertificationRequest.getTemplate(), (byte[])CSRDerStream);
            String sn = "" + Math.abs(new String(req.getInfo().getSubjectPublicKeyInfo().getEncoded()).hashCode());
            return sn;
        }
        catch (Exception e) {
            throw new CertRequestEncodeException("JSSCertRequestor", "\r\n" + e.toString());
        }
    }
}

