/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.MozillaJSS;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.JSSProvider;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.Operation.CryptoOperation;
import th.co.oga.security.pki.Operator.CryptoOperator;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSAlgorithm;

public class JSSCryptoOperator
extends CryptoOperator
implements CryptoOperation {
    protected CryptoManager cryptoManager;

    public JSSCryptoOperator(CryptoManager manager, AlgorithmSupportTable algos) {
        super((Provider)new JSSProvider(), algos);
        this.cryptoManager = manager;
        this.prngName = "PKCS11PRNG";
    }

    public JSSCryptoOperator(CryptoManager manager) {
        this(manager, (AlgorithmSupportTable)new JSSAlgorithm());
    }

    public PublicKey retrustedPublicKey(PublicKey publ) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory kf = KeyFactory.getInstance(publ.getAlgorithm(), this.getSecureProvider());
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publ.getEncoded());
        return kf.generatePublic(keySpec);
    }

    public String getCipherParamSupportAlgos() {
        return "DES_CBC,DESede_CBC,RC2,AES_CBC";
    }

    public String getKeySpecSupportAlgos() {
        return "PBEWithMD5AndDES ,PBEWithSHA1AndDES,PBEWithSHA1AndDESede,PBEWithSHA1And128RC4";
    }

    public String getKeyFactorySupportAlgos() {
        return "AES,DES,DESede,RC4";
    }

    public String getKeyGeneratorSupportAlgos() {
        return "--";
    }

    public String getKeyGenParamSupportAlgos() {
        return "--";
    }

    public String getSecretKeyFactorySupportAlgos() {
        return "AES,DES,DESede,RC4,PBAHmacSHA1,PBEWithMD5AndDES,PBEWithSHA1AndDES,PBEWithSHA1AndDESede,PBEWithSHA1And128RC4";
    }
}

