/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.MozillaJSS;

import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import th.co.oga.security.pki.KeyTypeNotSupportException;
import th.co.oga.security.pki.OIDs;

public class JSSKeyPairAlgo {
    public static JSSKeyPairAlgo RSA = new JSSKeyPairAlgo("rsa");
    public static JSSKeyPairAlgo DSA = new JSSKeyPairAlgo("dsa");
    public static JSSKeyPairAlgo DH = new JSSKeyPairAlgo("DiffieHellman");
    private String keyType = "rsa";
    private KeyPairAlgorithm algo;
    private AlgorithmIdentifier ai;
    private PrivateKey.Type pkType;

    public JSSKeyPairAlgo(JSSKeyPairAlgo kType) {
        this.keyType = kType.toString();
        this.ai = kType.getAlgoIdentifier();
        this.pkType = kType.getPKType();
        this.algo = kType.getKeyPairAlgorithm();
    }

    public String toString() {
        return this.keyType;
    }

    public static JSSKeyPairAlgo getInstance(String typeName) throws KeyTypeNotSupportException {
        if ("RSA,DSA,DH".indexOf(typeName.toUpperCase()) < 0) {
            throw new KeyTypeNotSupportException(typeName);
        }
        return new JSSKeyPairAlgo(typeName);
    }

    public AlgorithmIdentifier getAlgoIdentifier() {
        return this.ai;
    }

    public PrivateKey.Type getPKType() {
        return this.pkType;
    }

    public static PrivateKey.Type getPrivateKeyType(String type) {
        if (type.equalsIgnoreCase("rsa")) {
            return PrivateKey.RSA;
        }
        if (type.equalsIgnoreCase("dsa")) {
            return PrivateKey.DSA;
        }
        if (type.equalsIgnoreCase("DiffieHellman") || type.equalsIgnoreCase("dh")) {
            return PrivateKey.DiffieHellman;
        }
        return null;
    }

    private JSSKeyPairAlgo(String keyType) {
        this.keyType = keyType;
        if (keyType.equalsIgnoreCase("rsa")) {
            this.algo = KeyPairAlgorithm.RSA;
            this.ai = new AlgorithmIdentifier(new OBJECT_IDENTIFIER(OIDs.rsaEncryption));
            this.pkType = PrivateKey.RSA;
        } else if (this.keyType.equalsIgnoreCase("dsa")) {
            this.algo = KeyPairAlgorithm.DSA;
            this.ai = new AlgorithmIdentifier(new OBJECT_IDENTIFIER(OIDs.DSA));
            this.pkType = PrivateKey.DSA;
        } else if (this.keyType.equalsIgnoreCase("dh")) {
            this.ai = new AlgorithmIdentifier(new OBJECT_IDENTIFIER(OIDs.dhEncryption));
            this.pkType = PrivateKey.DiffieHellman;
        }
    }

    public KeyPairAlgorithm getKeyPairAlgorithm() {
        return this.algo;
    }
}

