/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.MozillaJSS;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.pkcs12.AuthenticatedSafes;
import org.mozilla.jss.pkcs12.CertBag;
import org.mozilla.jss.pkcs12.PFX;
import org.mozilla.jss.pkcs12.PasswordConverter;
import org.mozilla.jss.pkcs12.SafeBag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.EncryptedPrivateKeyInfo;
import org.mozilla.jss.pkix.primitive.PrivateKeyInfo;
import org.mozilla.jss.util.Password;
import th.co.oga.security.pki.Certification.CertPackageRecord;
import th.co.oga.security.pki.Operation.PFXAdapterException;
import th.co.oga.security.pki.Operation.PFXOperation;
import th.co.oga.security.pki.PinCode;
import th.co.oga.security.pki.Utils;

public class JSSPFXDriver
implements PFXOperation {
    private PFX personalFileExchange;
    private SecureRandom rand;
    private PFX.Template reader = new PFX.Template();

    public JSSPFXDriver() throws PFXAdapterException {
        try {
            this.rand = SecureRandom.getInstance("SHA1PRNG", "SUN");
            this.renew();
        }
        catch (Exception e) {
            throw new PFXAdapterException("\r\n" + e.toString());
        }
    }

    public String getName() {
        return "Mozilla PFX Device Manager";
    }

    public void renew() throws PFXAdapterException {
        this.personalFileExchange = new PFX(new AuthenticatedSafes());
    }

    public void load(InputStream in, PinCode pin) throws PFXAdapterException {
        BufferedInputStream bf = new BufferedInputStream(in);
        Password password = new Password(pin.getPassword());
        try {
            this.personalFileExchange = (PFX)this.reader.decode((InputStream)bf);
            StringBuffer reason = new StringBuffer();
            if (!this.personalFileExchange.verifyAuthSafes(password, reason)) {
                throw new PFXAdapterException("JSSPFXAdapter, error while verify pin, " + reason.toString());
            }
        }
        catch (IOException e) {
            throw new PFXAdapterException("JSSPFXAdapter error while load byte stream, " + e.getMessage());
        }
        catch (InvalidBERException e) {
            throw new PFXAdapterException("JSSPFXAdapter error while decode byte stream, " + e.getMessage());
        }
        catch (CryptoManager.NotInitializedException e) {
            throw new PFXAdapterException("JSSPFXAdapter error while verify pin, " + e.getMessage());
        }
    }

    public Iterator read(PinCode pin) throws PFXAdapterException {
        ArrayList<CertPackageRecord> keys = new ArrayList<CertPackageRecord>();
        ArrayList<CertPackageRecord> certs = new ArrayList<CertPackageRecord>();
        ArrayList contents = new ArrayList();
        Password readPassword = pin == null ? new Password(new char[1]) : new Password(pin.getPassword());
        try {
            AuthenticatedSafes sContents = this.personalFileExchange.getAuthSafes();
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            SEQUENCE sequence = sContents.getSequence();
            int i = 0;
            while (i < sequence.size()) {
                SEQUENCE enties = sContents.getSafeContentsAt(readPassword, i);
                int j = 0;
                while (j < enties.size()) {
                    SafeBag safeBag = (SafeBag)enties.elementAt(j);
                    ASN1Value bagContent = safeBag.getInterpretedBagContent();
                    if (bagContent instanceof CertBag) {
                        CertPackageRecord cprCer = new CertPackageRecord(CertPackageRecord.CertificateRec);
                        CertBag cb = (CertBag)bagContent;
                        if (cb.getCertType().equals((Object)CertBag.X509_CERT_TYPE)) {
                            ByteArrayInputStream bi = new ByteArrayInputStream(((OCTET_STRING)cb.getInterpretedCert()).toByteArray());
                            X509Certificate x509 = (X509Certificate)certFactory.generateCertificate(bi);
                            cprCer.add(x509);
                            bi.close();
                            certs.add(cprCer);
                        }
                    } else {
                        CertPackageRecord cprKey = new CertPackageRecord(CertPackageRecord.PrivateKeyInfoRec);
                        if (bagContent instanceof PrivateKeyInfo) {
                            cprKey.add((PrivateKeyInfo)bagContent);
                            keys.add(cprKey);
                        } else if (bagContent instanceof EncryptedPrivateKeyInfo) {
                            PrivateKeyInfo pki = ((EncryptedPrivateKeyInfo)bagContent).decrypt(readPassword, (KeyGenerator.CharToByteConverter)new PasswordConverter());
                            cprKey.add(Utils.getPrivateKey(pki.getAlgorithm(), ASN1Util.encode((ASN1Value)pki)));
                            keys.add(cprKey);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            int k = 0;
            while (k < keys.size()) {
                contents.add(keys.get(k));
                ++k;
            }
            k = 0;
            while (k < certs.size()) {
                contents.add(certs.get(k));
                ++k;
            }
        }
        catch (Exception e) {
            throw new PFXAdapterException("\r\n " + e.toString());
        }
        return contents.iterator();
    }

    private AlgorithmIdentifier getAlgoId(PrivateKey pk) {
        String pkAlgo = pk.getAlgorithm();
        if (pkAlgo.equalsIgnoreCase("RSA")) {
            return new AlgorithmIdentifier(PrivateKey.Type.RSA.toOID());
        }
        if (pkAlgo.equalsIgnoreCase("DSA")) {
            return new AlgorithmIdentifier(PrivateKey.Type.DSA.toOID());
        }
        return new AlgorithmIdentifier(PrivateKey.Type.DiffieHellman.toOID());
    }

    public void write(PrivateKey priv, X509Certificate[] xcs, PinCode pin) throws PFXAdapterException {
        PrivateKeyInfo pki;
        Password wPassword = new Password(pin.getPassword());
        if (priv instanceof PrivateKeyInfo) {
            pki = (PrivateKeyInfo)priv;
        } else {
            INTEGER v = new INTEGER(1L);
            OCTET_STRING pkData = new OCTET_STRING(priv.getEncoded());
            pki = new PrivateKeyInfo(v, this.getAlgoId(priv), pkData, new SET());
        }
        try {
            SEQUENCE entry = new SEQUENCE();
            X509Certificate leaf = Utils.findLeaf(xcs);
            if (leaf == null) {
                throw new PFXAdapterException("Can not determine the user certificate from list ");
            }
            byte[] localID = SafeBag.getLocalKeyIDFromCert((byte[])leaf.getEncoded());
            SafeBag keyBag = pin == null ? new SafeBag(SafeBag.KEY_BAG, (ASN1Value)pki, null) : SafeBag.createEncryptedPrivateKeyBag((PrivateKeyInfo)pki, (String)Utils.getFriendlyName(leaf), (byte[])localID, (Password)new Password(pin.getPassword()));
            entry.addElement((ASN1Value)keyBag);
            int ct = 0;
            while (ct < xcs.length) {
                localID = SafeBag.getLocalKeyIDFromCert((byte[])xcs[ct].getEncoded());
                OCTET_STRING os = new OCTET_STRING(xcs[ct].getEncoded());
                entry.addElement((ASN1Value)SafeBag.createCertBag((byte[])ASN1Util.encode((ASN1Value)os), (String)Utils.getFriendlyName(xcs[ct]), (byte[])localID));
                ++ct;
            }
            byte[] salt = new byte[PBEAlgorithm.PBE_SHA1_DES3_CBC.getSaltLength()];
            this.rand.setSeed(salt);
            this.rand.nextBytes(salt);
            AuthenticatedSafes sContents = this.personalFileExchange.getAuthSafes();
            sContents.addEncryptedSafeContents(PBEAlgorithm.PBE_SHA1_DES3_CBC, wPassword, salt, 1, entry);
            this.personalFileExchange.computeMacData(wPassword, salt, 1);
        }
        catch (Exception e) {
            throw new PFXAdapterException("JSSPFXAdapter", e.toString());
        }
    }

    public void store(PinCode pin, OutputStream out) throws PFXAdapterException {
        try {
            this.personalFileExchange.encode(out);
        }
        catch (Exception e) {
            throw new PFXAdapterException(e.toString());
        }
    }
}

