/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.MozillaJSS;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.security.auth.x500.X500Principal;
import org.mozilla.jss.CRLImportException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.KeyAlreadyImportedException;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.PK11InternalTokenCert;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.pkcs11.PK11Store;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.EncryptedPrivateKeyInfo;
import org.mozilla.jss.pkix.primitive.PrivateKeyInfo;
import org.mozilla.jss.util.Password;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CSRGeneration;
import th.co.oga.security.pki.Certification.CertChain;
import th.co.oga.security.pki.Certification.CertChainException;
import th.co.oga.security.pki.Certification.CertList;
import th.co.oga.security.pki.Certification.CertPackage;
import th.co.oga.security.pki.Certification.CertPackageEncodingFormat;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertPackageRecord;
import th.co.oga.security.pki.Certification.CertPackageTypeNotSupportException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.Certification.CertProfileNotFoundInListException;
import th.co.oga.security.pki.Certification.InternalCertProfile;
import th.co.oga.security.pki.Certification.PFXProfile;
import th.co.oga.security.pki.Certification.PFXProfileException;
import th.co.oga.security.pki.Engine.SecureProviderName;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.CertStoreList;
import th.co.oga.security.pki.HouseKeeping.CertStoreParams;
import th.co.oga.security.pki.HouseKeeping.CertStoreProfile;
import th.co.oga.security.pki.Operation.CertStoreAccessFailException;
import th.co.oga.security.pki.Operation.CertStoreConstructionFailException;
import th.co.oga.security.pki.Operation.CertStoreOperation;
import th.co.oga.security.pki.Operation.CertStoreStartFailException;
import th.co.oga.security.pki.Operation.CertStoreStopFailException;
import th.co.oga.security.pki.Operation.CertStoreUpdateFailException;
import th.co.oga.security.pki.Operation.CertificateFindingFailException;
import th.co.oga.security.pki.Operation.InternalCertStore;
import th.co.oga.security.pki.Operation.PFXOperation;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operation.SecureStoreFindingFailException;
import th.co.oga.security.pki.Operation.SecureStoreOperation;
import th.co.oga.security.pki.Operation.SecureStoreSoftException;
import th.co.oga.security.pki.Operator.CryptoOperator;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSAlgorithm;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSCSRGenerator;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSCryptoOperator;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSKeyPairAlgo;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSKeyStore;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSPFXDriver;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSStoreObjectNotFoundException;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSTokenViewer;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.PinCode;
import th.co.oga.security.pki.X500.DName;
import th.co.oga.security.utils.SysEnv;

public class JSSStoreOperator
extends SecureStoreOperator
implements SecureStoreOperation,
InternalCertStore {
    private SecureProviderName providerName = SecureProviderName.MOZILLA_JSS;
    private CryptoManager manager;
    private PK11Token storeToken;
    private boolean build = false;
    private String base;
    private KeyStore keyStore;
    private CertStoreProfile defaultCSP;
    private PBEAlgorithm PKCS8EncryptAlgorithm = PBEAlgorithm.PBE_SHA1_DES3_CBC;
    private String PRNGAlgorithmName = "pkcs11prng";

    public JSSStoreOperator(CryptoManager manager, PK11Token storeToken) {
        super(new JSSAlgorithm());
        this.manager = manager;
        this.storeToken = storeToken;
        this.defaultCSP = new CertStoreProfile(this);
        super.setCertStore(this.defaultCSP);
    }

    private X509Certificate getInternalCert(CertProfile cer) throws JSSStoreObjectNotFoundException {
        byte[] issuer = cer.getX509Cert().getIssuerX500Principal().getEncoded();
        INTEGER sn = new INTEGER(cer.getSerialNumber());
        try {
            return this.manager.findCertByIssuerAndSerialNumber(issuer, sn);
        }
        catch (TokenException e) {
            throw new JSSStoreObjectNotFoundException("Token error while Certificate ", e.toString());
        }
        catch (ObjectNotFoundException e) {
            throw new JSSStoreObjectNotFoundException("Issuer and Serail number Certificate ", e.toString());
        }
    }

    public String getName() {
        return "Mozilla JSS secure store operator";
    }

    private String getCertId(CertProfile cert) throws ASN1Exception {
        String issuer = DName.getInstance(cert.getX509Cert().getIssuerX500Principal()).getCommonName();
        String subj = DName.getInstance(cert.getX509Cert().getSubjectX500Principal()).getCommonName();
        if (cert.isCA()) {
            return String.valueOf(issuer) + " - " + subj;
        }
        return String.valueOf(subj) + " - " + issuer;
    }

    public void setParameters(Properties params) {
    }

    public PFXOperation getPKCS12Device() throws SecureStoreException {
        try {
            return new JSSPFXDriver();
        }
        catch (Exception e) {
            throw new SecureStoreException(e.toString());
        }
    }

    public void importPrivateKey(byte[] stream, String algo) throws SecureStoreException, SecureStoreSoftException {
        try {
            PK11Store ksStore = (PK11Store)this.storeToken.getCryptoStore();
            ksStore.importPrivateKey(stream, JSSKeyPairAlgo.getPrivateKeyType(algo));
        }
        catch (KeyAlreadyImportedException e) {
            throw new SecureStoreSoftException("Warning " + e.toString());
        }
        catch (TokenException e) {
            throw new SecureStoreException("Error while import private key " + e.toString());
        }
    }

    public void importKeyPair(KeyPair keys) throws SecureStoreException, SecureStoreSoftException {
        this.importPrivateKey(keys.getPrivate().getEncoded(), keys.getPrivate().getAlgorithm());
    }

    public void importCertPackage(CertPackage certPackage) throws CertPackageException, CertPackageTypeNotSupportException {
        if (certPackage instanceof CertProfile) {
            try {
                this.importCertProfile((CertProfile)certPackage);
            }
            catch (Exception e) {
                throw new CertPackageException("Certificate", e.getMessage());
            }
        } else if (certPackage instanceof CertChain) {
            this.importCertChain(certPackage);
        } else if (certPackage instanceof PFXProfile) {
            this.importPFXProfile(certPackage);
        } else {
            throw new CertPackageTypeNotSupportException(certPackage.getType().getName());
        }
    }

    protected void importCertChain(CertPackage certChain) throws CertChainException {
        try {
            java.security.cert.X509Certificate[] certs = certChain.getX509Certs();
            int i = 0;
            while (i < certs.length) {
                CertProfile cp = new CertProfile(certs[i]);
                this.importCertProfile(cp);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CertChainException(e.toString());
        }
    }

    protected void importPFXProfile(CertPackage pfxProfile) throws CertPackageException {
        PK11Store ksStore = (PK11Store)this.storeToken.getCryptoStore();
        try {
            if (!this.storeToken.isLoggedIn()) {
                System.out.println("Key store is safe.");
                throw new CertPackageException("JSSStoreOperator", "Privacy room is start in unsafe mode please initial PIN and import again.");
            }
        }
        catch (TokenException e) {
            throw new CertPackageException("JSSStoreOperator", "Internal key store error," + e.toString());
        }
        Iterator contents = pfxProfile.getContent();
        try {
            System.out.println("Import PFX Profile --> Store token :" + this.storeToken.getName());
            while (contents.hasNext()) {
                CertPackageRecord cpr = (CertPackageRecord)contents.next();
                if (cpr.recordOf(CertPackageRecord.PrivateKeyInfoRec)) {
                    System.out.println(" -- Key entry --");
                    PrivateKey priv = (PrivateKey)cpr.get(1);
                    JSSKeyPairAlgo kType = JSSKeyPairAlgo.getInstance(priv.getAlgorithm());
                    try {
                        System.out.println("\tPrivate key algorithm :" + priv.getAlgorithm());
                        System.out.println("\tKey tpye is :" + kType.getPKType());
                        ksStore.importPrivateKey(priv.getEncoded(), kType.getPKType());
                    }
                    catch (KeyAlreadyImportedException e) {
                        System.out.println("\tKey is already imported.");
                    }
                    catch (TokenException e) {
                        throw new CertPackageException("JSSStoreOperator", "Error while import private key," + e.getMessage());
                    }
                }
                if (!cpr.recordOf(CertPackageRecord.CertificateRec)) continue;
                CertProfile cp = new CertProfile((java.security.cert.X509Certificate)cpr.get(1));
                System.out.println(" -- Certificate entry -- ");
                System.out.println("\t#" + cp.getFriendlyName());
                if (!this.defaultCSP.is(this.csp)) {
                    this.defaultCSP.getCertStore().setCert(cp);
                }
                this.importCertProfile(cp);
            }
            System.out.println("Finish import PFX Profile ");
        }
        catch (Exception e) {
            throw new PFXProfileException("\r\n " + e.toString());
        }
    }

    protected void importCertProfile(CertProfile cert) throws CertStoreUpdateFailException, CertStoreStartFailException {
        this.csp.getCertStore().setCert(cert);
    }

    public void trustCert(CertProfile cert) throws Exception {
        byte[] cerInBytes = cert.getBytes();
        String fn = this.getCertId(cert);
        InternalCertificate newcert = this.manager.importCertToPerm(this.manager.importCACertPackage(cerInBytes), fn);
        newcert.setSSLTrust(3);
    }

    public void importCRL(X509CRL crl, CertProfile caCer) throws SecureStoreException {
        try {
            this.manager.importCRL(crl.getEncoded(), null);
        }
        catch (CRLImportException e) {
            throw new SecureStoreException("Error while import CRL makesure was CA certificate stored, " + e.getMessage());
        }
        catch (TokenException e) {
            throw new SecureStoreException("Crypto Token Fail, " + e.getMessage());
        }
        catch (CRLException e) {
            throw new SecureStoreException(" CRL encoding fail, " + e.getMessage());
        }
    }

    public boolean isRequireCRL() {
        return true;
    }

    public CertChain getCertChain(CertProfile leaf) throws SecureStoreException {
        try {
            CertChain certChain = new CertChain();
            X509Certificate[] xCerts = this.manager.buildCertificateChain(this.getInternalCert(leaf));
            certChain.importFromStream(this.manager.exportCertsToPKCS7(xCerts), CertPackageEncodingFormat.P7);
            return certChain;
        }
        catch (Exception e) {
            throw new SecureStoreException("Error on Certificate Chain build as miner message:" + e.toString());
        }
    }

    public CertChain getCertChain(CertProfile root, CertProfile leaf) throws SecureStoreException {
        try {
            X509Certificate[] xCerts = new X509Certificate[]{(X509Certificate)ASN1Util.decode((ASN1Template)Certificate.getTemplate(), (byte[])root.getBytes()), (X509Certificate)ASN1Util.decode((ASN1Template)Certificate.getTemplate(), (byte[])leaf.getBytes())};
            CertChain certChain = new CertChain();
            certChain.importFromStream(this.manager.exportCertsToPKCS7(xCerts), CertPackageEncodingFormat.P7);
            return certChain;
        }
        catch (Exception e) {
            throw new SecureStoreException("Error on Certificate Chain build as miner message:" + e.toString());
        }
    }

    public PFXProfile getPFX(CertProfile cer, PinCode pin) throws SecureStoreException {
        CertChain chain = this.getCertChain(cer);
        Password passcode = new Password(pin.getPassword());
        Password nulpass = new Password(new char[1]);
        PrivateKeyInfo pki = null;
        try {
            PK11Store ksStore = (PK11Store)this.storeToken.getCryptoStore();
            X509Certificate xCert = this.getInternalCert(cer);
            ByteArrayInputStream bin = new ByteArrayInputStream(ksStore.getEncryptedPrivateKeyInfo(xCert, this.PKCS8EncryptAlgorithm, nulpass, 3));
            EncryptedPrivateKeyInfo epki = (EncryptedPrivateKeyInfo)EncryptedPrivateKeyInfo.getTemplate().decode((InputStream)bin);
            bin.close();
            try {
                pki = epki.decrypt(nulpass, null);
            }
            catch (Exception e) {
                throw new SecureStoreException("Fail to decrypt epki, " + e.toString());
            }
        }
        catch (Exception e) {
            throw new SecureStoreException("Error while build private key info, " + e.toString());
        }
        try {
            PFXProfile pfx = new PFXProfile(new JSSPFXDriver(), pin);
            pfx.addKeyEntry((PrivateKey)pki, chain);
            return pfx;
        }
        catch (Exception e) {
            throw new SecureStoreException("Error build PFXprofile, " + e.toString());
        }
    }

    public PrivateKey getJCAPrivateKey(CertProfile cer) throws SecureStoreException, SecureStoreFindingFailException {
        Password nulpass = new Password(new char[1]);
        try {
            PK11PrivKey p11k = (PK11PrivKey)this.getPrivateKey(cer);
            CryptoToken ct = p11k.getOwningToken();
            X509Certificate xCert = this.getInternalCert(cer);
            if (ct.getName().equalsIgnoreCase("Internal Key Storage Token")) {
                PK11Store ksStore = (PK11Store)this.storeToken.getCryptoStore();
                ByteArrayInputStream bin = new ByteArrayInputStream(ksStore.getEncryptedPrivateKeyInfo(xCert, this.PKCS8EncryptAlgorithm, nulpass, 3));
                EncryptedPrivateKeyInfo epki = (EncryptedPrivateKeyInfo)EncryptedPrivateKeyInfo.getTemplate().decode((InputStream)bin);
                bin.close();
                PrivateKeyInfo pki = epki.decrypt(nulpass, null);
                KeyFactory kf = KeyFactory.getInstance(pki.getAlgorithm());
                PKCS8EncodedKeySpec p8k = new PKCS8EncodedKeySpec(ASN1Util.encode((ASN1Value)pki));
                return kf.generatePrivate(p8k);
            }
            PK11Store ksStore = (PK11Store)ct.getCryptoStore();
            try {
                this.keyStore = new JSSKeyStore();
                this.keyStore.load(null, null);
                Enumeration<String> als = this.keyStore.aliases();
                while (als.hasMoreElements()) {
                    String a = als.nextElement();
                    System.out.println("Alias " + a);
                    System.out.println("Asso key :" + this.keyStore.getKey(a, null));
                }
                return p11k;
            }
            catch (KeyStoreException e) {
                throw new SecureStoreException("The KeyStore build fail as message :" + e.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SecureStoreException("Error while build private key info, " + e.toString());
        }
    }

    public byte[] getEncryptedPrivateKey(CertProfile cer, PinCode pin) throws SecureStoreException {
        Password passcode = new Password(pin.getPassword());
        Password nulpass = new Password(new char[1]);
        try {
            PK11Store ksStore = (PK11Store)this.storeToken.getCryptoStore();
            String fn = this.getCertId(cer);
            X509Certificate xCert = this.getInternalCert(cer);
            PK11PrivKey p11k = (PK11PrivKey)this.getPrivateKey(cer);
            CryptoToken ct = p11k.getOwningToken();
            int itr = 3;
            if (ct.getName().equalsIgnoreCase("Internal Key Storage Token")) {
                itr = 3;
            } else {
                System.out.println("Iteration is " + itr);
                itr = 1;
            }
            AlgorithmIdentifier algoId = new AlgorithmIdentifier(this.PKCS8EncryptAlgorithm.toOID());
            OCTET_STRING epkiOC = new OCTET_STRING(ksStore.getEncryptedPrivateKeyInfo(xCert, this.PKCS8EncryptAlgorithm, passcode, itr));
            EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(algoId, epkiOC);
            return ASN1Util.encode((ASN1Value)epki);
        }
        catch (Exception e) {
            throw new SecureStoreException("Private key not found as error message:" + e.toString());
        }
    }

    public List getCertificates(String certGroup) throws SecureStoreException {
        try {
            if ("CA Certificate".equalsIgnoreCase(certGroup)) {
                return this.getCACerts();
            }
            if ("USER Certificate".equalsIgnoreCase(certGroup)) {
                return this.getUserCerts();
            }
            if ("TRUSTED Certificate".equalsIgnoreCase(certGroup)) {
                return this.getAllCerts();
            }
            throw new SecureStoreException("Not support cert group ");
        }
        catch (Exception e) {
            throw new SecureStoreException("Certificate group " + certGroup + " list error, " + e.toString());
        }
    }

    public CertProfile getIssuerCertificate(CertProfile userCert) throws CertProfileException, IOException, CertificateException, EntryNotFoundException {
        X500Principal pcp = userCert.getX509Cert().getIssuerX500Principal();
        X509Certificate[] cers = this.manager.getCACerts();
        int c = 0;
        while (c < cers.length) {
            CertProfile cp = CertProfile.getInstance(cers[c].getEncoded());
            if (cp.getX509Cert().getSubjectX500Principal().equals(pcp)) {
                return cp;
            }
            ++c;
        }
        throw new EntryNotFoundException("Issuer's Certificate");
    }

    private List getUserCerts() throws CertificateException, TokenException, ASN1Exception, IOException, CertProfileException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X509");
        ArrayList<InternalCertProfile> certList = new ArrayList<InternalCertProfile>();
        X509Certificate[] certs = this.manager.getPermCerts();
        int i = 0;
        while (i < certs.length) {
            CertProfile cp = CertProfile.getInstance(certs[i].getEncoded());
            if (!cp.isCA()) {
                try {
                    this.manager.findPrivKeyByCert(certs[i]);
                    certList.add(new InternalCertProfile(cp, certs[i].getNickname()));
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return certList;
    }

    private List getCACerts() throws CertStoreAccessFailException {
        try {
            return this.csp.getCertStore().getCerts("RootCertificates").getList();
        }
        catch (CertStoreStartFailException e) {
            throw new CertStoreAccessFailException(e.toString());
        }
    }

    public List getAllCerts() throws CertStoreAccessFailException {
        try {
            return this.csp.getCertStore().getCerts("TrustedCertificates").getList();
        }
        catch (CertStoreStartFailException e) {
            throw new CertStoreAccessFailException(e.toString());
        }
    }

    public void deleteCertPackage(CertProfile certProfile) throws SecureStoreException {
        try {
            if (!this.defaultCSP.is(this.csp)) {
                this.defaultCSP.getCertStore().removeCert(certProfile);
            }
            this.csp.getCertStore().removeCert(certProfile);
        }
        catch (CertStoreUpdateFailException e) {
            throw new SecureStoreException("Can not update data tor certificate store " + e.toString());
        }
        catch (CertStoreStartFailException e) {
            throw new SecureStoreException("Can not start certificate store " + e.toString());
        }
    }

    public void deletePrivateKey(KeyPair keyPair) throws SecureStoreException {
        try {
            PK11Store ksStore = (PK11Store)this.storeToken.getCryptoStore();
            ksStore.deletePrivateKey((org.mozilla.jss.crypto.PrivateKey)((PK11PrivKey)keyPair.getPrivate()));
        }
        catch (Exception e) {
            throw new SecureStoreException("Private key delete error," + e.toString());
        }
    }

    public CSRGeneration getCSRGenerator() throws SecureStoreException {
        try {
            return new JSSCSRGenerator(this);
        }
        catch (Exception e) {
            throw new SecureStoreException(e.toString());
        }
    }

    public KeyStore getKeyStore() throws SecureStoreException {
        throw new SecureStoreException("Store Operator not support Java Key store functionalities ");
    }

    public String getKeyIdentifier(Key key) {
        return null;
    }

    public PrivateKey getPrivateKey(CertProfile cer) throws SecureStoreFindingFailException {
        X509Certificate inCert;
        if (cer == null) {
            throw new SecureStoreFindingFailException(this.providerName.getProviderInstance(), "Certificate by issuer and serialnumber  ", " the supplied certificate is null");
        }
        try {
            inCert = this.getInternalCert(cer);
        }
        catch (Exception e) {
            throw new SecureStoreFindingFailException(this.providerName.getProviderInstance(), "Find certificate by issuer and serial number  ", e.toString());
        }
        try {
            if (inCert instanceof PK11InternalTokenCert) {
                PK11InternalTokenCert p11Cert = (PK11InternalTokenCert)inCert;
                CryptoToken cryptoToken = p11Cert.getOwningToken();
            }
            return this.manager.findPrivKeyByCert(inCert);
        }
        catch (Exception e) {
            throw new SecureStoreFindingFailException(this.providerName.getProviderInstance(), "PrivateKey ", e.getMessage());
        }
    }

    public CryptoOperator getCryptoOperator() {
        return new JSSCryptoOperator(this.manager, this.getSupportAlgorithm());
    }

    public String getInfos() {
        JSSTokenViewer tv = new JSSTokenViewer(this.manager, this.storeToken);
        return tv.getInfos();
    }

    private CertProfile findCert(CertList.KeyWord key, String value) throws CertProfileNotFoundInListException, CertStoreAccessFailException {
        return this.findCert(key, value, null);
    }

    private CertProfile findCert(CertList.KeyWord key, String value1, String value2) throws CertProfileNotFoundInListException, CertStoreAccessFailException {
        CertList list = this.getCerts("TRUSTED Certificate");
        String searchValue = value1;
        if (value2 != null) {
            searchValue = String.valueOf(searchValue) + value2;
        }
        return list.getCertByRefNo(key, searchValue);
    }

    public CertProfile findCertBySubjectName(String subjectName) throws CertificateFindingFailException, CertProfileNotFoundInListException {
        try {
            return this.findCert(CertList.IDX_SUBJECT_NAME, subjectName);
        }
        catch (CertStoreAccessFailException e) {
            throw new CertificateFindingFailException("Certificate", e.toString());
        }
    }

    public CertProfile findCertByCN(String cn) throws CertificateFindingFailException, CertProfileNotFoundInListException {
        try {
            return this.findCert(CertList.IDX_CN, cn);
        }
        catch (CertStoreAccessFailException e) {
            throw new CertificateFindingFailException("Certificate", e.toString());
        }
    }

    public CertProfile findCertByEMail(String emailAddress) throws CertificateFindingFailException, CertProfileNotFoundInListException {
        try {
            return this.findCert(CertList.IDX_EMAIL, emailAddress);
        }
        catch (CertStoreAccessFailException e) {
            throw new CertificateFindingFailException("Certificate", e.toString());
        }
    }

    public CertProfile findCertByIssuerAndSerialNumber(String issuerSubjectName, String serialNumber) throws CertificateFindingFailException, CertProfileNotFoundInListException {
        try {
            return this.findCert(CertList.IDX_ISSUER_AND_SN, issuerSubjectName, serialNumber);
        }
        catch (CertStoreAccessFailException e) {
            throw new CertificateFindingFailException("Certificate", e.toString());
        }
    }

    public CertProfile getCertByRefID(String refNo) throws CertificateFindingFailException {
        throw new CertificateFindingFailException("Certificate", "Internal Certstore do not support this operation.");
    }

    public CertList getCerts() throws CertStoreAccessFailException {
        return this.getCerts("AllCertificates");
    }

    public CertList getCerts(String certGroup) throws CertStoreAccessFailException {
        int cnt = 0;
        String fn = "";
        try {
            CertList list = new CertList();
            PK11Token ksToken = (PK11Token)this.manager.getInternalKeyStorageToken();
            PK11Store ksStore = (PK11Store)this.storeToken.getCryptoStore();
            if (certGroup.equals("TrustedCertificates")) {
                X509Certificate[] certs = ksStore.getCertificates();
                int i = 0;
                while (i < certs.length) {
                    InternalCertProfile cp = new InternalCertProfile(CertProfile.getInstance(certs[i].getEncoded()), certs[i].getNickname());
                    if (!cp.isCA()) {
                        ++cnt;
                        list.setCert(cp);
                    }
                    ++i;
                }
            } else if (certGroup.equals("RootCertificates")) {
                X509Certificate[] certs = this.manager.getCACerts();
                int i = 0;
                while (i < certs.length) {
                    InternalCertProfile cp = new InternalCertProfile(CertProfile.getInstance(certs[i].getEncoded()), certs[i].getNickname());
                    if (cp.isCA()) {
                        ++cnt;
                        list.setCert(cp);
                    }
                    ++i;
                }
            } else if (certGroup.equals("AllCertificates")) {
                X509Certificate[] certs = ksStore.getCertificates();
                int i = 0;
                while (i < certs.length) {
                    ++cnt;
                    InternalCertProfile cp = new InternalCertProfile(CertProfile.getInstance(certs[i].getEncoded()), certs[i].getNickname());
                    list.setCert(cp);
                    ++i;
                }
            } else {
                throw new CertStoreAccessFailException("There are no group  " + certGroup + " in certificate store.");
            }
            return list;
        }
        catch (Exception e) {
            throw new CertStoreAccessFailException("Error while access to JSS Internal Certificate Store, " + e.toString());
        }
    }

    public void removeAllCerts() throws CertStoreUpdateFailException {
        try {
            Iterator certs = this.getCerts("AllCertificates").getIterator();
            while (certs.hasNext()) {
                CertProfile cer = (CertProfile)certs.next();
                this.removeCert(cer);
            }
        }
        catch (Exception e) {
            throw new CertStoreUpdateFailException(e.toString());
        }
    }

    public void removeCert(CertProfile cert) throws CertStoreUpdateFailException {
        try {
            PK11Store ksStore = (PK11Store)this.storeToken.getCryptoStore();
            byte[] issuer = cert.getX509Cert().getIssuerX500Principal().getEncoded();
            INTEGER sn = new INTEGER(cert.getSerialNumber());
            X509Certificate xCert = this.manager.findCertByIssuerAndSerialNumber(issuer, sn);
            PK11PrivKey pk = null;
            try {
                pk = (PK11PrivKey)this.manager.findPrivKeyByCert(xCert);
                ksStore.deletePrivateKey((org.mozilla.jss.crypto.PrivateKey)pk);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
            }
            catch (NoSuchItemOnTokenException e) {
                throw new CertStoreUpdateFailException("Private key entry delete error," + e.toString());
            }
            try {
                ksStore.deleteCert(xCert);
            }
            catch (NoSuchItemOnTokenException e) {
                throw new CertStoreUpdateFailException("Certificate entry delete error," + e.toString());
            }
        }
        catch (ObjectNotFoundException ksStore) {
        }
        catch (TokenException e) {
            throw new CertStoreUpdateFailException("JSS Key store token error while try to delete certificate, ," + e.toString());
        }
    }

    public void setCert(CertProfile cert) throws CertStoreUpdateFailException {
        try {
            byte[] cerInBytes = cert.getBytes();
            InternalCertificate incert = null;
            if (cert.isCA()) {
                incert = (InternalCertificate)this.manager.importCACertPackage(cerInBytes);
                incert.setSSLTrust(18);
            } else {
                try {
                    String fn = this.getCertId(cert);
                    this.manager.importCertToPerm(this.manager.importCertPackage(cerInBytes, fn), fn);
                }
                catch (NoSuchItemOnTokenException e) {
                    this.manager.importCACertPackage(cerInBytes);
                }
            }
        }
        catch (Exception e) {
            throw new CertStoreUpdateFailException(e.toString());
        }
    }

    public void setCertByRefID(String refNo, CertProfile cert) throws CertStoreUpdateFailException {
        throw new CertStoreUpdateFailException("Internal store do not support certificate mapping feature.");
    }

    public void setCerts(CertProfile[] certs) throws CertStoreUpdateFailException {
        try {
            int c = 0;
            while (c < certs.length) {
                this.setCert(certs[c]);
                ++c;
            }
        }
        catch (Exception e) {
            throw new CertStoreUpdateFailException(e.toString());
        }
    }

    public String getProvider() {
        return this.providerName.getName();
    }

    public CertStoreParams getParameters() {
        return new CertStoreParams();
    }

    public void start(CertStoreParams params) throws CertStoreStartFailException {
    }

    public void stop() throws CertStoreStopFailException {
    }

    public int getOperatorNumber() {
        return 0;
    }

    public static CertStoreOperation getInstance() throws CertStoreConstructionFailException {
        throw new CertStoreConstructionFailException("MozillaCertStore", " JSS Certstore do not support external certificate store operation.");
    }

    public CertStoreList getSupportedCertStore() {
        CertStoreList csl = super.getSupportedCertStore();
        try {
            csl.setCertStoreProfile(CertStoreProfile.getInstance(2));
            if (SysEnv.isOS(SysEnv.OS_WINDOWS)) {
                csl.setCertStoreProfile(CertStoreProfile.getInstance(1));
            }
        }
        catch (CertStoreConstructionFailException certStoreConstructionFailException) {
            // empty catch block
        }
        return csl;
    }

    public void setCertStore(CertStoreProfile csp) {
        if (csp == null) {
            super.setCertStore(this.defaultCSP);
        } else {
            super.setCertStore(csp);
        }
    }

    public boolean isStart() {
        return true;
    }
}

