/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.MozillaJSS;

import java.awt.event.ActionEvent;
import java.io.File;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import org.mozilla.certsetup.apps.CertSetup;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.PK11Module;
import org.mozilla.jss.pkcs11.PK11Store;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.util.IncorrectPasswordException;
import org.mozilla.jss.util.NullPasswordCallback;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;
import th.co.oga.security.pki.Engine.HSMDriver;
import th.co.oga.security.pki.Engine.SecureModule;
import th.co.oga.security.pki.Engine.SecureProviderName;
import th.co.oga.security.pki.HouseKeeping.AgentProfile;
import th.co.oga.security.pki.HouseKeeping.MessageBox;
import th.co.oga.security.pki.HouseKeeping.SaveHouse;
import th.co.oga.security.pki.Operation.TokenOperatorBuildException;
import th.co.oga.security.pki.Operation.TokenOperatorLockException;
import th.co.oga.security.pki.Operation.TokenOperatorOpenException;
import th.co.oga.security.pki.Operation.TokenOperatorOperationFailException;
import th.co.oga.security.pki.Operator.CryptoOperator;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSCryptoOperator;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSPasswordCallback;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSStoreOperator;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSTokenViewer;
import th.co.oga.security.pki.Operator.MozillaJSS.NSSTokenRegister;
import th.co.oga.security.pki.Operator.MozillaJSS.TokenDriverRegisterFailException;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.Operator.TokenOperator;
import th.co.oga.security.pki.PinCode;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.utils.monitor.OperationMonitor;
import th.co.oga.security.utils.monitor.ProgressionEvent;
import th.co.oga.security.utils.monitor.ProgressionWorker;

public class JSSTokenOperator
extends TokenOperator {
    private SecureProviderName providerName = SecureProviderName.MOZILLA_JSS;
    private CryptoManager manager;
    private PK11Token ksToken;
    private PK11Store ksStore;
    private boolean builded = false;
    private CertificateFactory certFactory;
    private KeyStore keyStore;
    private PBEAlgorithm PKCS8EncryptAlgorithm = PBEAlgorithm.PBE_MD5_DES_CBC;
    private String PRNGAlgorithmName = "pkcs11prng";

    public JSSTokenOperator(SecureModule module) {
        super(module);
        if (!SecureProviderName.findProviderName(this.providerName.getName())) {
            Security.addProvider(Utils.getJSSProvider());
        }
    }

    public void build(File safeFolder) throws TokenOperatorBuildException {
        block17: {
            SaveHouse.TraceInfo("Start PKCS#11 Device initial in " + safeFolder.getPath() + ".");
            super.build(safeFolder);
            boolean reqInstall = true;
            File certStore = new File(String.valueOf(this.getTokenFolder().getPath()) + SaveHouse.FS + "cert8.db");
            if (!certStore.exists() && SaveHouse.isWin32()) {
                try {
                    NSSTokenRegister.initNewRoom(this.getTokenFolder());
                    if (NSSTokenRegister.addPkcs11Drivers(this.getTokenFolder()) > 0) {
                        reqInstall = false;
                    }
                }
                catch (Exception e) {
                    SaveHouse.TraceInfo("New directly room initialization fail, system will create by java interface and system require to restart for external token connection.");
                }
            }
            try {
                CryptoManager.initialize((String)this.getTokenFolder().getPath());
                if (!reqInstall) break block17;
                try {
                    if (NSSTokenRegister.addPkcs11Drivers(this.getTokenFolder()) > 0) {
                        MessageBox msgBox = new MessageBox();
                        msgBox.showWarningDialog("Warning", "System just added new PKCS#11 Device, which can be worked after restart. ");
                    }
                }
                catch (TokenDriverRegisterFailException e) {
                    SaveHouse.TraceInfo("There are error while register tokens, " + e.getMessage());
                }
            }
            catch (AlreadyInitializedException e) {
                SaveHouse.TraceInfo("The crypto manager was already used by other, system be joined with the existing instance, error message " + e.toString());
            }
            catch (GeneralSecurityException e) {
                throw new TokenOperatorBuildException(this.getSecureProvider(), e.getMessage());
            }
            catch (CertDatabaseException e) {
                throw new TokenOperatorBuildException(this.getSecureProvider(), e.getMessage());
            }
            catch (KeyDatabaseException e) {
                throw new TokenOperatorBuildException(this.getSecureProvider(), e.getMessage());
            }
        }
        try {
            this.manager = CryptoManager.getInstance();
            if (SaveHouse.isWin32()) {
                this.manager.setPasswordCallback((PasswordCallback)new JSSPasswordCallback("Token PIN Authentication", "Token PIN Authentication"));
            }
        }
        catch (CryptoManager.NotInitializedException e) {
            throw new TokenOperatorBuildException(this.getSecureProvider(), e.getMessage());
        }
        try {
            this.certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new TokenOperatorBuildException(this.getSecureProvider(), e.getMessage());
        }
        this.ksToken = (PK11Token)this.manager.getInternalKeyStorageToken();
        SaveHouse.TraceInfo("Finish PKCS#11 Device initial.");
    }

    public void setPasswordCalledBack(Object pCalledBack) throws TokenOperatorOperationFailException {
        if (pCalledBack instanceof PasswordCallback) {
            try {
                this.manager = CryptoManager.getInstance();
                if (SaveHouse.isWin32()) {
                    this.manager.setPasswordCallback((PasswordCallback)pCalledBack);
                }
            }
            catch (CryptoManager.NotInitializedException e) {
                throw new TokenOperatorOperationFailException(this.getSecureProvider(), e.getMessage());
            }
        }
    }

    public void lock(PinCode pin) throws TokenOperatorLockException {
        PinCode nulPin = new PinCode(new char[1]);
        this.lock(pin, pin);
    }

    public void lock(PinCode pin, PinCode setPin) throws TokenOperatorLockException {
        Password oldPin = new Password(pin.getPassword());
        Password newPin = new Password(setPin.getPassword());
        if (!this.ksToken.isPresent()) {
            throw new TokenOperatorLockException(this.getSecureProvider(), "Key Store Token Invisible ");
        }
        try {
            if (this.ksToken.passwordIsInitialized()) {
                this.ksToken.changePassword((PasswordCallback)oldPin, (PasswordCallback)newPin);
            } else {
                this.ksToken.initPassword((PasswordCallback)oldPin, (PasswordCallback)newPin);
            }
        }
        catch (Exception e) {
            throw new TokenOperatorLockException(this.getSecureProvider(), e.toString());
        }
    }

    public boolean isSafe() {
        try {
            return this.ksToken.passwordIsInitialized();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void open(PinCode usePin) throws TokenOperatorOpenException {
        Password pin;
        SaveHouse.TraceInfo("Start Internal PKCS#11 Device authentication.");
        Password password = pin = usePin == null ? new Password(new char[1]) : new Password(usePin.getPassword());
        if (!this.ksToken.isPresent()) {
            throw new TokenOperatorOpenException(this.getSecureProvider(), " Soft PKCS11Token is invisible ");
        }
        try {
            if (this.ksToken.isLoggedIn()) {
                this.ksToken.logout();
            }
            if (this.ksToken.passwordIsInitialized()) {
                this.ksToken.login((PasswordCallback)pin);
                if (!this.ksToken.isLoggedIn()) {
                    throw new TokenOperatorOpenException(this.getSecureProvider(), " Can not open Soft PKCS11Token.");
                }
            } else {
                SaveHouse.TraceInfo("Warning privacy room open in unsafe mode !");
            }
            if (usePin != null) {
                Enumeration tks = this.manager.getExternalTokens();
                while (tks.hasMoreElements()) {
                    PK11Token p11t = (PK11Token)tks.nextElement();
                    PinCode tbpin = usePin;
                    HSMDriver driver = HSMDriver.getInstance(p11t.getName());
                    if (driver != null) {
                        tbpin = new PinCode(driver.getPin(usePin.getPassword()));
                    }
                    if (!p11t.isPresent() || p11t.getLoginMode() != 0 || p11t.isLoggedIn()) continue;
                    try {
                        p11t.login((PasswordCallback)new Password(tbpin.getPassword()));
                    }
                    catch (IncorrectPasswordException incorrectPasswordException) {
                        // empty catch block
                    }
                }
            }
            this.setOpenStatus(true);
        }
        catch (TokenException e) {
            throw new TokenOperatorOpenException(this.getSecureProvider(), e.toString());
        }
        catch (PK11Token.NotInitializedException e) {
            throw new TokenOperatorOpenException(this.getSecureProvider(), "Internal key token was not initialized, " + e.getMessage());
        }
        catch (IncorrectPasswordException e) {
            throw new TokenOperatorOpenException(this.getSecureProvider(), "Password not correct " + e.getMessage());
        }
        SaveHouse.TraceInfo("Finish Internal PKCS#11 Device authentication.");
    }

    public void reloadTokens() {
        Thread t = new Thread(new ThreadReloadToken());
        t.start();
    }

    public void open(AgentProfile agent, PinCode pin) throws TokenOperatorOpenException {
        this.open(pin);
    }

    public void close() throws TokenOperatorOperationFailException {
        try {
            if (this.ksToken.isLoggedIn()) {
                this.ksToken.logout();
            }
            this.manager.setPasswordCallback((PasswordCallback)new NullPasswordCallback());
            this.setOpenStatus(false);
        }
        catch (Exception e) {
            throw new TokenOperatorOperationFailException(this.getSecureProvider(), "Close fail " + e.toString());
        }
    }

    public void wipe() throws TokenOperatorOperationFailException {
        SaveHouse.TraceInfo("Start to wipe secret store ...");
        try {
            this.ksStore = (PK11Store)this.ksToken.getCryptoStore();
            X509Certificate[] cert = this.ksStore.getCertificates();
            int i = 0;
            while (i < cert.length) {
                this.ksStore.deleteCert(cert[i]);
                ++i;
            }
            SaveHouse.TraceInfo("Remove all private key entries.");
            PrivateKey[] prvs = this.ksStore.getPrivateKeys();
            int i2 = 0;
            while (i2 < prvs.length) {
                this.ksStore.deletePrivateKey(prvs[i2]);
                ++i2;
            }
            SaveHouse.TraceInfo("Remove all certificate entries.");
            X509Certificate[] caCers = this.manager.getCACerts();
            int i3 = 0;
            while (i3 < caCers.length) {
                this.ksStore.deleteCert(caCers[i3]);
                ++i3;
            }
            if (this.isOpened()) {
                SaveHouse.TraceInfo("Close cert store.");
                this.close();
            }
            CertSetup dc = new CertSetup();
            dc.closeDatabases();
            SaveHouse.TraceInfo("Delete repositories.");
            File folder = this.getTokenFolder();
            File[] files = folder.listFiles();
            int i4 = 0;
            while (i4 < files.length) {
                SaveHouse.TraceInfo("File " + files[i4].getName());
                files[i4].delete();
                ++i4;
            }
            folder.delete();
        }
        catch (Exception e) {
            throw new TokenOperatorOperationFailException(this.getSecureProvider(), e.toString());
        }
        SaveHouse.TraceInfo("Finish wipe secret store ...");
    }

    public String about() {
        String aboutText = super.about();
        JSSTokenViewer viewer = new JSSTokenViewer(this.manager, this.ksToken);
        return String.valueOf(aboutText) + "\r\n" + viewer.about();
    }

    public CryptoOperator getCeryptoOperator() {
        return new JSSCryptoOperator(this.manager);
    }

    public SecureStoreOperator getStoreOperator() {
        return new JSSStoreOperator(this.manager, this.ksToken);
    }

    class ThreadReloadToken
    implements Runnable,
    ProgressionWorker {
        private OperationMonitor mon = new OperationMonitor("Token Scanner");
        private int state = 0;
        private String operation = "";
        private int cnt = 0;

        ThreadReloadToken() {
            int cnt = 0;
            Enumeration modules = JSSTokenOperator.this.manager.getModules();
            while (modules.hasMoreElements()) {
                modules.nextElement();
                ++cnt;
            }
            Enumeration tks = JSSTokenOperator.this.manager.getExternalTokens();
            while (tks.hasMoreElements()) {
                tks.nextElement();
                ++cnt;
            }
            this.mon.setLength(0, cnt);
            this.mon.addActionListener(this);
            this.mon.progressionPerformed(new ProgressionEvent(this, 0, ProgressionEvent.INIT));
            this.mon.active();
        }

        void sleep() {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void run() {
            Enumeration modules = JSSTokenOperator.this.manager.getModules();
            while (modules.hasMoreElements()) {
                PK11Module p11m = (PK11Module)modules.nextElement();
                if (!p11m.getName().equals("NSS Internal PKCS #11 Module")) {
                    p11m.reloadTokens();
                }
                this.operation = "Process on module  " + p11m.getName();
                this.mon.progressionPerformed(new ProgressionEvent(this, this.cnt, ProgressionEvent.PROCESS));
                ++this.cnt;
                this.sleep();
            }
            try {
                Enumeration tks = JSSTokenOperator.this.manager.getExternalTokens();
                while (tks.hasMoreElements()) {
                    PK11Token p11t = (PK11Token)tks.nextElement();
                    if (p11t.isPresent() && !p11t.isLoggedIn()) {
                        p11t.login((PasswordCallback)new JSSPasswordCallback("PIN Authen", "PIN Authen"));
                    }
                    this.operation = "Process on token " + p11t.getName();
                    this.mon.progressionPerformed(new ProgressionEvent(this, this.cnt, ProgressionEvent.PROCESS));
                    ++this.cnt;
                    this.sleep();
                }
                JSSTokenOperator.this.setOpenStatus(true);
                this.operation = "Done";
                this.mon.progressionPerformed(new ProgressionEvent(this, this.cnt, ProgressionEvent.DONE));
            }
            catch (TokenException e) {
                this.operation = "Fail " + e.toString();
                this.mon.progressionPerformed(new ProgressionEvent(this, this.cnt, ProgressionEvent.DONE));
            }
            catch (IncorrectPasswordException e) {
                this.operation = "Fail " + e.toString();
                this.mon.progressionPerformed(new ProgressionEvent(this, this.cnt, ProgressionEvent.DONE));
            }
        }

        public void abortPerformed(ActionEvent e) {
            this.mon.progressionPerformed(new ProgressionEvent(this, this.cnt, ProgressionEvent.ABORT));
        }

        public void stopPerformed(ActionEvent e) {
            this.mon.deactive();
        }

        public String getOperationName() {
            return this.operation;
        }
    }
}

