/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.MozillaJSS;

import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.PK11InternalTokenCert;
import org.mozilla.jss.pkcs11.PK11Module;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.pkcs11.PK11Store;
import org.mozilla.jss.pkcs11.PK11Token;
import th.co.oga.security.pki.Engine.SecureProviderName;

public class JSSTokenViewer {
    private SecureProviderName providerName = SecureProviderName.MOZILLA_JSS;
    private CryptoManager manager;
    private PK11Token storeToken;
    private boolean build = false;
    private String base;

    public JSSTokenViewer(CryptoManager manager, PK11Token storeToken) {
        this.manager = manager;
        this.storeToken = storeToken;
    }

    public String about() {
        PK11Token tk;
        StringBuffer aboutText = new StringBuffer("\tSecure Provider Name :" + this.providerName.getName());
        aboutText.append("\r\n \tVersion detail :\r\n \t\tDBM_VERSION = N/A\r\n \t\t JDK_VERSION = N/A\r\n \t\t JSS_VERSION = JSS_4_2_BETA\r\n \t\t NSPR_VERSION = NSPR_4_5_RTM\r\n \t\t NSS_VERSION = NSS_3_11_RTM");
        aboutText.append("\r\n \tToken list:");
        Enumeration emr = this.manager.getAllTokens();
        while (emr.hasMoreElements()) {
            PK11Token p11t = (PK11Token)emr.nextElement();
            aboutText.append("\r\n \t\t name:" + p11t.getName());
            aboutText.append("\r\n \t\t\t Type:" + (p11t.isInternalCryptoToken() ? "Intenal" : "External PKCS#11 "));
            try {
                aboutText.append("\r\n \t\t\t login mode:" + this.loginMode(p11t.getLoginMode()));
                aboutText.append("\r\n \t\t\t Activation status:" + (p11t.isPresent() ? "Active" : "Not Active"));
                aboutText.append("\r\n \t\t\t Authentication status:" + (p11t.isLoggedIn() ? "Loged in" : "Not yet"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        aboutText.append("\r\n \tModule list:");
        Enumeration ms = this.manager.getModules();
        while (ms.hasMoreElements()) {
            aboutText.append("\r\n \t\t" + ((PK11Module)ms.nextElement()).getName());
        }
        aboutText.append("\r\n\t Support RSA Token");
        Enumeration e = this.manager.getTokensSupportingAlgorithm(KeyPairAlgorithm.RSAFamily);
        while (e.hasMoreElements()) {
            tk = (PK11Token)e.nextElement();
            aboutText.append("\r\n \t\t" + tk.getName());
        }
        aboutText.append("\r\n\t Support DSA Token");
        e = this.manager.getTokensSupportingAlgorithm(KeyPairAlgorithm.DSAFamily);
        while (e.hasMoreElements()) {
            tk = (PK11Token)e.nextElement();
            aboutText.append("\r\n\t\t" + tk.getName());
        }
        return aboutText.toString();
    }

    public String loginMode(int mode) {
        if (mode == 2) {
            return "Every time";
        }
        if (mode == 0) {
            return "One time";
        }
        if (mode == 1) {
            return "Time Out";
        }
        return "Not supported";
    }

    public String getInfos() {
        StringBuffer info = new StringBuffer(this.about());
        PK11Store ksStore = (PK11Store)this.storeToken.getCryptoStore();
        info.append("\r\n\r\nAll entries ...");
        info.append("\r\nAll Perm Certificate in token :");
        X509Certificate[] xcer = this.manager.getPermCerts();
        int i = 0;
        while (i < xcer.length) {
            info.append("\r\n\t Cert:" + xcer[i].getNickname());
            if (xcer[i] instanceof PK11InternalTokenCert) {
                PK11InternalTokenCert pk11Cert = (PK11InternalTokenCert)xcer[i];
                try {
                    info.append(" Owning:" + pk11Cert.getOwningToken().getName());
                }
                catch (TokenException e) {
                    info.append(" Get owning token fail .");
                }
            }
            ++i;
        }
        info.append("\r\nAll Trusted Authority Certificates in token :");
        X509Certificate[] caCers = this.manager.getCACerts();
        int i2 = 0;
        while (i2 < caCers.length) {
            info.append("\r\n\t CA's Cert:" + caCers[i2].getNickname());
            ++i2;
        }
        info.append("\r\nAll Certificates in interenal key store token :");
        try {
            X509Certificate[] cers = ksStore.getCertificates();
            int i3 = 0;
            while (i3 < cers.length) {
                info.append("\r\n\t Poeple's Cert:" + cers[i3].getNickname());
                ++i3;
            }
        }
        catch (TokenException e) {
            info.append("\r\n Store Token failure .");
        }
        info.append("\r\nAll Personal key in token :");
        try {
            PrivateKey[] keys = ksStore.getPrivateKeys();
            int i4 = 0;
            while (i4 < keys.length) {
                PK11PrivKey pk = (PK11PrivKey)keys[i4];
                info.append("\r\n\t Algorithm:" + pk.getAlgorithm() + " Strength:" + pk.getStrength());
                ++i4;
            }
        }
        catch (TokenException e) {
            info.append("\r\n Store Token failure .");
        }
        info.append("\r\nAll Tokens Infos :");
        Enumeration tokens = this.manager.getExternalTokens();
        while (tokens.hasMoreElements()) {
            PK11Token token = (PK11Token)tokens.nextElement();
            info.append("\r\n\t" + token.getName() + "/ Provider:" + token.getProvider() + "/");
            try {
                info.append("[ ");
                info.append(token.isLoggedIn() ? "Logedin" : "");
                info.append(token.isPresent() ? " Active " : " NotActive ");
                info.append(token.isWritable() ? " Writable " : " Readonly ");
                info.append(token.isInternalCryptoToken() ? " InternalCryptoToken" : "");
                info.append(token.isInternalKeyStorageToken() ? " InternalKeyStoreToken" : "");
                info.append(" ]");
            }
            catch (TokenException e) {
                info.append(" Get token info failure .");
            }
        }
        return info.toString();
    }
}

