/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.MozillaJSS;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.pkcs11.PK11Module;
import th.co.oga.security.pki.Engine.HSMDriver;
import th.co.oga.security.pki.HouseKeeping.SaveHouse;
import th.co.oga.security.pki.Operator.MozillaJSS.PhysicalCertStoreInitialFailException;
import th.co.oga.security.pki.Operator.MozillaJSS.TokenDriverRegisterFailException;

public class NSSTokenRegister {
    public static int addPkcs11Drivers(File dbFile) throws TokenDriverRegisterFailException {
        boolean checked = false;
        ArrayList<String> chkList = new ArrayList<String>();
        try {
            CryptoManager mgr = CryptoManager.getInstance();
            Enumeration mds = mgr.getModules();
            while (mds.hasMoreElements()) {
                PK11Module md = (PK11Module)mds.nextElement();
                chkList.add(md.getName());
            }
            checked = true;
        }
        catch (Exception mgr) {
            // empty catch block
        }
        int installed = 0;
        File modutil = SaveHouse.isWin32() ? new File(String.valueOf(SaveHouse.getSysBase()) + SaveHouse.FS + "bin" + SaveHouse.FS + "modutil.exe") : new File(String.valueOf(SaveHouse.getSysBase()) + SaveHouse.FS + "bin" + SaveHouse.FS + "modutil");
        if (modutil.isFile() && modutil.canRead() && modutil.exists()) {
            HSMDriver hsmDriver = new HSMDriver();
            String dbdir = dbFile.getPath();
            HSMDriver[] drivers = hsmDriver.getDrivers();
            int i = 0;
            while (i < drivers.length) {
                String libname = null;
                libname = SaveHouse.isWin32() ? drivers[i].getWinLibName() : drivers[i].getUXLibName();
                if (libname != null) {
                    if (checked) {
                        if (chkList.indexOf(drivers[i].getModuleName()) < 0) {
                            NSSTokenRegister.runCommand(modutil, drivers[i].getModuleName(), libname, dbdir);
                            installed += drivers[i].isAutocheck() ? 0 : 1;
                        }
                    } else {
                        NSSTokenRegister.runCommand(modutil, drivers[i].getModuleName(), libname, dbdir);
                        ++installed;
                    }
                }
                ++i;
            }
            return installed;
        }
        throw new TokenDriverRegisterFailException(" modutil not found on " + modutil.getPath());
    }

    public static void addDriver(HSMDriver driver, File dbFolder) throws TokenDriverRegisterFailException {
        String libfile;
        File modutil;
        if (SaveHouse.isWin32()) {
            modutil = new File(String.valueOf(SaveHouse.getSysBase()) + SaveHouse.FS + "bin" + SaveHouse.FS + "modutil.exe");
            libfile = driver.getWinLibName();
        } else {
            modutil = new File(String.valueOf(SaveHouse.getSysBase()) + SaveHouse.FS + "bin" + SaveHouse.FS + "modutil");
            libfile = driver.getUXLibName();
        }
        if (libfile != null) {
            if (modutil.isFile() && modutil.canRead() && modutil.exists()) {
                NSSTokenRegister.runCommand(modutil, driver.getModuleName(), libfile, dbFolder.getPath());
            } else {
                throw new TokenDriverRegisterFailException(" modutil not found on " + modutil.getPath());
            }
        }
    }

    private static void runCommand(File modutil, String module, String libfile, String dbdir) throws TokenDriverRegisterFailException {
        block4: {
            Runtime runner = Runtime.getRuntime();
            String command = String.valueOf(modutil.getPath()) + " -force -add " + "\"" + module + "\"" + " -libfile " + libfile + " -dbdir " + "\"" + dbdir + "\"";
            try {
                int b;
                Process process = runner.exec(command);
                InputStream in = process.getInputStream();
                ByteArrayOutputStream buff = new ByteArrayOutputStream();
                while ((b = in.read()) > -1) {
                    buff.write(b);
                }
                in.close();
                String returnText = buff.toString();
                if (returnText.startsWith("Using database directory")) {
                    SaveHouse.TraceInfo("Installed bundled driver for " + module);
                    break block4;
                }
                throw new TokenDriverRegisterFailException(module, libfile, dbdir, "Command=" + command + " return=" + returnText);
            }
            catch (IOException e) {
                throw new TokenDriverRegisterFailException(module, libfile, dbdir, e.toString());
            }
        }
    }

    public static void initNewRoom(File dbdir) throws PhysicalCertStoreInitialFailException {
        block5: {
            File nssInitiator = new File(String.valueOf(SaveHouse.getSysBase()) + SaveHouse.FS + "bin" + SaveHouse.FS + "nssinitiator.exe");
            if (nssInitiator.isFile() && nssInitiator.canRead() && nssInitiator.exists()) {
                Runtime runner = Runtime.getRuntime();
                String command = String.valueOf(nssInitiator.getPath()) + " \"" + dbdir.getPath() + "\"";
                try {
                    int b;
                    Process process = runner.exec(command);
                    InputStream in = process.getInputStream();
                    ByteArrayOutputStream buff = new ByteArrayOutputStream();
                    while ((b = in.read()) > -1) {
                        buff.write(b);
                    }
                    in.close();
                    String returnText = buff.toString();
                    if (returnText.startsWith("YES")) {
                        System.out.println("Initial new cert database in" + dbdir.getPath());
                        SaveHouse.TraceInfo("NSS Initiator successfully create new certificate store in " + dbdir.getPath() + ".");
                        break block5;
                    }
                    SaveHouse.TraceInfo("NSS Initiator fail, system will be need to restart for connect to external token.");
                    throw new PhysicalCertStoreInitialFailException(dbdir.getPath());
                }
                catch (IOException e) {
                    SaveHouse.TraceInfo("NSS Initiator fail," + e.toString() + ", system will be need to restart for connect to external token.");
                    throw new PhysicalCertStoreInitialFailException(e.toString());
                }
            }
            SaveHouse.TraceInfo("NSS Initiator does not exist, system will be need to restart for connect to external token.");
        }
    }
}

