/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import th.co.oga.security.pki.Certification.CertPackageRecord;
import th.co.oga.security.pki.Operation.PFXAdapterException;
import th.co.oga.security.pki.Operation.PFXOperation;
import th.co.oga.security.pki.PinCode;
import th.co.oga.security.pki.Utils;

public class PFXDriver
implements PFXOperation {
    private ArrayList contents = new ArrayList();
    private KeyStore pfxLoader;
    private KeyStore pfxWriter;

    public String getName() {
        return "General SUN JCE PFX Driver";
    }

    public void renew() throws PFXAdapterException {
    }

    public void load(InputStream in, PinCode pin) throws PFXAdapterException {
        try {
            this.pfxLoader = KeyStore.getInstance("PKCS12");
            this.pfxLoader.load(in, pin.getPassword());
        }
        catch (Exception e) {
            throw new PFXAdapterException(String.valueOf(this.getName()) + " Error while load PFX to loader, " + e.getMessage());
        }
    }

    public Iterator read(PinCode pin) throws PFXAdapterException {
        this.contents = new ArrayList();
        try {
            Enumeration<String> als = this.pfxLoader.aliases();
            while (als.hasMoreElements()) {
                String a = als.nextElement();
                if (this.pfxLoader.isCertificateEntry(a)) {
                    Certificate cer = this.pfxLoader.getCertificate(a);
                    CertPackageRecord cprCer = new CertPackageRecord(CertPackageRecord.CertificateRec);
                    cprCer.add(cer);
                    this.contents.add(cprCer);
                }
                if (!this.pfxLoader.isKeyEntry(a)) continue;
                CertPackageRecord cprKey = new CertPackageRecord(CertPackageRecord.PrivateKeyInfoRec);
                PrivateKey priv = (PrivateKey)this.pfxLoader.getKey(a, pin.getPassword());
                cprKey.add(priv);
                this.contents.add(cprKey);
                Certificate[] cers = this.pfxLoader.getCertificateChain(a);
                int c = 0;
                while (c < cers.length) {
                    CertPackageRecord cprCer = new CertPackageRecord(CertPackageRecord.CertificateRec);
                    cprCer.add(cers[c]);
                    this.contents.add(cprCer);
                    ++c;
                }
            }
            return this.contents.iterator();
        }
        catch (Exception e) {
            throw new PFXAdapterException(" Error while read all entries in key store, " + e.getMessage());
        }
    }

    public void write(PrivateKey priv, X509Certificate[] xcs, PinCode pin) throws PFXAdapterException {
        try {
            try {
                this.pfxWriter = KeyStore.getInstance("PKCS12");
                this.pfxWriter.load(null, null);
            }
            catch (Exception e) {
                throw new PFXAdapterException(" Error while build PFX writer, " + e.getMessage());
            }
            X509Certificate leaf = Utils.findLeaf(xcs);
            String fn = Utils.getFriendlyName(leaf);
            if (pin == null) {
                this.pfxWriter.setKeyEntry(fn, priv.getEncoded(), xcs);
            } else {
                this.pfxWriter.setKeyEntry(fn, priv, pin.getPassword(), xcs);
            }
        }
        catch (Exception e) {
            throw new PFXAdapterException(e.toString());
        }
    }

    public void store(PinCode pin, OutputStream out) throws PFXAdapterException {
        try {
            this.pfxWriter.store(out, pin.getPassword());
        }
        catch (Exception e) {
            throw new PFXAdapterException(e.toString());
        }
    }
}

