/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Calendar;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.Certification.CertificateInvalidateException;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.Operation.CryptoOperatorException;
import th.co.oga.security.pki.Operation.DataEncryptionFailException;
import th.co.oga.security.pki.Operation.KeyWrappingFailException;
import th.co.oga.security.pki.Operation.SecureStoreFindingFailException;
import th.co.oga.security.pki.Operator.AlgorithmOperator;
import th.co.oga.security.pki.Operator.CryptoOperator;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.Utils;

public class SecureOperator
extends AlgorithmOperator {
    private SecureStoreOperator sOper;
    private CryptoOperator dataCOper;
    private CryptoOperator keyCOper;
    private CryptoOperator signOper;
    private CryptoOperator cOper;
    private AlgorithmSupportTable algoTable;
    private AlgorithmSet digestAlgos;

    public SecureOperator(SecureStoreOperator sso, CryptoOperator co) {
        super(co.getSupportAlgorithm());
        this.sOper = sso;
        this.dataCOper = sso.getCryptoOperator();
        this.keyCOper = sso.getCryptoOperator();
        this.signOper = sso.getCryptoOperator();
        this.cOper = co;
        this.algoTable = this.cOper.getSupportAlgorithm();
        this.digestAlgos = this.algoTable.getMessageDigestAlgorithm();
    }

    public SecureStoreOperator getStoreOperator() {
        return this.sOper;
    }

    public CryptoOperator getCryptoOperator() {
        return this.cOper;
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec(AlgorithmProfile alg) throws NoSuchAlgorithmException, AlgorithmSupportException {
        SecureRandom rand = this.dataCOper.getSecureRandom();
        rand.setSeed(Utils.genTimeSeed());
        return this.dataCOper.getParameterSpec(alg, rand, null);
    }

    public AlgorithmParameters getAlgorithmParameters(AlgorithmProfile alg, AlgorithmParameterSpec param) throws NoSuchAlgorithmException, InvalidParameterSpecException {
        AlgorithmParameters params = AlgorithmParameters.getInstance(alg.getEncryptionAlgorithmName());
        params.init(param);
        return params;
    }

    public AlgorithmParameters getAlgorithmParameters(AlgorithmProfile alg, byte[] param) throws NoSuchAlgorithmException, IOException {
        AlgorithmParameters params = AlgorithmParameters.getInstance(alg.getEncryptionAlgorithmName());
        params.init(param);
        return params;
    }

    public Signature getSigner(CertProfile cert, AlgorithmProfile algo) throws CryptoOperatorException {
        try {
            Signature signer = this.signOper.getSignature(algo);
            signer.initSign(this.sOper.getPrivateKey(cert));
            return signer;
        }
        catch (Exception e) {
            throw new CryptoOperatorException(" JSSSecureStore error while instantiate signer, " + e.getMessage());
        }
    }

    public Signature getVerifier(CertProfile cert, AlgorithmProfile algo) throws CryptoOperatorException {
        try {
            Signature verifier = this.signOper.getSignature(algo);
            PublicKey publ = this.signOper.retrustedPublicKey(cert.getPublicKey());
            verifier.initVerify(publ);
            return verifier;
        }
        catch (Exception e) {
            throw new CryptoOperatorException(" JSSSecureStore error while instantiate verifier, " + e.toString());
        }
    }

    public Cipher getDataEncryptor(AlgorithmProfile algo, SecretKey key, AlgorithmParameterSpec params, SecureRandom rand) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = this.dataCOper.getCipher(algo);
        String encName = algo.getEncryptionAlgorithmName();
        if (rand == null) {
            if (params == null) {
                cipher.init(1, key);
            } else {
                cipher.init(1, (Key)key, params);
            }
        } else if (params == null) {
            cipher.init(1, (Key)key, rand);
        } else {
            cipher.init(1, (Key)key, params, rand);
        }
        return cipher;
    }

    public Cipher getDataDecryptor(AlgorithmProfile algo, SecretKey key, AlgorithmParameterSpec param, AlgorithmParameters params) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (param == null && params != null) {
            try {
                param = this.dataCOper.getParameterSpec(algo, params);
            }
            catch (Exception e) {
                param = null;
            }
        }
        Cipher cipher = this.dataCOper.getCipher(algo);
        if (param == null) {
            if (params != null) {
                cipher.init(2, (Key)key, params);
            } else {
                cipher.init(2, key);
            }
        } else {
            cipher.init(2, (Key)key, param);
        }
        return cipher;
    }

    public Cipher getKeyCipher(int wrappingMode, AlgorithmProfile wrappingAlgorithm, Key wrappingKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = this.keyCOper.getCipher(wrappingAlgorithm);
        cipher.init(wrappingMode, wrappingKey);
        return cipher;
    }

    public Cipher getKeyWrapper(CertProfile cert) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException, AlgorithmSupportException {
        PublicKey key = this.keyCOper.retrustedPublicKey(cert.getX509Cert().getPublicKey());
        AlgorithmProfile wrapAlg = this.keyCOper.getSupportAlgorithm().getKeyWrapAlgorithm().findByName(key.getAlgorithm());
        return this.getKeyCipher(3, wrapAlg, key);
    }

    public Cipher getKeyUnwrapper(CertProfile cert) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, AlgorithmSupportException, CryptoOperatorException {
        try {
            PrivateKey key = this.sOper.getPrivateKey(cert);
            AlgorithmProfile wrapAlg = this.keyCOper.getSupportAlgorithm().getKeyWrapAlgorithm().findByName(key.getAlgorithm());
            return this.getKeyCipher(4, wrapAlg, key);
        }
        catch (SecureStoreFindingFailException e) {
            throw new CryptoOperatorException("Error while finding private key, " + e.getMessage());
        }
    }

    public SecretKey getSecretKey(byte[] key, AlgorithmProfile keyAlgo) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory skf = this.dataCOper.getSecretKeyFactory(keyAlgo);
        SecretKeySpec sks = new SecretKeySpec(key, keyAlgo.getKeyAlgorithmName());
        return skf.generateSecret(sks);
    }

    public byte[] hashing(byte[] data, AlgorithmProfile digestAlgo) throws NoSuchAlgorithmException {
        MessageDigest md = this.dataCOper.getMessageDigest(digestAlgo);
        return md.digest(data);
    }

    public byte[] getSignature(byte[] digest, AlgorithmProfile signingAlgo, CertProfile signerCert) throws NoSuchAlgorithmException, SecureStoreFindingFailException, InvalidKeyException, SignatureException {
        Signature signer = this.signOper.getSignature(signingAlgo);
        signer.initSign(this.sOper.getPrivateKey(signerCert));
        signer.update(digest);
        return signer.sign();
    }

    public byte[] signData(byte[] data, AlgorithmProfile signingAlgo, CertProfile signerCert) throws NoSuchAlgorithmException, AlgorithmSupportException, SecureStoreFindingFailException, InvalidKeyException, SignatureException {
        byte[] digest = this.hashing(data, this.digestAlgos.findByName(signingAlgo.getMessageDigestAlgorithmName()));
        return this.getSignature(digest, signingAlgo, signerCert);
    }

    public boolean signDataVerify(byte[] signature, byte[] data, AlgorithmProfile signingAlgo, CertProfile signerCert) throws AlgorithmSupportException, CryptoOperatorException {
        try {
            byte[] digest = this.hashing(data, this.digestAlgos.findByName(signingAlgo.getMessageDigestAlgorithmName()));
            return this.signatureVerify(signature, digest, signingAlgo, signerCert);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoOperatorException("Message Digesting fail, " + e.getMessage());
        }
    }

    public boolean signatureVerify(byte[] signature, byte[] digest, AlgorithmProfile signingAlgo, CertProfile signerCert) throws CryptoOperatorException {
        try {
            Signature verifier = this.signOper.getSignature(signingAlgo);
            verifier.initVerify(this.signOper.retrustedPublicKey(signerCert.getPublicKey()));
            verifier.update(digest);
            return verifier.verify(signature);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoOperatorException("Error while build signature verifier, " + e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new CryptoOperatorException("Error while build signature verifier, " + e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoOperatorException("Error while build signature verifier, " + e.getMessage());
        }
        catch (SignatureException e) {
            throw new CryptoOperatorException("Signature data not valid, " + e.getMessage());
        }
    }

    public void certificateVerify(CertProfile cert) throws CertificateException, IOException, CertificateInvalidateException {
        this.certificateVerify(cert, Calendar.getInstance());
    }

    public void certificateVerify(CertProfile cert, Calendar cal) throws CertificateException, IOException, CertificateInvalidateException {
        X509Certificate xcer = cert.getX509Cert();
        try {
            xcer.checkValidity(cal.getTime());
        }
        catch (Exception e) {
            throw new CertificateInvalidateException("Certificate was not validate in time " + cal.getTime() + " as detail:" + e.toString());
        }
        CertProfile issuer = null;
        try {
            issuer = this.sOper.getIssuerCertificate(cert);
        }
        catch (EntryNotFoundException e) {
            throw new CertificateInvalidateException("There are no trusted issuer's certificate in store.");
        }
        try {
            xcer.verify(issuer.getPublicKey());
        }
        catch (Exception e) {
            throw new CertificateInvalidateException("Certificate was not verified, as detail:" + e.toString());
        }
    }

    public CertProfile getCertProfile(byte[] bytes) throws IOException, CertificateException, CertProfileException {
        return CertProfile.getInstance(bytes);
    }

    public SecretKey encryptData(byte[] data, OutputStream result, AlgorithmProfile alg, String encryptionPassword) throws DataEncryptionFailException {
        try {
            SecretKey skey = this.dataCOper.genSecretKey(alg, null);
            String requiredParamAlgos = this.dataCOper.getCipherParamSupportAlgos();
            AlgorithmParameterSpec param = null;
            if (requiredParamAlgos.indexOf(alg.getEncryptionName()) > -1) {
                param = this.dataCOper.getParameterSpec(alg, this.dataCOper.getSecureRandom(), encryptionPassword);
            }
            Cipher cipher = this.getDataEncryptor(alg, skey, param, null);
            result.write(cipher.doFinal(data));
            return skey;
        }
        catch (Exception e) {
            throw new DataEncryptionFailException("SecureOperator", e.getClass().toString(), e.getMessage());
        }
    }

    public byte[] encryptData(byte[] data, AlgorithmProfile encryptionAlgo, SecretKey encryptionKey, AlgorithmParameterSpec param) throws DataEncryptionFailException {
        try {
            Cipher cipher = this.getDataEncryptor(encryptionAlgo, encryptionKey, param, null);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new DataEncryptionFailException("SecureOperator", e.getClass().toString(), e.getMessage());
        }
    }

    public byte[] encryptData(byte[] data, AlgorithmProfile alg, String key) throws DataEncryptionFailException {
        try {
            SecretKey skey = this.dataCOper.genSecretKey(alg, key);
            String requiredParamAlgos = this.dataCOper.getCipherParamSupportAlgos();
            AlgorithmParameterSpec param = null;
            if (requiredParamAlgos.indexOf(alg.getEncryptionName()) > -1) {
                param = this.dataCOper.getParameterSpec(alg, this.dataCOper.getSecureRandom(), key);
            }
            Cipher cipher = this.getDataEncryptor(alg, skey, param, null);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new DataEncryptionFailException("SecureOperator", e.getClass().toString(), e.getMessage());
        }
    }

    public byte[] decryptData(byte[] cipherText, AlgorithmProfile alg, String key) throws DataEncryptionFailException {
        try {
            SecretKey skey = this.dataCOper.genSecretKey(alg, key);
            String requiredParamAlgos = this.dataCOper.getCipherParamSupportAlgos();
            AlgorithmParameterSpec param = null;
            if (requiredParamAlgos.indexOf(alg.getEncryptionName()) > -1) {
                param = this.dataCOper.getParameterSpec(alg, this.dataCOper.getSecureRandom(), key);
            }
            Cipher cipher = this.getDataDecryptor(alg, skey, param, null);
            return cipher.doFinal(cipherText);
        }
        catch (Exception e) {
            throw new DataEncryptionFailException("SecureOperator", e.getClass().toString(), e.toString());
        }
    }

    public byte[] decryptData(byte[] cipherText, byte[] secretKey, AlgorithmProfile alg, String encryptionPassword) throws DataEncryptionFailException {
        try {
            SecretKey skey = this.dataCOper.getSecretKey(alg, secretKey);
            String requiredParamAlgos = this.dataCOper.getCipherParamSupportAlgos();
            AlgorithmParameterSpec param = null;
            if (requiredParamAlgos.indexOf(alg.getEncryptionName()) > -1) {
                param = this.dataCOper.getParameterSpec(alg, this.dataCOper.getSecureRandom(), encryptionPassword);
            }
            Cipher cipher = this.getDataDecryptor(alg, skey, param, null);
            return cipher.doFinal(cipherText);
        }
        catch (Exception e) {
            throw new DataEncryptionFailException("SecureOperator", e.getClass().toString(), e.toString());
        }
    }

    public byte[] decryptData(byte[] encryptedData, AlgorithmProfile encryptionAlgo, SecretKey encryptionKey, AlgorithmParameters params) throws DataEncryptionFailException {
        try {
            Cipher cipher = this.getDataDecryptor(encryptionAlgo, encryptionKey, null, params);
            return cipher.doFinal(encryptedData);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataEncryptionFailException("SecureOperator", e.getClass().toString(), e.getMessage());
        }
    }

    public byte[] wrapKey(SecretKey encryptionKey, CertProfile recipientCert) throws KeyWrappingFailException {
        try {
            Cipher keyWrapper = this.getKeyWrapper(recipientCert);
            return keyWrapper.wrap(encryptionKey);
        }
        catch (Exception e) {
            throw new KeyWrappingFailException("SecureOperator", e.getClass().toString(), e.getMessage());
        }
    }

    public SecretKey unwrapKey(byte[] wrappedKey, AlgorithmProfile encryptionAlgo, CertProfile recipientCert) throws KeyWrappingFailException {
        try {
            Cipher keyUnwrapper = this.getKeyUnwrapper(recipientCert);
            SecretKey unwKey = (SecretKey)keyUnwrapper.unwrap(wrappedKey, encryptionAlgo.getKeyAlgorithmName(), 3);
            return unwKey;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KeyWrappingFailException("SecureOperator", e.getClass().toString(), e.getMessage());
        }
    }
}

