/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator;

import java.io.File;
import java.security.Provider;
import th.co.oga.security.pki.Engine.SecureModule;
import th.co.oga.security.pki.HouseKeeping.AgentProfile;
import th.co.oga.security.pki.Operation.TokenOperation;
import th.co.oga.security.pki.Operation.TokenOperationNotSupportException;
import th.co.oga.security.pki.Operation.TokenOperatorBuildException;
import th.co.oga.security.pki.Operation.TokenOperatorLockException;
import th.co.oga.security.pki.Operation.TokenOperatorOpenException;
import th.co.oga.security.pki.Operation.TokenOperatorOperationFailException;
import th.co.oga.security.pki.Operator.CryptoOperator;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.PinCode;

public abstract class TokenOperator
implements TokenOperation {
    public static final int STATE_INIT = 0;
    public static final int STATE_BUILDED = 1;
    public static final int STATE_OPEN = 2;
    public static final int STATE_CLOSED = 3;
    private File tokenFolder;
    protected SecureModule module;
    protected int state;
    protected boolean openned = false;

    public TokenOperator(SecureModule module) {
        this.module = module;
    }

    public String about() {
        return "Secure Provider :" + this.module.getProvider().getInfo();
    }

    public void build(File safeFolder) throws TokenOperatorBuildException {
        this.state = 1;
        if (!safeFolder.exists()) {
            throw new TokenOperatorBuildException(this.module.getProvider(), "The safeFolder is not exist , the folder must prepaired ");
        }
        if (!safeFolder.isDirectory()) {
            throw new TokenOperatorBuildException(this.module.getProvider(), "The safeFolder is not correctly ,object must be directory ");
        }
        if (!safeFolder.isDirectory()) {
            throw new TokenOperatorBuildException(this.module.getProvider(), "The safeFolder is not correctly ,object must be directory ");
        }
        if (!safeFolder.canRead() || !safeFolder.canWrite()) {
            throw new TokenOperatorBuildException(this.module.getProvider(), "The safeFolder is not accessibility ,no correcly permission ");
        }
        if (this.module.getValue("StoreBase") == null) {
            this.tokenFolder = safeFolder;
        } else {
            this.tokenFolder = new File(safeFolder, this.module.getValue("StoreBase"));
            if (!this.tokenFolder.exists() && !this.tokenFolder.mkdir()) {
                throw new TokenOperatorBuildException(this.module.getProvider(), "Token folder create fail ");
            }
        }
    }

    public void close() throws TokenOperatorOperationFailException {
        this.state = 3;
    }

    public void reloadTokens() {
    }

    public boolean isBuilded() {
        return this.state >= 1;
    }

    public boolean isOpened() {
        return this.openned;
    }

    public boolean isSafe() {
        return true;
    }

    public abstract void lock(PinCode var1, PinCode var2) throws TokenOperatorLockException, TokenOperationNotSupportException;

    public void lock(PinCode pin) throws TokenOperatorLockException, TokenOperationNotSupportException {
    }

    public void open(PinCode pin) throws TokenOperatorOpenException {
    }

    public abstract void open(AgentProfile var1, PinCode var2) throws TokenOperatorOpenException;

    public void wipe() throws TokenOperatorOperationFailException {
    }

    public CryptoOperator getCeryptoOperator() {
        return null;
    }

    public SecureStoreOperator getStoreOperator() {
        return null;
    }

    public boolean equals(TokenOperator oper) {
        return this.equals(oper.getSecureModule());
    }

    public boolean equals(SecureModule pModule) {
        return this.module.getProvider().getName().equals(pModule.getProvider().getName()) && this.module.getValue("StoreBase").equals(pModule.getValue("StoreBase"));
    }

    public SecureModule getSecureModule() {
        return this.module;
    }

    public void setPasswordCalledBack(Object pCalledBack) throws TokenOperatorOperationFailException {
    }

    public File getTokenFolder() {
        return this.tokenFolder;
    }

    protected Provider getSecureProvider() {
        return this.module.getProvider();
    }

    protected void setOpenStatus(boolean status) {
        this.openned = status;
    }
}

