/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.WSJSDP;

import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSetName;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.OIDs;

public class JSDPAlgorithm
extends AlgorithmSupportTable {
    public JSDPAlgorithm() {
        super("JSDP V12.111");
        this.types.add(AlgorithmSetName.MESSAGE_DIGEST);
        this.types.add(AlgorithmSetName.ENCRYPTION_ALGO);
        this.types.add(AlgorithmSetName.ENCRYPT_SYMETRIC);
        this.types.add(AlgorithmSetName.ENCRYPT_ASYMETRIC);
        this.types.add(AlgorithmSetName.PASSWORD_BASE_ENCRYPTION);
        this.types.add(AlgorithmSetName.SECRET_KEY_ALGO);
        this.types.add(AlgorithmSetName.KEY_GEN_ALGO);
        this.types.add(AlgorithmSetName.KEY_PAIR_ALGO);
        this.types.add(AlgorithmSetName.KEY_WRAP_ALGO);
        this.types.add(AlgorithmSetName.SIGNATURE_ALGO);
        this.types.add(AlgorithmSetName.SECURE_RANDOM);
        this.set = new AlgorithmSet[this.types.size()];
        int i = 0;
        while (i < this.types.size()) {
            this.set[i] = new AlgorithmSet((AlgorithmSetName)this.types.get(i));
            ++i;
        }
        int idx = this.types.indexOf(AlgorithmSetName.MESSAGE_DIGEST);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.MD5, "MD5"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.SHA1, "SHA", "SHA-1:SHA:SHA1:SHA1-HMAC"));
        idx = this.types.indexOf(AlgorithmSetName.ENCRYPTION_ALGO);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.rsaEncryption, "RSA"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.dsaEncryption, "DSA"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES, "DES"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DESede, "DESede"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_ECB, "DES_ECB", "DES/ECB/NoPadding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_CBC, "DES_CBC", "DES/CBC/NoPadding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_CBC_pad, "DES_CBC_PKCS5Padding", "DES/CBC/PKCS5Padding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_3ECB, "DESede_ECB", "DESede/ECB/NoPadding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_3CBC, "DESede_CBC", "DESede/CBC/NoPadding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_3CBC_pad, "DESede_CBC_PKCSPadding", "DESede/CBC/PKCS5Padding"));
        idx = this.types.indexOf(AlgorithmSetName.ENCRYPT_SYMETRIC);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_ECB, "DES_ECB", "DES/ECB/NoPadding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_CBC, "DES_CBC", "DES/CBC/NoPadding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_CBC_pad, "DES_CBC_PKCS5Padding", "DES/CBC/PKCS5Padding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_3ECB, "DESede_ECB", "DESede/ECB/NoPadding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_3CBC, "DESede_CBC", "DESede/CBC/NoPadding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_3CBC_pad, "DESede_CBC_PKCSPadding", "DESede/CBC/PKCS5Padding"));
        idx = this.types.indexOf(AlgorithmSetName.ENCRYPT_ASYMETRIC);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.rsaEncryption, "RSA"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.dsaEncryption, "DSA"));
        idx = this.types.indexOf(AlgorithmSetName.PASSWORD_BASE_ENCRYPTION);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithMD2AndDES_CBC, "PBEWithMD2AndDESCBC", "PBE/MD2/DES/CBC"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithMD5AndDES_CBC, "PBEWithMD5AndDESCBC", "PBE/MD5/DES/CBC"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithSHA1AndDES_CBC, "PBEWithSHA1AndDESCBC", "PBE/SHA1/DES/CBC"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithSHA1AndDES3_CBC, "PBEWithSHA1AndDESedeCBC", "PBE/SHA1/DESEDE/CBC"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithSHA1AndRC2128_CBC, "PBEWithSHA1And128RC2CBC", "PBE/SHA1/RC2/128/CBC"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithSHA1AndRC240_CBC, "PBEWithSHA1And40RC2CBC", "PBE/SHA1/RC2/40/CBC"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithSHA1AndRC4128, "PBEWithSHA1And128RC4", "PBE/SHA1/RC4/128"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithSHA1AndRC440, "PBEWithSHA1And40RC4", "PBE/SHA1/RC4/40"));
        idx = this.types.indexOf(AlgorithmSetName.SECRET_KEY_ALGO);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES, "DES"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DESede, "DESede"));
        idx = this.types.indexOf(AlgorithmSetName.KEY_GEN_ALGO);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES, "DES"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DESede, "DESede", "DES3/DESEDE"));
        idx = this.types.indexOf(AlgorithmSetName.KEY_PAIR_ALGO);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.rsaEncryption, "RSA"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.dsaEncryption, "DSA"));
        idx = this.types.indexOf(AlgorithmSetName.KEY_WRAP_ALGO);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.rsaEncryption, "RSA"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.dsaEncryption, "DSA"));
        idx = this.types.indexOf(AlgorithmSetName.SIGNATURE_ALGO);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.rsaWithSHA1, "SHA1WithRSA", "RSA/SHA"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.rsaWithMD5, "MD5WithRSA", "RSA/MD5"));
        idx = this.types.indexOf(AlgorithmSetName.SECURE_RANDOM);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.PRNG_JSS_PKCS11, "PKCS11PRNG"));
    }
}

