/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.WSJSDP;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.pkcs10.CertificationRequest;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Certification.CSRGeneration;
import th.co.oga.security.pki.Certification.CSRGenerator;
import th.co.oga.security.pki.Certification.CSRProfile;
import th.co.oga.security.pki.Certification.CSRSignification;
import th.co.oga.security.pki.Certification.CertRequestEncodeException;
import th.co.oga.security.pki.Certification.CertificationRequestException;
import th.co.oga.security.pki.HouseKeeping.AgentProfileNotInitializedException;
import th.co.oga.security.pki.HouseKeeping.CryptoTokenException;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operation.SecureStoreSoftException;
import th.co.oga.security.pki.Operator.CryptoOperator;
import th.co.oga.security.pki.Operator.SecureStoreOperator;

public class JSDPCSRGenerator
extends CSRGenerator
implements CSRGeneration {
    private CSRSignification csrSigner;

    public JSDPCSRGenerator(SecureStoreOperator sso) throws CryptoTokenException {
        super(sso);
    }

    public CSRProfile genCertRequest(String signAlgo) throws CertificationRequestException, AgentProfileNotInitializedException, AlgorithmSupportException {
        this.signatureAlgo = this.signatureAlgoSet.findByOID(signAlgo);
        return this.genCertRequest();
    }

    public CSRProfile genCertRequest() throws CertificationRequestException, AgentProfileNotInitializedException {
        super.buildCertificationRequestInfo();
        this.beginWork();
        this.csrSigner = new CSRSignification(this.certRequestInfo);
        try {
            CryptoOperator co = this.storeMgr.getCryptoOperator();
            Signature sign = co.getSignature(this.signatureAlgo);
            this.csrSigner.sign(sign, this.keyPair.getPrivate(), this.signatureAlgo.getOID());
            Signature verify = co.getSignature(this.signatureAlgo);
            this.csrSigner.verify(verify, this.keyPair.getPublic());
            this.sn = "" + Math.abs(new String(this.certRequestInfo.getSubjectPublicKeyInfo().getEncoded()).hashCode());
            return CSRProfile.getNewProfile(this.sn, ASN1Util.encode((ASN1Value)this.csrSigner), this.profile.getDName().getFriendlyName());
        }
        catch (InvalidKeyException e) {
            throw new CertificationRequestException("JSDPCertRequestor", "Error while sign CSR, " + e.getMessage());
        }
        catch (SignatureException e) {
            throw new CertificationRequestException("JSDPCertRequestor", "Error while sign CSR, " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificationRequestException("JSDPCertRequestor", e.getMessage());
        }
    }

    public void beginWork() throws CertificationRequestException {
        try {
            this.storeMgr.importKeyPair(this.keyPair);
        }
        catch (SecureStoreException e) {
            throw new CertificationRequestException("JSDPCertRequestor", "Error while import private key to pemanace, " + e.getMessage());
        }
        catch (SecureStoreSoftException secureStoreSoftException) {
            // empty catch block
        }
        super.beginWork();
    }

    public void rollbackWork() {
        try {
            if (this.isBegin()) {
                this.storeMgr.deletePrivateKey(this.keyPair);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSNFromCSR(byte[] CSRDerStream) throws CertRequestEncodeException {
        try {
            CertificationRequest req = (CertificationRequest)ASN1Util.decode((ASN1Template)CertificationRequest.getTemplate(), (byte[])CSRDerStream);
            String sn = "" + Math.abs(new String(req.getInfo().getSubjectPublicKeyInfo().getEncoded()).hashCode());
            return sn;
        }
        catch (Exception e) {
            throw new CertRequestEncodeException("JSSCertRequestor", "\r\n" + e.toString());
        }
    }
}

