/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.WSJSDP;

import com.entegrity.jsdp.security.provider.JSDP;
import com.entegrity.jsdp.security.token.Token;
import com.entegrity.jsdp.utils.ByteBuffer;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Operation.CryptoOperation;
import th.co.oga.security.pki.Operation.KeyGenerateFailException;
import th.co.oga.security.pki.Operator.CryptoOperator;
import th.co.oga.security.pki.Operator.WSJSDP.JSDPAlgorithm;
import th.co.oga.security.pki.Operator.WSJSDP.JSDPSpec;

public class JSDPCryptoOperator
extends CryptoOperator
implements CryptoOperation,
JSDPSpec {
    private AlgorithmProfile prngAlgo;
    private Token token;

    protected JSDPCryptoOperator(Token token) {
        super((Provider)new JSDP(), new JSDPAlgorithm());
        this.token = token;
        this.prngAlgo = (AlgorithmProfile)this.getSupportAlgorithm().getSecureRandomAlgorithm().get(0);
    }

    public SecureRandom getSecureRandom() throws NoSuchAlgorithmException {
        return this.token.newSecureRandomMechanism(this.prngAlgo.getAlgorithmName());
    }

    public KeyPairGenerator getKeyPairGenerator(AlgorithmProfile algo) throws NoSuchAlgorithmException {
        return this.token.newKeyPairGeneratorMechanism(algo.getAlgorithmName(), true);
    }

    public Cipher getCipher(AlgorithmProfile transformers) throws NoSuchAlgorithmException, NoSuchPaddingException {
        return this.token.newEncryptionMechanism(transformers.getTransform());
    }

    public KeyGenerator getKeyGenerator(AlgorithmProfile algo) throws NoSuchAlgorithmException {
        return this.token.newKeyGeneratorMechanism(algo.getKeyAlgorithmName(), false, true);
    }

    public MessageDigest getMessageDigest(AlgorithmProfile digestAlgo) throws NoSuchAlgorithmException {
        return this.token.newDigestMechanism(digestAlgo.getMessageDigestAlgorithmName());
    }

    public Signature getSignature(AlgorithmProfile algo) throws NoSuchAlgorithmException {
        return this.token.newSignatureMechanism(algo.getAlgorithmName());
    }

    public PublicKey retrustedPublicKey(PublicKey publ) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String publKeyId = "PUBK:" + ByteBuffer.toHex((byte[])this.token.calculateKeyId((Key)publ));
        try {
            block4: {
                try {
                    this.token.store(publKeyId, publ, true, true, true);
                }
                catch (Exception e) {
                    String msg = e.toString();
                    if (msg.indexOf("Key alias already present") != 0) break block4;
                    throw new InvalidKeySpecException("Error while import for trusted key," + e.toString());
                }
            }
            Hashtable tbl = this.token.getKeys();
            return (PublicKey)tbl.get(publKeyId);
        }
        catch (Exception e) {
            throw new InvalidKeySpecException("Error while retrust key," + e.toString());
        }
    }

    public SecretKey getSecretKey(AlgorithmProfile algorithm, byte[] key) throws NoSuchAlgorithmException, KeyGenerateFailException {
        SecretKeySpec sks = new SecretKeySpec(key, algorithm.getKeyAlgorithmName());
        return sks;
    }

    public String getCipherParamSupportAlgos() {
        return "DES_CBC,DESede_CBC,RC2,AES_CBC";
    }

    public String getKeySpecSupportAlgos() {
        return "--";
    }

    public String getSecretKeyFactorySupportAlgos() {
        return "--";
    }

    public String getKeyGeneratorSupportAlgos() {
        return "AES,DES,DESede,RC4";
    }

    public String getKeyGenParamSupportAlgos() {
        return "AES,RC4";
    }
}

