/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.WSJSDP;

import com.entegrity.jsdp.iaik.x509.X509Certificate;
import com.entegrity.jsdp.security.provider.JSDP;
import com.entegrity.jsdp.security.token.Token;
import com.entegrity.jsdp.security.token.TokenCertificateEntry;
import com.entegrity.jsdp.security.token.TokenException;
import com.entegrity.jsdp.utils.ByteBuffer;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CSRGeneration;
import th.co.oga.security.pki.Certification.CertChain;
import th.co.oga.security.pki.Certification.CertChainException;
import th.co.oga.security.pki.Certification.CertPackage;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertPackageType;
import th.co.oga.security.pki.Certification.CertPackageTypeNotSupportException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.Certification.InternalCertProfile;
import th.co.oga.security.pki.Certification.PFXProfile;
import th.co.oga.security.pki.Certification.PFXProfileException;
import th.co.oga.security.pki.Engine.SecureProviderName;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.Operation.PFXOperation;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operation.SecureStoreFindingFailException;
import th.co.oga.security.pki.Operation.SecureStoreSoftException;
import th.co.oga.security.pki.Operator.CryptoOperator;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.Operator.WSJSDP.JSDPAlgorithm;
import th.co.oga.security.pki.Operator.WSJSDP.JSDPCSRGenerator;
import th.co.oga.security.pki.Operator.WSJSDP.JSDPCryptoOperator;
import th.co.oga.security.pki.Operator.WSJSDP.JSDPErrorMessage;
import th.co.oga.security.pki.Operator.WSJSDP.JSDPPFXDriver;
import th.co.oga.security.pki.Operator.WSJSDP.JSDPSpec;
import th.co.oga.security.pki.Operator.WSJSDP.JSDPStoreObjectNotFoundException;
import th.co.oga.security.pki.Operator.WSJSDP.JSDPTokenViewer;
import th.co.oga.security.pki.PinCode;
import th.co.oga.security.pki.Utils;

public class JSDPStoreOperator
extends SecureStoreOperator
implements JSDPSpec {
    private SecureProviderName providerName = SecureProviderName.JSDP;
    private boolean build = false;
    private boolean opened = false;
    private CertificateFactory certFactory;
    private Token token;
    private KeyStore keyStore;
    private String PRNGAlgorithmName = "pkcs11prng";

    public JSDPStoreOperator(Token token, KeyStore keyStore) {
        super(new JSDPAlgorithm());
        JSDP.addAsProvider();
        this.token = token;
        this.keyStore = keyStore;
    }

    public String getName() {
        return "Websentry JSDP secure store operator";
    }

    protected void importKeys(PrivateKey priv, PublicKey publ) throws TokenException, IllegalArgumentException {
        byte[] publKeyId = this.token.calculateKeyId((Key)publ);
        this.token.store("PRVK:" + ByteBuffer.toHex((byte[])publKeyId), (Object)priv, true, true, publKeyId);
        this.token.store("PUBK:" + ByteBuffer.toHex((byte[])publKeyId), publ, true, true, true);
    }

    private String getCertId(java.security.cert.X509Certificate cer) throws NoSuchAlgorithmException {
        return this.getCertId(cer.getIssuerX500Principal(), cer.getSerialNumber());
    }

    private String getCertId(X500Principal issuer, BigInteger sn) throws NoSuchAlgorithmException {
        MessageDigest hasher = MessageDigest.getInstance("SHA1");
        byte[] hash = hasher.digest(("Issuer:" + issuer.toString() + "SerialNumber:" + sn.toString()).getBytes());
        return "CERT:" + ByteBuffer.toHex((byte[])hash);
    }

    protected void importCertificate(java.security.cert.X509Certificate cer) throws TokenException, IllegalArgumentException, CertificateEncodingException, NoSuchAlgorithmException {
        this.token.store(this.getCertId(cer), (Object)cer, true);
    }

    public void deletePrivateKey(PublicKey publ) throws TokenException, IllegalArgumentException {
        this.token.removeKey("PRVK:" + ByteBuffer.toHex((byte[])this.token.calculateKeyId((Key)publ)));
    }

    protected void deletePublicKey(PublicKey publ) throws TokenException, IllegalArgumentException {
        this.token.removeKey("PUBK:" + ByteBuffer.toHex((byte[])this.token.calculateKeyId((Key)publ)));
    }

    protected void deleteCertificate(Certificate cer) throws TokenException, IllegalArgumentException, CertificateEncodingException, NoSuchAlgorithmException {
        MessageDigest hasher = MessageDigest.getInstance("SHA1");
        String certId = ByteBuffer.toHex((byte[])hasher.digest(cer.getEncoded()));
        this.token.removeCertificate("CERT:" + certId, true);
    }

    private List getListOfRootCertificates() throws TokenException, CertificateException, ASN1Exception {
        ArrayList<InternalCertProfile> cers = new ArrayList<InternalCertProfile>();
        Hashtable tbl = this.token.getCertificates();
        Enumeration enu = tbl.keys();
        while (enu.hasMoreElements()) {
            String alias = (String)enu.nextElement();
            TokenCertificateEntry entry = (TokenCertificateEntry)tbl.get(alias);
            CertProfile cp = new CertProfile((java.security.cert.X509Certificate)entry.getCertificate());
            if (!cp.isCA()) continue;
            cers.add(new InternalCertProfile(cp, cp.getFriendlyName()));
        }
        return cers;
    }

    private List getListOfInternalCertificates() throws TokenException, CertificateException, ASN1Exception {
        ArrayList<InternalCertProfile> cers = new ArrayList<InternalCertProfile>();
        Hashtable tbl = this.token.getCertificates();
        Enumeration enu = tbl.keys();
        while (enu.hasMoreElements()) {
            String alias = (String)enu.nextElement();
            TokenCertificateEntry entry = (TokenCertificateEntry)tbl.get(alias);
            X509Certificate cert = entry.getCertificate();
            CertProfile cp = new CertProfile((Certificate)cert);
            if (cp.isCA()) continue;
            try {
                PrivateKey pk = this.getPrivateKey((Certificate)cert);
                if (pk == null) continue;
                cers.add(new InternalCertProfile(cp, cp.getFriendlyName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cers;
    }

    private List getListOfTrustedCertificates() throws TokenException, CertificateException, ASN1Exception {
        ArrayList<InternalCertProfile> cers = new ArrayList<InternalCertProfile>();
        Hashtable tbl = this.token.getCertificates();
        Enumeration enu = tbl.keys();
        while (enu.hasMoreElements()) {
            String alias = (String)enu.nextElement();
            TokenCertificateEntry entry = (TokenCertificateEntry)tbl.get(alias);
            X509Certificate cert = entry.getCertificate();
            CertProfile cp = new CertProfile((Certificate)cert);
            cers.add(new InternalCertProfile(cp, cp.getFriendlyName()));
        }
        return cers;
    }

    private List getListOfPoepleCertificates() throws TokenException, CertificateException, ASN1Exception {
        ArrayList<InternalCertProfile> cers = new ArrayList<InternalCertProfile>();
        Hashtable tbl = this.token.getCertificates();
        Enumeration enu = tbl.keys();
        while (enu.hasMoreElements()) {
            String alias = (String)enu.nextElement();
            TokenCertificateEntry entry = (TokenCertificateEntry)tbl.get(alias);
            X509Certificate cert = entry.getCertificate();
            CertProfile cp = new CertProfile((Certificate)cert);
            if (cp.isCA()) continue;
            PrivateKey pk = null;
            try {
                pk = this.getPrivateKey((Certificate)cert);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pk != null) continue;
            cers.add(new InternalCertProfile(cp, cp.getFriendlyName()));
        }
        return cers;
    }

    private java.security.cert.X509Certificate getIssuerCertificate(java.security.cert.X509Certificate leaf) throws JSDPStoreObjectNotFoundException {
        try {
            Hashtable tbl = this.token.getCertificates();
            Enumeration enu = tbl.keys();
            while (enu.hasMoreElements()) {
                String alias = (String)enu.nextElement();
                TokenCertificateEntry entry = (TokenCertificateEntry)tbl.get(alias);
                X509Certificate cert = entry.getCertificate();
                if (!cert.getSubjectX500Principal().equals(leaf.getIssuerX500Principal())) continue;
                return cert;
            }
            throw new JSDPStoreObjectNotFoundException("Issuer Certificate", "no certificate math with certificate");
        }
        catch (Exception e) {
            throw new JSDPStoreObjectNotFoundException("Issuer Certificate", e.getMessage());
        }
    }

    protected PrivateKey getPrivateKey(Certificate cer) throws SecureStoreFindingFailException {
        try {
            String keyAlias = "PRVK:" + ByteBuffer.toHex((byte[])this.token.calculateKeyId((Key)cer.getPublicKey()));
            Hashtable tbl = this.token.getKeys();
            return (PrivateKey)tbl.get(keyAlias);
        }
        catch (Exception e) {
            throw new SecureStoreFindingFailException(this.providerName.getProviderInstance(), "Private Key", e.getMessage());
        }
    }

    public PFXOperation getPKCS12Device() throws SecureStoreException {
        try {
            return new JSDPPFXDriver();
        }
        catch (Exception e) {
            throw new SecureStoreException(e.toString());
        }
    }

    public void importPrivateKey(byte[] stream, String algo) throws SecureStoreException, SecureStoreSoftException {
        throw new SecureStoreSoftException("Import PrivateKey from byte array not implemented .");
    }

    public void importKeyPair(KeyPair keys) throws SecureStoreException, SecureStoreSoftException {
        try {
            this.importKeys(keys.getPrivate(), keys.getPublic());
        }
        catch (Exception e) {
            throw new SecureStoreException("Error while import privatekey to key store, " + e.toString());
        }
    }

    public void importCertPackage(CertPackage certPackage) throws CertPackageException, CertPackageTypeNotSupportException {
        if (certPackage.getType().is(CertPackageType.CERTIFICATE)) {
            this.importCertProfile(certPackage);
        } else if (certPackage.getType().is(CertPackageType.P7)) {
            this.importCertChain(certPackage);
        } else if (certPackage.getType().is(CertPackageType.P12)) {
            this.importPFXProfile(certPackage);
        } else {
            throw new CertPackageTypeNotSupportException(certPackage.getType().getName());
        }
    }

    protected void importCertChain(CertPackage certChain) throws CertChainException {
        try {
            java.security.cert.X509Certificate[] cers = certChain.getX509Certs();
            int i = 0;
            while (i < cers.length) {
                this.importCertificate(cers[i]);
                ++i;
            }
        }
        catch (Exception e) {
            throw new CertChainException(e.toString());
        }
    }

    protected void importPFXProfile(CertPackage pfxProfile) throws CertPackageException {
        Iterator contents = pfxProfile.getContent();
        try {
            ArrayList prvs = new ArrayList();
            ArrayList<java.security.cert.X509Certificate> cers = new ArrayList<java.security.cert.X509Certificate>();
            while (contents.hasNext()) {
                Object entry = contents.next();
                if (entry instanceof PrivateKey) {
                    prvs.add(entry);
                }
                if (!(entry instanceof Certificate)) continue;
                cers.add((java.security.cert.X509Certificate)entry);
            }
            java.security.cert.X509Certificate[] xcers = new java.security.cert.X509Certificate[cers.size()];
            int i = 0;
            while (i < cers.size()) {
                xcers[i] = (java.security.cert.X509Certificate)cers.get(i);
                ++i;
            }
            i = 0;
            while (i < prvs.size()) {
                PrivateKey priv = (PrivateKey)prvs.get(i);
                java.security.cert.X509Certificate xcer = Utils.findCertOwner(priv, xcers);
                this.importKeys(priv, xcer.getPublicKey());
                ++i;
            }
            i = 0;
            while (i < xcers.length) {
                this.importCertificate(xcers[i]);
                ++i;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new PFXProfileException("Error while match certificate to private key, " + e.getMessage());
        }
        catch (SignatureException e) {
            throw new PFXProfileException("Error while match certificate to private key, " + e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new PFXProfileException("Error while match certificate to private key, " + e.getMessage());
        }
        catch (TokenException e) {
            throw new PFXProfileException("Error while import private key entry, " + JSDPErrorMessage.getErrorMessage((Exception)((Object)e)));
        }
        catch (IllegalArgumentException e) {
            throw new PFXProfileException("Error while import private key entry, " + e.toString());
        }
        catch (CertificateEncodingException e) {
            throw new PFXProfileException("Error while import cert entry, " + e.getMessage());
        }
    }

    protected void importCertProfile(CertPackage certFile) throws CertProfileException {
        java.security.cert.X509Certificate[] cers = certFile.getX509Certs();
        try {
            int i = 0;
            while (i < cers.length) {
                this.importCertificate(cers[i]);
                ++i;
            }
        }
        catch (Exception e) {
            throw new CertProfileException("Error while import cert profile, " + e.getMessage());
        }
    }

    public CertChain getCertChain(CertProfile leaf) throws SecureStoreException {
        java.security.cert.X509Certificate leafCer = leaf.getX509Cert();
        java.security.cert.X509Certificate rootCer = this.getIssuerCertificate(leafCer);
        try {
            CertChain chain = new CertChain();
            chain.addCert(new java.security.cert.X509Certificate[]{rootCer, leafCer});
            return chain;
        }
        catch (Exception e) {
            throw new SecureStoreException("Error while build certificate chain, " + e.toString());
        }
    }

    public CertChain getCertChain(CertProfile root, CertProfile leaf) throws SecureStoreException {
        try {
            CertChain chain = new CertChain();
            chain.addCert(new java.security.cert.X509Certificate[]{root.getX509Cert(), leaf.getX509Cert()});
            return chain;
        }
        catch (Exception e) {
            throw new SecureStoreException("Error on Certificate Chain build as miner message:" + e.toString());
        }
    }

    public PFXProfile getPFX(CertProfile cer, PinCode pin) throws SecureStoreException {
        CertChain chain = this.getCertChain(cer);
        try {
            PrivateKey priv = this.getPrivateKey(cer);
            PFXProfile pfx = new PFXProfile(this.getPKCS12Device(), pin);
            pfx.addKeyEntry(priv, chain);
            return pfx;
        }
        catch (Exception e) {
            throw new SecureStoreException("Error build PFXprofile, " + e.getMessage());
        }
    }

    public PrivateKey getPrivateKey(CertProfile cer) throws SecureStoreFindingFailException {
        return this.getPrivateKey(cer.getX509Cert());
    }

    public byte[] getEncryptedPrivateKey(CertProfile cer, PinCode pin) throws SecureStoreException {
        throw new SecureStoreException("The operation is not support, Please archive the key to smart card only.");
    }

    public CertProfile getIssuerCertificate(CertProfile userCert) throws CertProfileException, IOException, CertificateException, EntryNotFoundException {
        try {
            return new CertProfile(this.getIssuerCertificate(userCert.getX509Cert()));
        }
        catch (JSDPStoreObjectNotFoundException e) {
            throw new EntryNotFoundException("JSDP Issuer's Certificate ");
        }
    }

    public List getCertificates(String certGroup) throws SecureStoreException {
        try {
            if ("CA Certificate".equalsIgnoreCase(certGroup)) {
                return this.getListOfRootCertificates();
            }
            if ("USER Certificate".equalsIgnoreCase(certGroup)) {
                return this.getListOfInternalCertificates();
            }
            if ("TRUSTED Certificate".equalsIgnoreCase(certGroup)) {
                return this.getListOfPoepleCertificates();
            }
            throw new SecureStoreException("Not support cert group ");
        }
        catch (Exception e) {
            throw new SecureStoreException("Certificate group " + certGroup + " list error, " + e.toString());
        }
    }

    public void deleteCertPackage(CertProfile certProfile) throws SecureStoreException {
        java.security.cert.X509Certificate cer = certProfile.getX509Cert();
        try {
            this.deletePrivateKey(cer.getPublicKey());
        }
        catch (Exception e) {
            throw new SecureStoreException("The related PrivateKey delete error," + e.toString());
        }
        try {
            this.deletePublicKey(cer.getPublicKey());
        }
        catch (Exception e) {
            throw new SecureStoreException("The related PublicKey delete error," + e.toString());
        }
        try {
            this.deleteCertificate(certProfile.getX509Cert());
        }
        catch (Exception e) {
            throw new SecureStoreException("Certificate delete error," + e.toString());
        }
    }

    public void deletePrivateKey(KeyPair keyPair) throws SecureStoreException {
        try {
            this.deletePrivateKey(keyPair.getPublic());
        }
        catch (Exception e) {
            throw new SecureStoreException("Private key delete error," + e.toString());
        }
    }

    public CSRGeneration getCSRGenerator() throws SecureStoreException {
        try {
            return new JSDPCSRGenerator(this);
        }
        catch (Exception e) {
            throw new SecureStoreException(e.toString());
        }
    }

    public KeyStore getKeyStore() throws SecureStoreException {
        return this.keyStore;
    }

    public String getKeyIdentifier(Key key) {
        return ByteBuffer.toHex((byte[])this.token.calculateKeyId(key));
    }

    public CryptoOperator getCryptoOperator() {
        return new JSDPCryptoOperator(this.token);
    }

    public String getInfos() {
        JSDPTokenViewer viewer = new JSDPTokenViewer(this.token);
        return viewer.getInfo();
    }
}

