/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.WSJSDP;

import com.entegrity.jsdp.security.provider.JSDP;
import com.entegrity.jsdp.security.token.InvalidPasswordLengthException;
import com.entegrity.jsdp.security.token.PasswordBlockedException;
import com.entegrity.jsdp.security.token.PasswordIncorrectException;
import com.entegrity.jsdp.security.token.Token;
import com.entegrity.jsdp.security.token.TokenCertificateEntry;
import com.entegrity.jsdp.security.token.TokenException;
import com.entegrity.jsdp.security.token.TokenTypeNotSupportedException;
import com.entegrity.jsdp.utils.ByteBuffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.security.auth.x500.X500Principal;
import th.co.oga.security.pki.Certification.InternalCertProfile;
import th.co.oga.security.pki.Operator.WSJSDP.JSDPTokenViewer;
import th.co.oga.security.pki.PinCode;
import th.co.oga.security.utils.SysEnv;

public class JSDPTokenMgr {
    public static String TOKEN_CLASS = "com.entegrity.jsdp.security.token.pkcs11.PKCS11TokenSpi";
    public static String SOLARIS_DRIVER = "wspkcs11d.so";
    public static String WIN_DRIVER = "wspkcs11d.dll";
    public static final String CERTIFICATE_ROOT_TAG = "CERTR:";
    public static final String CERTIFICATE_EXTERNAL_TAG = "CERTE:";
    public static final String CERTIFICATE_INTERNAL_TAG = "CERTI:";
    public static final String PRIVATEKEY_TAG = "PRVK:";
    public static final String PUBLICKEY_TAG = "PUBK:";
    public static final String SECRETKEY_TAG = "SECK:";
    private MessageDigest hasher;
    private String dynamic_lib = null;
    private Properties tokenProperties;
    private Token token;
    private KeyStore keyStore;
    private Provider secureProvider;

    protected JSDPTokenMgr(Token token) throws NoSuchAlgorithmException, KeyStoreException {
        this.token = token;
        this.hasher = MessageDigest.getInstance("SHA1");
        this.keyStore = KeyStore.getInstance("JSDP");
        this.secureProvider = new JSDP();
    }

    private void setProperties(Properties prop) {
        this.tokenProperties = prop;
    }

    public static JSDPTokenMgr getInstance(int slotno) throws TokenTypeNotSupportedException, NoSuchAlgorithmException, KeyStoreException {
        String dynamic_lib = "";
        String os = SysEnv.getOSName();
        if (os.equalsIgnoreCase(SysEnv.OS_SOLARIS)) {
            dynamic_lib = SOLARIS_DRIVER;
        } else if (os.equalsIgnoreCase(SysEnv.OS_WINDOWS)) {
            dynamic_lib = WIN_DRIVER;
        }
        Properties tokenProperties = new Properties();
        tokenProperties.setProperty("class", TOKEN_CLASS);
        tokenProperties.setProperty("name", dynamic_lib);
        tokenProperties.setProperty("slotOrdinal", "" + slotno);
        JSDPTokenMgr tm = new JSDPTokenMgr(Token.getInstance((Properties)tokenProperties));
        tm.setProperties(tokenProperties);
        return tm;
    }

    protected X509Certificate findCertificate(X500Principal issuer, BigInteger sn) throws TokenException {
        com.entegrity.jsdp.iaik.x509.X509Certificate xCer = null;
        Hashtable tbl = this.token.getCertificates();
        Enumeration enu = tbl.keys();
        while (enu.hasMoreElements()) {
            String alias = (String)enu.nextElement();
            TokenCertificateEntry entry = (TokenCertificateEntry)tbl.get(alias);
            com.entegrity.jsdp.iaik.x509.X509Certificate cert = entry.getCertificate();
            if (!cert.getIssuerX500Principal().equals(issuer) || cert.getSerialNumber().compareTo(sn) != 0) continue;
            xCer = cert;
            break;
        }
        return xCer;
    }

    protected PrivateKey findPrivateKey(PublicKey publ) throws TokenException {
        String keyAlias = PRIVATEKEY_TAG + ByteBuffer.toHex((byte[])this.token.calculateKeyId((Key)publ));
        PrivateKey privKey = null;
        Hashtable tbl = this.token.getKeys();
        Enumeration enu = tbl.keys();
        while (enu.hasMoreElements()) {
            String alias = (String)enu.nextElement();
            if (!alias.equals(keyAlias)) continue;
            privKey = (PrivateKey)tbl.get(alias);
            break;
        }
        return privKey;
    }

    protected void load(PinCode pin) throws PasswordIncorrectException, PasswordBlockedException, InvalidPasswordLengthException, TokenException, IOException, NoSuchAlgorithmException, CertificateException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.tokenProperties.store(baos, null);
        String s = baos.toString();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
        this.keyStore.load(bais, pin.getPassword());
        bais.close();
        this.token.login(pin.getBytes());
    }

    protected void unload() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this.keyStore.store(null, null);
        this.token.logout();
    }

    protected void changePassword(byte[] pin1, byte[] pin2) throws InvalidPasswordLengthException, PasswordIncorrectException, TokenException {
        this.token.changePassword(pin1, pin2);
    }

    protected Token getToken() {
        return this.token;
    }

    protected KeyStore getKeyStore() {
        return this.keyStore;
    }

    protected void importKeys(PrivateKey priv, PublicKey publ) throws TokenException, IllegalArgumentException {
        byte[] publKeyId = this.token.calculateKeyId((Key)publ);
        this.token.store(PRIVATEKEY_TAG + ByteBuffer.toHex((byte[])publKeyId), (Object)priv, true, true, publKeyId);
        this.token.store(PUBLICKEY_TAG + ByteBuffer.toHex((byte[])publKeyId), publ, true, true, true);
    }

    protected String getKeyIdentifier(Key key) {
        return ByteBuffer.toHex((byte[])this.token.calculateKeyId(key));
    }

    protected void importCertificate(Certificate cer) throws TokenException, IllegalArgumentException, CertificateEncodingException {
        byte[] digest = this.hasher.digest(cer.getEncoded());
        this.token.store(String.valueOf(this.getCertAliasPrefix(cer)) + ByteBuffer.toHex((byte[])digest), (Object)cer, true);
    }

    private String getCertAliasPrefix(Certificate cer) throws TokenException {
        String aliasPrefix = null;
        String keyId = PRIVATEKEY_TAG + ByteBuffer.toHex((byte[])this.token.calculateKeyId((Key)cer.getPublicKey()));
        Hashtable tbl = this.token.getKeys();
        Enumeration enu = tbl.keys();
        while (enu.hasMoreElements()) {
            String alias = (String)enu.nextElement();
            if (!keyId.equals(alias)) continue;
            aliasPrefix = CERTIFICATE_INTERNAL_TAG;
            break;
        }
        if (aliasPrefix == null) {
            aliasPrefix = CERTIFICATE_EXTERNAL_TAG;
        }
        return aliasPrefix;
    }

    protected void deletePrivateKey(PublicKey publ) throws TokenException, IllegalArgumentException {
        this.token.removeKey(PRIVATEKEY_TAG + ByteBuffer.toHex((byte[])this.token.calculateKeyId((Key)publ)));
    }

    protected void deletePublicKey(PublicKey publ) throws TokenException, IllegalArgumentException {
        this.token.removeKey(PUBLICKEY_TAG + ByteBuffer.toHex((byte[])this.token.calculateKeyId((Key)publ)));
    }

    protected void deleteCertificate(Certificate cer) throws TokenException, IllegalArgumentException, CertificateEncodingException {
        String certId = ByteBuffer.toHex((byte[])this.hasher.digest(cer.getEncoded()));
        this.token.removeCertificate(CERTIFICATE_INTERNAL_TAG + certId, true);
        this.token.removeCertificate(CERTIFICATE_EXTERNAL_TAG + certId, true);
        this.token.removeCertificate(CERTIFICATE_ROOT_TAG + certId, true);
    }

    protected void deleteAllKeys() throws TokenException, IllegalArgumentException {
        Enumeration enu = this.token.getKeys().keys();
        while (enu.hasMoreElements()) {
            String alias = (String)enu.nextElement();
            this.token.removeKey(alias);
        }
    }

    protected void deleteAllCertificates() throws TokenException, IllegalArgumentException {
        Enumeration enu = this.token.getCertificates().keys();
        while (enu.hasMoreElements()) {
            String alias = (String)enu.nextElement();
            this.token.removeCertificate(alias, true);
        }
    }

    protected void deleteAllData() throws TokenException, IllegalArgumentException {
        Enumeration enu = this.token.getDataObjects().keys();
        while (enu.hasMoreElements()) {
            String alias = (String)enu.nextElement();
            this.token.removeDataObject(alias, true);
        }
    }

    public List getListOfInternalCertificates() throws TokenException, CertificateException {
        ArrayList<InternalCertProfile> cers = new ArrayList<InternalCertProfile>();
        Hashtable tbl = this.token.getCertificates();
        Enumeration enu = tbl.keys();
        while (enu.hasMoreElements()) {
            String alias = (String)enu.nextElement();
            if (alias.indexOf(CERTIFICATE_INTERNAL_TAG) <= -1) continue;
            TokenCertificateEntry entry = (TokenCertificateEntry)tbl.get(alias);
            com.entegrity.jsdp.iaik.x509.X509Certificate cert = entry.getCertificate();
            cers.add(new InternalCertProfile((X509Certificate)cert, alias));
        }
        return cers;
    }

    public List getListOfTrustedCertificates() throws TokenException, CertificateException {
        ArrayList<InternalCertProfile> cers = new ArrayList<InternalCertProfile>();
        Hashtable tbl = this.token.getCertificates();
        Enumeration enu = tbl.keys();
        while (enu.hasMoreElements()) {
            String alias = (String)enu.nextElement();
            TokenCertificateEntry entry = (TokenCertificateEntry)tbl.get(alias);
            com.entegrity.jsdp.iaik.x509.X509Certificate cert = entry.getCertificate();
            cers.add(new InternalCertProfile((X509Certificate)cert, alias));
        }
        return cers;
    }

    public List getListOfRootCertificates() throws TokenException, CertificateException {
        ArrayList<InternalCertProfile> cers = new ArrayList<InternalCertProfile>();
        Hashtable tbl = this.token.getCertificates();
        Enumeration enu = tbl.keys();
        while (enu.hasMoreElements()) {
            String alias = (String)enu.nextElement();
            TokenCertificateEntry entry = (TokenCertificateEntry)tbl.get(alias);
            com.entegrity.jsdp.iaik.x509.X509Certificate cert = entry.getCertificate();
            cers.add(new InternalCertProfile((X509Certificate)cert, alias));
        }
        return cers;
    }

    protected JSDPTokenViewer getViewer() {
        return new JSDPTokenViewer(this.token);
    }
}

