/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.WSJSDP;

import com.entegrity.jsdp.security.provider.JSDP;
import com.entegrity.jsdp.security.token.PasswordBlockedException;
import com.entegrity.jsdp.security.token.Token;
import com.entegrity.jsdp.security.token.TokenException;
import com.entegrity.jsdp.security.token.TokenTypeNotSupportedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Enumeration;
import java.util.Properties;
import th.co.oga.security.pki.Engine.SecureModule;
import th.co.oga.security.pki.HouseKeeping.AgentProfile;
import th.co.oga.security.pki.Operation.TokenOperationNotSupportException;
import th.co.oga.security.pki.Operation.TokenOperatorBuildException;
import th.co.oga.security.pki.Operation.TokenOperatorLockException;
import th.co.oga.security.pki.Operation.TokenOperatorOpenException;
import th.co.oga.security.pki.Operation.TokenOperatorOperationFailException;
import th.co.oga.security.pki.Operator.CryptoOperator;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.Operator.TokenOperator;
import th.co.oga.security.pki.Operator.WSJSDP.JSDPCryptoOperator;
import th.co.oga.security.pki.Operator.WSJSDP.JSDPErrorMessage;
import th.co.oga.security.pki.Operator.WSJSDP.JSDPStoreOperator;
import th.co.oga.security.pki.PinCode;
import th.co.oga.security.utils.SysEnv;

public class JSDPTokenOperator
extends TokenOperator {
    public static String TOKEN_CLASS = "com.entegrity.jsdp.security.token.pkcs11.PKCS11TokenSpi";
    public static String SOLARIS_DRIVER = "wspkcs11d.so";
    public static String WIN_DRIVER = "wspkcs11d.dll";
    private String dynamic_lib = null;
    private Properties tokenProperties;
    private Token token;
    private KeyStore keyStore;
    private String slotno;

    public JSDPTokenOperator(SecureModule module) {
        super(module);
        this.slotno = module.getValue("SLOTORFINAL");
        JSDP.addAsProvider();
    }

    public boolean equals(TokenOperator oper) {
        if (super.equals(oper)) {
            SecureModule pm = oper.getSecureModule();
            SecureModule tm = this.getSecureModule();
            if (tm.getValue("StoreBase").equals(pm.getValue("StoreBase")) && tm.getValue("SLOTORFINAL").equals(pm.getValue("SLOTORFINAL"))) {
                return true;
            }
        }
        return false;
    }

    public String about() {
        return super.about();
    }

    public void build(File safeFolder) throws TokenOperatorBuildException {
        super.build(safeFolder);
        String dynamic_lib = "";
        String os = SysEnv.getOSName();
        if (os.equalsIgnoreCase(SysEnv.OS_SOLARIS)) {
            dynamic_lib = SOLARIS_DRIVER;
        } else if (os.equalsIgnoreCase(SysEnv.OS_WINDOWS)) {
            dynamic_lib = WIN_DRIVER;
        }
        this.tokenProperties = new Properties();
        this.tokenProperties.setProperty("class", TOKEN_CLASS);
        this.tokenProperties.setProperty("name", dynamic_lib);
        this.tokenProperties.setProperty("slotOrdinal", this.slotno);
        try {
            this.token = Token.getInstance((Properties)this.tokenProperties);
        }
        catch (TokenTypeNotSupportedException e) {
            throw new TokenOperatorBuildException(this.getSecureProvider(), JSDPErrorMessage.getErrorMessage((Exception)((Object)e)));
        }
        try {
            this.keyStore = KeyStore.getInstance("JSDP", this.getSecureProvider());
        }
        catch (KeyStoreException e) {
            throw new TokenOperatorBuildException(this.getSecureProvider(), e.getMessage());
        }
    }

    public void open(PinCode pin) throws TokenOperatorOpenException {
        super.open(pin);
        try {
            this.token.login(pin.getBytes());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.tokenProperties.store(baos, null);
            String s = baos.toString();
            baos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
            this.keyStore.load(bais, pin.getPassword());
            bais.close();
            this.setOpenStatus(true);
        }
        catch (PasswordBlockedException e) {
            throw new TokenOperatorOpenException(this.getSecureProvider(), "Password Blocked was occurred when try to login," + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new TokenOperatorOpenException(this.getSecureProvider(), e.toString());
        }
        catch (TokenException e) {
            throw new TokenOperatorOpenException(this.getSecureProvider(), JSDPErrorMessage.getErrorMessage((Exception)((Object)e)));
        }
        catch (Exception e) {
            throw new TokenOperatorOpenException(this.getSecureProvider(), e.getMessage());
        }
    }

    public void open(AgentProfile agent, PinCode pin) throws TokenOperatorOpenException {
        String passphase = String.valueOf(agent.getId()) + " " + new String(pin.getPassword());
        this.open(new PinCode(passphase));
    }

    public void close() throws TokenOperatorOperationFailException {
        super.close();
        try {
            if (this.isOpened()) {
                this.keyStore.store(null, null);
                this.setOpenStatus(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CryptoOperator getCeryptoOperator() {
        return new JSDPCryptoOperator(this.token);
    }

    public SecureStoreOperator getStoreOperator() {
        return new JSDPStoreOperator(this.token, this.keyStore);
    }

    public boolean isSafe() {
        return true;
    }

    public void lock(PinCode pin, PinCode setPin) throws TokenOperatorLockException, TokenOperationNotSupportException {
        try {
            this.token.changePassword(pin.getBytes(), setPin.getBytes());
        }
        catch (TokenException e) {
            String message = e.getMessage();
            if (message.indexOf("ChangePassword is not supported") > -1) {
                throw new TokenOperationNotSupportException(this.getSecureProvider(), message);
            }
            throw new TokenOperatorLockException(this.getSecureProvider(), message);
        }
    }

    public void lock(PinCode pin) throws TokenOperatorLockException, TokenOperationNotSupportException {
        PinCode nulPin = new PinCode(new char[1]);
        this.lock(nulPin, pin);
    }

    public void wipe() throws TokenOperatorOperationFailException {
        super.wipe();
        try {
            String alias;
            Enumeration enu = this.token.getKeys().keys();
            while (enu.hasMoreElements()) {
                alias = (String)enu.nextElement();
                this.token.removeKey(alias);
            }
            enu = this.token.getCertificates().keys();
            while (enu.hasMoreElements()) {
                alias = (String)enu.nextElement();
                this.token.removeCertificate(alias, true);
            }
            enu = this.token.getDataObjects().keys();
            while (enu.hasMoreElements()) {
                alias = (String)enu.nextElement();
                this.token.removeDataObject(alias, true);
            }
        }
        catch (Exception e) {
            throw new TokenOperatorOperationFailException(this.getSecureProvider(), "Fail to wipe all entry on token," + e.getMessage());
        }
    }
}

