/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.WSJSDP;

import com.entegrity.jsdp.security.token.Token;
import com.entegrity.jsdp.security.token.TokenCertificateEntry;
import com.entegrity.jsdp.security.token.TokenException;
import com.entegrity.jsdp.security.token.TokenProperties;
import com.entegrity.jsdp.utils.Formatter;
import com.entegrity.jsdp.utils.Misc;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TreeSet;

public class JSDPTokenViewer {
    private static String ns = System.getProperty("line.separator");
    private Token token;

    protected JSDPTokenViewer(Token token) {
        this.token = token;
    }

    private String toString(Properties prop) {
        StringBuffer buf = new StringBuffer();
        TreeSet<String> lines = new TreeSet<String>();
        Enumeration<?> enu = prop.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String val = prop.getProperty(key);
            lines.add(String.valueOf(key) + " = " + val);
        }
        for (String line : lines) {
            buf.append(String.valueOf(line) + ns);
        }
        return buf.toString();
    }

    private String toString(Key key) {
        StringBuffer buf = new StringBuffer();
        buf.append(Formatter.toEntry((String)"Class", (Object)key.getClass().getName()));
        buf.append(Formatter.toEntry((String)"Content", (Object)key.toString()));
        return buf.toString();
    }

    private String toString(Certificate cert) {
        StringBuffer buf = new StringBuffer();
        String info = Misc.replace((String)cert.toString(), (String)"\n", (String)ns);
        info = Misc.replace((String)info, (String)(String.valueOf(ns) + ns), (String)ns);
        buf.append(info);
        if (cert instanceof X509Certificate) {
            X509Certificate x509Cert = (X509Certificate)cert;
            buf.append("Extension" + ns);
            String unsuppExt = x509Cert.hasUnsupportedCriticalExtension() ? "True" : "False";
            buf.append(Formatter.indent((String)Formatter.toEntry((String)"Has unsupported critical extension", (Object)unsuppExt)));
        }
        return buf.toString();
    }

    private String toString(byte[] byteArray) {
        return this.toString(byteArray, 0, byteArray.length, ":");
    }

    private String toString(byte[] byteArray, int off, int len, String delimiter) {
        if (byteArray.length < off + len) {
            len = byteArray.length - off;
        }
        StringBuffer sb = new StringBuffer(2 * len);
        boolean first = true;
        int i = 0;
        while (i < len) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(this.toString(byteArray[off + i]));
            ++i;
        }
        return sb.toString();
    }

    private String toString(byte b) {
        StringBuffer sb = new StringBuffer(2);
        int h = (b & 0xF0) >> 4;
        int l = b & 0xF;
        sb.append(new Character((char)(h > 9 ? 65 + h - 10 : 48 + h)));
        sb.append(new Character((char)(l > 9 ? 65 + l - 10 : 48 + l)));
        return sb.toString();
    }

    public String getInfo() {
        String alias;
        Enumeration enu;
        Hashtable tbl;
        StringBuffer buf = new StringBuffer();
        try {
            TokenProperties tp = this.token.getTokenProperties();
            buf.append(Formatter.toEntry((String)"Token type", (Object)(tp.isHardwareToken() ? "Hardware" : "Software")));
            buf.append(Formatter.toEntry((String)"Has protected authentication path", (Object)(tp.hasProtectedAuthenticationPath() ? "yes" : "no")));
            buf.append(Formatter.toEntry((String)"Has random number generator", (Object)(tp.hasRandomNumberGenerator() ? "yes" : "no")));
            buf.append(Formatter.toEntry((String)"Supported mechanisms", (Object)Misc.toVector(tp.getSupportedMechanisms().iterator()).toArray()));
        }
        catch (TokenException ex) {
            buf.append("*** Failed to get token properties" + ns);
        }
        try {
            tbl = this.token.getKeys();
            enu = tbl.keys();
            while (enu.hasMoreElements()) {
                alias = (String)enu.nextElement();
                Key key = (Key)tbl.get(alias);
                buf.append(Formatter.toEntry((String)"Key Object", (Object)(String.valueOf(Formatter.toEntry((String)"Alias", (Object)alias)) + Formatter.toEntry((String)"Algo", (Object)key.getAlgorithm()))));
            }
        }
        catch (TokenException ex) {
            buf.append("*** Failed to get key objects from token." + ns);
        }
        try {
            tbl = this.token.getCertificates();
            enu = tbl.keys();
            while (enu.hasMoreElements()) {
                alias = (String)enu.nextElement();
                TokenCertificateEntry entry = (TokenCertificateEntry)tbl.get(alias);
                com.entegrity.jsdp.iaik.x509.X509Certificate cert = entry.getCertificate();
                buf.append(Formatter.toEntry((String)"Certificate Object", (Object)(String.valueOf(Formatter.toEntry((String)"Alias", (Object)alias)) + Formatter.toEntry((String)"Trusted", (Object)(entry.isTrusted() ? "yes" : "no")) + Formatter.toEntry((String)"Certificate", (Object)this.toString((Certificate)cert)))));
            }
        }
        catch (TokenException ex) {
            buf.append("*** Failed to get certificates objects from token" + ns);
        }
        try {
            tbl = this.token.getDataObjects();
            enu = tbl.keys();
            while (enu.hasMoreElements()) {
                alias = (String)enu.nextElement();
                byte[] data = (byte[])tbl.get(alias);
                buf.append(Formatter.toEntry((String)"Data Object", (Object)(String.valueOf(Formatter.toEntry((String)"Alias", (Object)alias)) + Formatter.toEntry((String)"Data", (Object)this.toString(data)))));
            }
        }
        catch (TokenException ex) {
            buf.append("*** Failed to get key objects from token" + ns);
        }
        return buf.toString();
    }
}

