/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.P7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkcs7.SignedAndEnvelopedData;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.OIDs;
import th.co.oga.security.pki.P7.P7DigestedData;
import th.co.oga.security.pki.P7.P7EncryptedData;
import th.co.oga.security.pki.P7.P7EnvelopedData;
import th.co.oga.security.pki.P7.P7SignedData;

public class P7ContentInfo
implements ASN1Value {
    public static final Tag TAG = SEQUENCE.TAG;
    public static OBJECT_IDENTIFIER DATA = new OBJECT_IDENTIFIER(OIDs.PKCS7Data);
    public static OBJECT_IDENTIFIER SIGNED_DATA = new OBJECT_IDENTIFIER(OIDs.PKCS7signedData);
    public static OBJECT_IDENTIFIER ENVELOPED_DATA = new OBJECT_IDENTIFIER(OIDs.PKCS7envelopedData);
    public static OBJECT_IDENTIFIER SIGNED_AND_ENVELOPED_DATA = new OBJECT_IDENTIFIER(OIDs.PKCS7signedAndEnvelopedData);
    public static OBJECT_IDENTIFIER DIGESTED_DATA = new OBJECT_IDENTIFIER(OIDs.PKCS7digestedData);
    public static OBJECT_IDENTIFIER ENCRYPTED_DATA = new OBJECT_IDENTIFIER(OIDs.PKCS7encryptedData);
    private OBJECT_IDENTIFIER contentType;
    private ANY content;
    private SEQUENCE sequence = new SEQUENCE();
    private static Template templateInstance = new Template();

    private P7ContentInfo() {
    }

    public P7ContentInfo(OBJECT_IDENTIFIER contentType, ASN1Value content) {
        this.contentType = contentType;
        this.sequence.addElement((ASN1Value)contentType);
        if (content != null) {
            if (content instanceof ANY) {
                this.content = (ANY)content;
            } else {
                try {
                    this.content = (ANY)ASN1Util.decode((ASN1Template)ANY.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)content));
                }
                catch (InvalidBERException e) {
                    Assert.notReached((String)"InvalidBERException while convertingASN1Value to ANY");
                }
            }
            this.sequence.addElement((ASN1Value)new EXPLICIT(new Tag(0L), content));
        }
    }

    public P7ContentInfo(byte[] data) {
        this(DATA, (ASN1Value)new OCTET_STRING(data));
    }

    public P7ContentInfo(P7SignedData sd) {
        this(SIGNED_DATA, sd);
    }

    public P7ContentInfo(P7EnvelopedData ed) {
        this(ENVELOPED_DATA, ed);
    }

    public P7ContentInfo(SignedAndEnvelopedData sed) {
        this(SIGNED_AND_ENVELOPED_DATA, (ASN1Value)sed);
    }

    public P7ContentInfo(P7DigestedData dd) {
        this(DIGESTED_DATA, dd);
    }

    public P7ContentInfo(P7EncryptedData ed) {
        this(ENCRYPTED_DATA, ed);
    }

    public OBJECT_IDENTIFIER getContentType() {
        return this.contentType;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public ASN1Value getInterpretedContent() throws InvalidBERException {
        if (this.contentType.equals((Object)DATA)) {
            return this.content.decodeWith((ASN1Template)new OCTET_STRING.Template());
        }
        if (this.contentType.equals((Object)SIGNED_DATA)) {
            return this.content.decodeWith((ASN1Template)new P7SignedData.Template());
        }
        if (this.contentType.equals((Object)ENVELOPED_DATA)) {
            return this.content.decodeWith((ASN1Template)new P7EnvelopedData.Template());
        }
        if (this.contentType.equals((Object)SIGNED_AND_ENVELOPED_DATA)) {
            return this.content.decodeWith((ASN1Template)new SignedAndEnvelopedData.Template());
        }
        if (this.contentType.equals((Object)DIGESTED_DATA)) {
            return this.content.decodeWith((ASN1Template)new P7DigestedData.Template());
        }
        if (this.contentType.equals((Object)ENCRYPTED_DATA)) {
            return this.content.decodeWith((ASN1Template)new P7EncryptedData.Template());
        }
        return this.content;
    }

    public ANY getContent() {
        return this.content;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public boolean tagMatch(Tag tag) {
            return tag.equals((Object)TAG);
        }

        public Template() {
            this.seqt.addElement((ASN1Template)new OBJECT_IDENTIFIER.Template());
            this.seqt.addOptionalElement((ASN1Template)new EXPLICIT.Template(new Tag(0L), (ASN1Template)new ANY.Template()));
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            Assert._assert((seq.size() == 2 ? 1 : 0) != 0);
            ASN1Value content = seq.elementAt(1) == null ? null : ((EXPLICIT)seq.elementAt(1)).getContent();
            return new P7ContentInfo((OBJECT_IDENTIFIER)seq.elementAt(0), content);
        }
    }
}

