/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.P7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.P7.P7EncryptedContentInfo;

public class P7EncryptedData
implements ASN1Value {
    private INTEGER version;
    private P7EncryptedContentInfo encryptedContentInfo;
    private SEQUENCE sequence;
    public static final INTEGER DEFAULT_VERSION = new INTEGER(0L);
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private P7EncryptedData() {
    }

    public P7EncryptedData(INTEGER version, P7EncryptedContentInfo encryptedContentInfo) {
        if (version == null || encryptedContentInfo == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.sequence = new SEQUENCE();
        this.version = version;
        this.sequence.addElement((ASN1Value)version);
        this.encryptedContentInfo = encryptedContentInfo;
        this.sequence.addElement((ASN1Value)encryptedContentInfo);
    }

    public P7EncryptedData(P7EncryptedContentInfo encryptedContentInfo) {
        this(DEFAULT_VERSION, encryptedContentInfo);
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public P7EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement((ASN1Template)P7EncryptedContentInfo.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new P7EncryptedData((INTEGER)seq.elementAt(0), (P7EncryptedContentInfo)seq.elementAt(1));
        }
    }
}

