/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.P7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.P7.P7EncryptedContentInfo;
import th.co.oga.security.pki.P7.P7RecipientInfo;

public class P7EnvelopedData
implements ASN1Value {
    private INTEGER version;
    private SET recipientInfos;
    private P7EncryptedContentInfo encryptedContentInfo;
    private SEQUENCE sequence = new SEQUENCE();
    public static final Tag TAG = SEQUENCE.TAG;

    private P7EnvelopedData() {
    }

    public P7EnvelopedData(SET recipientInfos, P7EncryptedContentInfo encryptedContentInfo) {
        this(new INTEGER(1L), recipientInfos, encryptedContentInfo);
    }

    public P7EnvelopedData(INTEGER version, SET recipientInfos, P7EncryptedContentInfo encryptedContentInfo) {
        this.version = version;
        this.recipientInfos = recipientInfos;
        this.encryptedContentInfo = encryptedContentInfo;
        this.sequence.addElement((ASN1Value)version);
        this.sequence.addElement((ASN1Value)recipientInfos);
        this.sequence.addElement((ASN1Value)encryptedContentInfo);
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public SET getRecipientInfos() {
        return this.recipientInfos;
    }

    public P7EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag tag, OutputStream ostream) throws IOException {
        this.sequence.encode(tag, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static class Template
    implements ASN1Template {
        public Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals((Object)TAG);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.Template seqt = new SEQUENCE.Template();
            seqt.addElement((ASN1Template)new INTEGER.Template());
            seqt.addElement((ASN1Template)new SET.OF_Template((ASN1Template)new P7RecipientInfo.Template()));
            seqt.addElement((ASN1Template)new P7EncryptedContentInfo.Template());
            SEQUENCE seq = (SEQUENCE)seqt.decode(implicitTag, istream);
            Assert._assert((seq.size() == 3 ? 1 : 0) != 0);
            return new P7EnvelopedData((INTEGER)seq.elementAt(0), (SET)seq.elementAt(1), (P7EncryptedContentInfo)seq.elementAt(2));
        }
    }
}

