/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.P7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.X500.DName;

public class P7IssuerAndSerialNumber
implements ASN1Value {
    private DName issuer;
    private INTEGER serialNumber;
    private SEQUENCE sequence;
    static Tag TAG = SEQUENCE.TAG;
    private static Template templateInstance = new Template();

    private P7IssuerAndSerialNumber() {
    }

    public P7IssuerAndSerialNumber(DName issuer, INTEGER serialNumber) {
        if (issuer == null || serialNumber == null) {
            throw new IllegalArgumentException();
        }
        this.issuer = issuer;
        this.serialNumber = serialNumber;
        this.sequence = new SEQUENCE();
        this.sequence.addElement((ASN1Value)issuer);
        this.sequence.addElement((ASN1Value)serialNumber);
    }

    public P7IssuerAndSerialNumber(X509Certificate cer) throws ASN1Exception {
        this(DName.getInstance(cer.getIssuerX500Principal()), new INTEGER(cer.getSerialNumber()));
    }

    public boolean isSame(X509Certificate cer) throws ASN1Exception {
        return this.issuer.getX500Principal().equals(cer.getIssuerX500Principal()) && this.serialNumber.compareTo(cer.getSerialNumber()) == 0;
    }

    public DName getIssuer() {
        return this.issuer;
    }

    public INTEGER getSerialNumber() {
        return this.serialNumber;
    }

    public String getSerialString() {
        return this.serialNumber.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof P7IssuerAndSerialNumber) {
            P7IssuerAndSerialNumber iasn = (P7IssuerAndSerialNumber)obj;
            if (this.issuer.getSubject().equals(iasn.getIssuer().getSubject()) && this.serialNumber.compareTo(iasn.getSerialNumber().abs()) == 0) {
                return true;
            }
        }
        return false;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)Name.getTemplate());
            this.seqt.addElement(INTEGER.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            Assert._assert((seq.size() == 2 ? 1 : 0) != 0);
            DName name = new DName((Name)seq.elementAt(0));
            return new P7IssuerAndSerialNumber(name, (INTEGER)seq.elementAt(1));
        }
    }
}

