/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.P7;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.P7.P7Adapter;
import th.co.oga.security.pki.P7.P7ContentInfo;
import th.co.oga.security.pki.P7.P7EnvelopedData;
import th.co.oga.security.pki.P7.P7SignedData;
import th.co.oga.security.pki.Packaging.RawEnvelopedData;
import th.co.oga.security.pki.Packaging.RawSignedData;
import th.co.oga.security.pki.Packaging.SecurePackageEncodingFailException;
import th.co.oga.security.pki.Packaging.SecurePackageInvalidDataException;
import th.co.oga.security.pki.Packaging.SecurePackager;

public class P7Packager
extends SecurePackager {
    private P7Adapter adapter;

    public P7Packager(Room room) throws AlgorithmSupportException, EntryNotFoundException, SecureStoreException {
        super(room.getSecureOperator());
        room.applyPolicy(this);
        this.adapter = new P7Adapter(room.getCryptoOperator().getSupportAlgorithm());
    }

    public byte[] decodeData(byte[] content) {
        try {
            P7ContentInfo.Template reader = new P7ContentInfo.Template();
            P7ContentInfo contentInfo = (P7ContentInfo)ASN1Util.decode((ASN1Template)reader, (byte[])content);
            return contentInfo.getContent().getContents();
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte[] encodeData(byte[] data) {
        P7ContentInfo content = new P7ContentInfo(data);
        return ASN1Util.encode((ASN1Value)content);
    }

    public RawSignedData importSignedData(InputStream in) throws SecurePackageEncodingFailException {
        try {
            P7SignedData.Template reader = new P7SignedData.Template();
            return this.adapter.getRawSignedData((P7SignedData)reader.decode(new BufferedInputStream(in)));
        }
        catch (Exception e) {
            throw new SecurePackageEncodingFailException(e.getMessage());
        }
    }

    public RawSignedData importSignedData(byte[] bytes) throws SecurePackageEncodingFailException {
        ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
        return this.importSignedData(bi);
    }

    public void exportSignedData(RawSignedData signedData, OutputStream out) throws SecurePackageInvalidDataException {
        try {
            this.adapter.getP7SignedData(signedData).encode(out);
        }
        catch (Exception e) {
            throw new SecurePackageInvalidDataException(e.getMessage());
        }
    }

    public byte[] exportSignedData(RawSignedData signedData) throws SecurePackageInvalidDataException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        this.exportSignedData(signedData, bo);
        return bo.toByteArray();
    }

    public RawEnvelopedData importEnvelopedData(InputStream in) throws SecurePackageEncodingFailException {
        try {
            P7EnvelopedData.Template reader = new P7EnvelopedData.Template();
            return this.adapter.getRawEnvelopedData((P7EnvelopedData)reader.decode(new BufferedInputStream(in)));
        }
        catch (Exception e) {
            throw new SecurePackageEncodingFailException(e.getMessage());
        }
    }

    public RawEnvelopedData importEnvelopedData(byte[] bytes) throws SecurePackageEncodingFailException {
        ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
        return this.importEnvelopedData(bi);
    }

    public void exportEnvelopedData(RawEnvelopedData envelopedData, OutputStream out) throws SecurePackageInvalidDataException {
        try {
            this.adapter.getP7EnvelopedData(envelopedData).encode(out);
        }
        catch (Exception e) {
            throw new SecurePackageInvalidDataException(e.getMessage());
        }
    }

    public byte[] exportEnvelopedData(RawEnvelopedData envelopedData) throws SecurePackageInvalidDataException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        this.exportEnvelopedData(envelopedData, bo);
        return bo.toByteArray();
    }

    public void getData(byte[] contentInfo, OutputStream out) throws SecurePackageInvalidDataException {
        try {
            out.write(this.decodeData(contentInfo));
        }
        catch (Exception e) {
            throw new SecurePackageInvalidDataException("P7SecurePackager", "ContentInfo", e.getMessage());
        }
    }

    public byte[] getData(byte[] contentInfo) throws SecurePackageInvalidDataException {
        return this.decodeData(contentInfo);
    }

    public void getData(RawSignedData signedData, OutputStream out) throws SecurePackageInvalidDataException {
        try {
            out.write(this.decodeData(signedData.getData()));
        }
        catch (Exception e) {
            throw new SecurePackageInvalidDataException("P7SecurePackager", "ContentInfo", e.getMessage());
        }
    }

    public byte[] getData(RawSignedData signedData) throws SecurePackageInvalidDataException {
        return this.decodeData(signedData.getData());
    }
}

