/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.P7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.P7.P7IssuerAndSerialNumber;

public class P7RecipientInfo
implements ASN1Value {
    private INTEGER version;
    private P7IssuerAndSerialNumber issuerAndSerialNumber;
    private AlgorithmIdentifier keyEncryptionAlgorithmID;
    private OCTET_STRING encryptedKey;
    private SEQUENCE sequence = new SEQUENCE();
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private P7RecipientInfo() {
    }

    public P7RecipientInfo(P7IssuerAndSerialNumber iASN, AlgorithmIdentifier keyAlgID, byte[] encryptedKey) {
        this(new INTEGER(1L), iASN, keyAlgID, new OCTET_STRING(encryptedKey));
    }

    public P7RecipientInfo(INTEGER version, P7IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmIdentifier keyEncryptionAlgorithmID, OCTET_STRING encryptedKey) {
        Assert._assert((issuerAndSerialNumber != null ? 1 : 0) != 0);
        Assert._assert((keyEncryptionAlgorithmID != null ? 1 : 0) != 0);
        Assert._assert((encryptedKey != null ? 1 : 0) != 0);
        this.version = version;
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.keyEncryptionAlgorithmID = keyEncryptionAlgorithmID;
        this.encryptedKey = encryptedKey;
        this.sequence.addElement((ASN1Value)version);
        this.sequence.addElement((ASN1Value)issuerAndSerialNumber);
        this.sequence.addElement((ASN1Value)keyEncryptionAlgorithmID);
        this.sequence.addElement((ASN1Value)encryptedKey);
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public P7IssuerAndSerialNumber getissuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithmID() {
        return this.keyEncryptionAlgorithmID;
    }

    public OCTET_STRING getEncryptedKey() {
        return this.encryptedKey;
    }

    public byte[] getEncryptedKeyByte() {
        return this.encryptedKey.toByteArray();
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag tag, OutputStream ostream) throws IOException {
        this.sequence.encode(tag, ostream);
    }

    public static class Template
    implements ASN1Template {
        public Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals((Object)TAG);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.Template seqt = new SEQUENCE.Template();
            seqt.addElement((ASN1Template)new INTEGER.Template());
            seqt.addElement((ASN1Template)new P7IssuerAndSerialNumber.Template());
            seqt.addElement((ASN1Template)new AlgorithmIdentifier.Template());
            seqt.addElement((ASN1Template)new OCTET_STRING.Template());
            SEQUENCE seq = (SEQUENCE)seqt.decode(implicitTag, istream);
            Assert._assert((seq.size() == 4 ? 1 : 0) != 0);
            return new P7RecipientInfo((INTEGER)seq.elementAt(0), (P7IssuerAndSerialNumber)seq.elementAt(1), (AlgorithmIdentifier)seq.elementAt(2), (OCTET_STRING)seq.elementAt(3));
        }
    }
}

