/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.P7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.P7.P7ContentInfo;
import th.co.oga.security.pki.P7.P7SignerInfo;

public class P7SignedData
implements ASN1Value {
    private static final INTEGER VERSION = new INTEGER(1L);
    private INTEGER version;
    private SET digestAlgorithms;
    private P7ContentInfo contentInfo;
    private SET certificates;
    private SET crls;
    private SET signerInfos;
    static final Tag TAG = SEQUENCE.TAG;

    public P7SignedData(SET digestAlg, P7ContentInfo contentInfo, SET certs, SET crls, SET signerInfos) {
        this.version = VERSION;
        this.digestAlgorithms = digestAlg == null ? new SET() : digestAlg;
        P7SignedData.verifyNotNull(contentInfo);
        this.contentInfo = contentInfo;
        this.certificates = certs;
        this.crls = crls;
        this.signerInfos = signerInfos == null ? new SET() : signerInfos;
    }

    P7SignedData(INTEGER version, SET digestAlgorithms, P7ContentInfo contentInfo, SET certificates, SET crls, SET signerInfos) {
        P7SignedData.verifyNotNull(version);
        this.version = version;
        P7SignedData.verifyNotNull(digestAlgorithms);
        this.digestAlgorithms = digestAlgorithms;
        P7SignedData.verifyNotNull(contentInfo);
        this.contentInfo = contentInfo;
        this.certificates = certificates;
        this.crls = crls;
        P7SignedData.verifyNotNull(signerInfos);
        this.signerInfos = signerInfos;
    }

    public P7SignedData(P7ContentInfo contentInfo) {
        this(null, contentInfo, new SET(), null, null);
    }

    private static void verifyNotNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public SET getDigestAlgorithmIdentifiers() {
        return this.digestAlgorithms;
    }

    public P7ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public SET getCertificates() {
        return this.certificates;
    }

    public boolean hasCertificates() {
        return this.certificates != null;
    }

    public SET getCrls() {
        return this.crls;
    }

    public boolean hasCrls() {
        return this.crls != null;
    }

    public SET getSignerInfos() {
        return this.signerInfos;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag tag, OutputStream ostream) throws IOException {
        SEQUENCE sequence = new SEQUENCE();
        sequence.addElement((ASN1Value)this.version);
        sequence.addElement((ASN1Value)this.digestAlgorithms);
        sequence.addElement((ASN1Value)this.contentInfo);
        if (this.certificates != null) {
            sequence.addElement(new Tag(0L), (ASN1Value)this.certificates);
        }
        if (this.crls != null) {
            sequence.addElement(new Tag(1L), (ASN1Value)this.crls);
        }
        sequence.addElement((ASN1Value)this.signerInfos);
        sequence.encode(tag, ostream);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement((ASN1Template)new SET.OF_Template((ASN1Template)AlgorithmIdentifier.getTemplate()));
            this.seqt.addElement((ASN1Template)P7ContentInfo.getTemplate());
            this.seqt.addOptionalElement(new Tag(0L), (ASN1Template)new SET.OF_Template((ASN1Template)Certificate.getTemplate()));
            this.seqt.addOptionalElement(new Tag(1L), (ASN1Template)new SET.OF_Template((ASN1Template)ANY.getTemplate()));
            this.seqt.addElement((ASN1Template)new SET.OF_Template((ASN1Template)P7SignerInfo.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            Assert._assert((seq.size() == 6 ? 1 : 0) != 0);
            return new P7SignedData((INTEGER)seq.elementAt(0), (SET)seq.elementAt(1), (P7ContentInfo)seq.elementAt(2), (SET)seq.elementAt(3), (SET)seq.elementAt(4), (SET)seq.elementAt(5));
        }
    }
}

