/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.P7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Attribute;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.OIDs;
import th.co.oga.security.pki.Operation.CryptoOperatorException;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operator.SecureOperator;
import th.co.oga.security.pki.P7.P7ContentInfo;
import th.co.oga.security.pki.P7.P7IssuerAndSerialNumber;

public class P7SignerInfo
implements ASN1Value {
    private static final OBJECT_IDENTIFIER CONTENT_TYPE = new OBJECT_IDENTIFIER(OIDs.PKCS9_ContentType);
    private static final OBJECT_IDENTIFIER MESSAGE_DIGEST = new OBJECT_IDENTIFIER(OIDs.PKCS9_MessageDigest);
    private INTEGER version;
    private P7IssuerAndSerialNumber issuerAndSerialNumber;
    private SET authenticatedAttributes;
    private SET unauthenticatedAttributes;
    private OCTET_STRING encryptedDigest;
    private AlgorithmIdentifier digestAlgorithm;
    private AlgorithmIdentifier signatureAlgorithm;
    private static final INTEGER VERSION = new INTEGER(1L);
    private static final Tag TAG = SEQUENCE.TAG;
    private static Template TEMPLATE = new Template();

    protected P7SignerInfo(INTEGER version, P7IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmIdentifier digestAlgorithm, SET authenticatedAttributes, AlgorithmIdentifier signatureAlgorithm, byte[] encryptedDigest, SET unauthenticatedAttributes) {
        this.version = version;
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.digestAlgorithm = digestAlgorithm;
        this.authenticatedAttributes = authenticatedAttributes;
        this.signatureAlgorithm = signatureAlgorithm;
        this.encryptedDigest = new OCTET_STRING(encryptedDigest);
        this.unauthenticatedAttributes = unauthenticatedAttributes;
    }

    public P7SignerInfo(P7IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmIdentifier digestAlgorithm, AlgorithmIdentifier signatureAlgorithm, byte[] signature) {
        this(VERSION, issuerAndSerialNumber, digestAlgorithm, new SET(), signatureAlgorithm, signature, new SET());
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public P7IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifer() {
        return this.digestAlgorithm;
    }

    public SET getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public boolean hasAuthenticatedAttributes() {
        return this.authenticatedAttributes != null;
    }

    public AlgorithmIdentifier getSignatureAlgorithmIdentifier() {
        return this.signatureAlgorithm;
    }

    public byte[] getDigitalSignature() {
        return this.encryptedDigest.toByteArray();
    }

    public SET getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public boolean hasUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes != null;
    }

    public static P7SignerInfo getInstance(SecureOperator oper, CertProfile signerCert, SET signAttributes, SET unsignAttributes, OBJECT_IDENTIFIER contentType, byte[] msgDigest, AlgorithmProfile signAlg) throws AlgorithmSupportException, NoSuchAlgorithmException, SignatureException, CryptoOperatorException, ASN1Exception, SecureStoreException {
        byte[] toBeSigned;
        AlgorithmProfile dsgAlg = oper.getDigestAlgorithm(signAlg.getMessageDigestAlgorithmName());
        SET authenticatedAttributes = null;
        SET unauthenticatedAttributes = null;
        INTEGER version = VERSION;
        P7IssuerAndSerialNumber issuerAndSerialNumber = new P7IssuerAndSerialNumber(signerCert.getX509Cert());
        AlgorithmIdentifier digestAlgorithm = new AlgorithmIdentifier(new OBJECT_IDENTIFIER(dsgAlg.getOID()));
        AlgorithmIdentifier signatureAlgorithm = new AlgorithmIdentifier(new OBJECT_IDENTIFIER(signAlg.getOID()));
        if (!contentType.equals((Object)P7ContentInfo.DATA)) {
            if (signAttributes == null) {
                signAttributes = new SET();
            }
            Attribute attrib = new Attribute(CONTENT_TYPE, (ASN1Value)P7ContentInfo.DATA);
            signAttributes.addElement((ASN1Value)attrib);
            attrib = new Attribute(MESSAGE_DIGEST, (ASN1Value)new OCTET_STRING(msgDigest));
            signAttributes.addElement((ASN1Value)attrib);
        }
        if (signAttributes != null) {
            Assert._assert((signAttributes.size() >= 2 ? 1 : 0) != 0);
            authenticatedAttributes = signAttributes;
        }
        byte[] digest = null;
        if (signAttributes == null) {
            digest = msgDigest;
        } else {
            MessageDigest md = oper.getCryptoOperator().getMessageDigest(dsgAlg);
            digest = md.digest(ASN1Util.encode((ASN1Value)signAttributes));
        }
        if (signAlg.isInPath("RSA")) {
            SEQUENCE digestInfo = new SEQUENCE();
            digestInfo.addElement((ASN1Value)new AlgorithmIdentifier(digestAlgorithm.getOID(), null));
            digestInfo.addElement((ASN1Value)new OCTET_STRING(digest));
            toBeSigned = ASN1Util.encode((ASN1Value)digestInfo);
        } else {
            toBeSigned = digest;
        }
        Signature sig = oper.getSigner(signerCert, signAlg);
        sig.update(toBeSigned);
        OCTET_STRING encryptedDigest = new OCTET_STRING(sig.sign());
        if (unsignAttributes != null) {
            unauthenticatedAttributes = unsignAttributes;
        }
        return new P7SignerInfo(version, issuerAndSerialNumber, digestAlgorithm, authenticatedAttributes, signatureAlgorithm, encryptedDigest.toByteArray(), unauthenticatedAttributes);
    }

    public void verify(SecureOperator oper, byte[] messageDigest, OBJECT_IDENTIFIER contentType, CertProfile signedCer) throws AlgorithmSupportException, NoSuchAlgorithmException, SignatureException, CryptoOperatorException {
        if (this.authenticatedAttributes == null) {
            this.verifyWithoutAuthenticatedAttributes(oper, messageDigest, contentType, signedCer);
        } else {
            this.verifyWithAuthenticatedAttributes(oper, messageDigest, contentType, signedCer);
        }
    }

    private void verifyWithoutAuthenticatedAttributes(SecureOperator oper, byte[] msgDigest, OBJECT_IDENTIFIER contentType, CertProfile signedCer) throws AlgorithmSupportException, NoSuchAlgorithmException, SignatureException, CryptoOperatorException {
        byte[] toBeVerified;
        if (!contentType.equals((Object)P7ContentInfo.DATA)) {
            throw new SignatureException("Content-Type is not DATA, but there are no authenticated attributes");
        }
        AlgorithmProfile signedAlg = oper.getSupportAlgorithm().getSignatureAlgorithm().findByOID(this.signatureAlgorithm.getOID().getNumbers());
        if (signedAlg.isInPath("RSA")) {
            SEQUENCE digestInfo = new SEQUENCE();
            digestInfo.addElement((ASN1Value)new AlgorithmIdentifier(this.digestAlgorithm.getOID(), null));
            digestInfo.addElement((ASN1Value)new OCTET_STRING(msgDigest));
            toBeVerified = ASN1Util.encode((ASN1Value)digestInfo);
        } else {
            toBeVerified = msgDigest;
        }
        Signature sig = oper.getVerifier(signedCer, signedAlg);
        sig.update(toBeVerified);
        if (!sig.verify(this.encryptedDigest.toByteArray())) {
            throw new SignatureException("Message digest parameter does not match message digest in XSignerInfo");
        }
    }

    private void verifyWithAuthenticatedAttributes(SecureOperator oper, byte[] msgDigest, OBJECT_IDENTIFIER contentType, CertProfile signedCer) throws AlgorithmSupportException, NoSuchAlgorithmException, SignatureException, CryptoOperatorException {
        byte[] toBeVerified;
        int numAttrib = this.authenticatedAttributes.size();
        if (numAttrib < 2) {
            throw new SignatureException("At least two authenticated attributes must be present, content-type and message-digest");
        }
        boolean foundContentType = false;
        boolean foundMessageDigest = false;
        int i = 0;
        while (i < numAttrib) {
            ASN1Value val;
            SET vals;
            if (!(this.authenticatedAttributes.elementAt(i) instanceof Attribute)) {
                throw new SignatureException("Element of authenticatedAttributes is not an Attribute");
            }
            Attribute attrib = (Attribute)this.authenticatedAttributes.elementAt(i);
            if (attrib.getType().equals((Object)CONTENT_TYPE)) {
                OBJECT_IDENTIFIER ctype;
                block23: {
                    vals = attrib.getValues();
                    if (vals.size() != 1) {
                        throw new SignatureException("Content-Type attribute does not have exactly one value");
                    }
                    val = vals.elementAt(0);
                    try {
                        if (val instanceof OBJECT_IDENTIFIER) {
                            ctype = (OBJECT_IDENTIFIER)val;
                            break block23;
                        }
                        if (val instanceof ANY) {
                            ctype = (OBJECT_IDENTIFIER)((ANY)val).decodeWith((ASN1Template)OBJECT_IDENTIFIER.getTemplate());
                            break block23;
                        }
                        throw new InvalidBERException("Content-Type authenticated attribute has unexpected content type");
                    }
                    catch (InvalidBERException e) {
                        throw new SignatureException("Content-Type authenticated attribute does not have OBJECT IDENTIFIER value ");
                    }
                }
                if (!ctype.equals((Object)contentType)) {
                    throw new SignatureException("Content-type in authenticated attributes does not  match content-type being verified");
                }
                foundContentType = true;
            } else if (attrib.getType().equals((Object)MESSAGE_DIGEST)) {
                byte[] mdigest;
                block24: {
                    vals = attrib.getValues();
                    if (vals.size() != 1) {
                        throw new SignatureException("Message-digest attribute does not have  exactly one value");
                    }
                    val = vals.elementAt(0);
                    try {
                        if (val instanceof OCTET_STRING) {
                            mdigest = ((OCTET_STRING)val).toByteArray();
                            break block24;
                        }
                        if (val instanceof ANY) {
                            OCTET_STRING os = (OCTET_STRING)((ANY)val).decodeWith((ASN1Template)OCTET_STRING.getTemplate());
                            mdigest = os.toByteArray();
                            break block24;
                        }
                        throw new InvalidBERException("Content-Type authenticated attribute has unexpected  content type");
                    }
                    catch (InvalidBERException e) {
                        throw new SignatureException("Message-digest attribute does not have OCTET STRING value");
                    }
                }
                if (!P7SignerInfo.byteArraysAreSame(mdigest, msgDigest)) {
                    throw new SignatureException("Message-digest attribute does not match message digest being verified");
                }
                foundMessageDigest = true;
            }
            ++i;
        }
        if (!foundContentType) {
            throw new SignatureException("Authenticated attributes does not contain PKCS #9 content-type attribute");
        }
        if (!foundMessageDigest) {
            throw new SignatureException("Authenticate attributes does not contain  PKCS #9 message-digest attribute");
        }
        AlgorithmProfile signedAlg = oper.getSupportAlgorithm().getSignatureAlgorithm().findByOID(this.signatureAlgorithm.getOID().getNumbers());
        AlgorithmProfile dsgAlg = oper.getSupportAlgorithm().getMessageDigestAlgorithm().findByOID(this.digestAlgorithm.getOID().getNumbers());
        byte[] toBeDigested = ASN1Util.encode((ASN1Value)this.authenticatedAttributes);
        MessageDigest md = oper.getCryptoOperator().getMessageDigest(dsgAlg);
        byte[] digest = md.digest(toBeDigested);
        if (signedAlg.isInPath("RSA")) {
            SEQUENCE digestInfo = new SEQUENCE();
            digestInfo.addElement((ASN1Value)this.digestAlgorithm);
            digestInfo.addElement((ASN1Value)new OCTET_STRING(digest));
            toBeVerified = ASN1Util.encode((ASN1Value)digestInfo);
        } else {
            toBeVerified = digest;
        }
        Signature sig = oper.getVerifier(signedCer, signedAlg);
        sig.update(toBeVerified);
        if (!sig.verify(this.encryptedDigest.toByteArray())) {
            throw new SignatureException("encryptedDigest was not the correct signature of the contents octets of the DER-encoded authenticated attributes");
        }
    }

    public static boolean byteArraysAreSame(byte[] left, byte[] right) {
        Assert._assert((left != null && right != null ? 1 : 0) != 0);
        if (left.length != right.length) {
            return false;
        }
        int i = 0;
        while (i < left.length) {
            if (left[i] != right[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag tag, OutputStream ostream) throws IOException {
        SEQUENCE sequence = new SEQUENCE();
        sequence.addElement((ASN1Value)this.version);
        sequence.addElement((ASN1Value)this.issuerAndSerialNumber);
        sequence.addElement((ASN1Value)this.digestAlgorithm);
        if (this.authenticatedAttributes != null) {
            sequence.addElement(new Tag(0L), (ASN1Value)this.authenticatedAttributes);
        }
        sequence.addElement((ASN1Value)this.signatureAlgorithm);
        sequence.addElement((ASN1Value)this.encryptedDigest);
        if (this.unauthenticatedAttributes != null) {
            sequence.addElement(new Tag(1L), (ASN1Value)this.unauthenticatedAttributes);
        }
        sequence.encode(tag, ostream);
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement((ASN1Template)P7IssuerAndSerialNumber.getTemplate());
            this.seqt.addElement((ASN1Template)AlgorithmIdentifier.getTemplate());
            this.seqt.addOptionalElement(new Tag(0L), (ASN1Template)new SET.OF_Template((ASN1Template)Attribute.getTemplate()));
            this.seqt.addElement((ASN1Template)AlgorithmIdentifier.getTemplate());
            this.seqt.addElement((ASN1Template)OCTET_STRING.getTemplate());
            this.seqt.addOptionalElement(new Tag(1L), (ASN1Template)new SET.OF_Template((ASN1Template)Attribute.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            Assert._assert((seq.size() == 7 ? 1 : 0) != 0);
            return new P7SignerInfo((INTEGER)seq.elementAt(0), (P7IssuerAndSerialNumber)seq.elementAt(1), (AlgorithmIdentifier)seq.elementAt(2), (SET)seq.elementAt(3), (AlgorithmIdentifier)seq.elementAt(4), ((OCTET_STRING)seq.elementAt(5)).toByteArray(), (SET)seq.elementAt(6));
        }
    }
}

