/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.P7;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Iterator;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.OIDs;
import th.co.oga.security.pki.P7.P7ContentInfo;
import th.co.oga.security.pki.P7.P7DigestInfo;
import th.co.oga.security.pki.P7.P7EncryptedContentInfo;
import th.co.oga.security.pki.P7.P7EnvelopedData;
import th.co.oga.security.pki.P7.P7IssuerAndSerialNumber;
import th.co.oga.security.pki.P7.P7RecipientInfo;
import th.co.oga.security.pki.P7.P7SignedData;
import th.co.oga.security.pki.P7.P7SignerInfo;
import th.co.oga.security.pki.Packaging.RawDigestInfo;
import th.co.oga.security.pki.Packaging.RawEncryptedInfo;
import th.co.oga.security.pki.Packaging.RawEnvelopedData;
import th.co.oga.security.pki.Packaging.RawIssuerAndSerialNumber;
import th.co.oga.security.pki.Packaging.RawRecipientInfo;
import th.co.oga.security.pki.Packaging.RawSignedData;
import th.co.oga.security.pki.Packaging.RawSignerInfo;
import th.co.oga.security.pki.X500.DName;

public class P7Utils {
    private AlgorithmSupportTable algoTable;
    private AlgorithmSet digestAlgos;
    private AlgorithmSet signingAlgos;
    private AlgorithmSet dataEncryptAlgos;
    private AlgorithmSet keyWrapAlgos;
    private AlgorithmSet encryptAlgos;

    public P7Utils(AlgorithmSupportTable algoTable) {
        this.algoTable = algoTable;
        this.digestAlgos = algoTable.getMessageDigestAlgorithm();
        this.signingAlgos = algoTable.getSignatureAlgorithm();
        this.dataEncryptAlgos = algoTable.getSymetricEncryptionAlgorithm();
        this.keyWrapAlgos = algoTable.getAsymetricEncryptionAlgorithm();
        this.encryptAlgos = algoTable.getEncryptionAlgorithm();
    }

    public static OBJECT_IDENTIFIER getObjID(String oid) {
        return new OBJECT_IDENTIFIER(oid);
    }

    public static String getOID(OBJECT_IDENTIFIER objID) {
        return OIDs.fromLongs(objID.getNumbers());
    }

    public static AlgorithmIdentifier getAlgoId(AlgorithmProfile alg, AlgorithmParameters params) throws InvalidBERException, IOException {
        return P7Utils.getAlgoId(alg, params.getEncoded());
    }

    public static AlgorithmIdentifier getAlgoId(AlgorithmProfile alg, byte[] params) throws InvalidBERException, IOException {
        ANY param = null;
        if (params != null) {
            param = new ANY(params);
        }
        return new AlgorithmIdentifier(new OBJECT_IDENTIFIER(alg.getOID()), (ASN1Value)param);
    }

    public static AlgorithmIdentifier getAlgoId(AlgorithmProfile alg) {
        return new AlgorithmIdentifier(new OBJECT_IDENTIFIER(alg.getOID()), null);
    }

    public static byte[] getAlgorithmParamerters(AlgorithmIdentifier algId) {
        if (algId.getParameters() == null) {
            return null;
        }
        ANY param = (ANY)algId.getParameters();
        return param.getEncoded();
    }

    public static String getOID(AlgorithmIdentifier algID) {
        return OIDs.fromLongs(algID.getOID().getNumbers());
    }

    public static ASN1Value getCertificate(byte[] cer) throws ASN1Exception {
        try {
            return ASN1Util.decode((ASN1Template)Certificate.getTemplate(), (byte[])cer);
        }
        catch (Exception e) {
            throw new ASN1Exception("ASN.1 Operation fail, " + e.getMessage());
        }
    }

    public static ASN1Value getCertificate(CertProfile cer) throws ASN1Exception, CertificateEncodingException {
        return P7Utils.getCertificate(cer.getX509Cert().getEncoded());
    }

    public static P7IssuerAndSerialNumber getP7IssuerAndSerialNumber(RawIssuerAndSerialNumber iasn) throws ASN1Exception {
        DName issuer = iasn.getIssuer();
        INTEGER sn = new INTEGER(iasn.getSerialNumber());
        return new P7IssuerAndSerialNumber(issuer, sn);
    }

    public static RawIssuerAndSerialNumber getRawIssuerAndSerialNumber(P7IssuerAndSerialNumber iasn) throws ASN1Exception {
        return new RawIssuerAndSerialNumber(iasn.getIssuer().getX500Principal(), (BigInteger)iasn.getSerialNumber());
    }

    public P7DigestInfo getP7DigestedInfo(RawDigestInfo digestInfo) {
        return new P7DigestInfo(digestInfo.getAlgorithm(), digestInfo.getDigest());
    }

    public RawDigestInfo getRawDigestInfo(P7DigestInfo digestInfo) throws AlgorithmSupportException {
        return new RawDigestInfo(digestInfo.getDigestData(), this.digestAlgos.findByOID(P7Utils.getOID(digestInfo.getDigestAlgorithm())));
    }

    public P7SignerInfo getP7SignerInfo(RawSignerInfo signerInfo) throws AlgorithmSupportException, ASN1Exception {
        CertProfile cert = signerInfo.getSignerCertificate();
        byte[] signature = signerInfo.getSignature();
        AlgorithmProfile signAlg = signerInfo.getAlgorithm();
        AlgorithmProfile digestAlg = this.digestAlgos.findByName(signAlg.getMessageDigestAlgorithmName());
        return new P7SignerInfo(new P7IssuerAndSerialNumber(cert.getX509Cert()), P7Utils.getAlgoId(digestAlg), P7Utils.getAlgoId(signAlg), signature);
    }

    public RawSignerInfo getRawSignerInfo(P7SignerInfo signerInfo, CertProfile signerCert) throws AlgorithmSupportException {
        AlgorithmProfile signAlg = this.signingAlgos.findByOID(P7Utils.getOID(signerInfo.getSignatureAlgorithmIdentifier()));
        byte[] signature = signerInfo.getDigitalSignature();
        return new RawSignerInfo(signature, signAlg, signerCert);
    }

    public P7SignedData getP7SignedData(RawSignedData signedData) throws ASN1Exception, CertificateEncodingException, AlgorithmSupportException {
        try {
            P7ContentInfo contentInfo = (P7ContentInfo)ASN1Util.decode((ASN1Template)P7ContentInfo.getTemplate(), (byte[])signedData.getData());
            SET digestAlgs = new SET();
            Iterator dgs = signedData.getDigestAlgos();
            while (dgs.hasNext()) {
                digestAlgs.addElement((ASN1Value)P7Utils.getAlgoId((AlgorithmProfile)dgs.next()));
            }
            SET certs = new SET();
            SET signers = new SET();
            Iterator sgs = signedData.getSigners();
            while (sgs.hasNext()) {
                RawSignerInfo rs = (RawSignerInfo)sgs.next();
                certs.addElement(P7Utils.getCertificate(rs.getSignerCertificate()));
                signers.addElement((ASN1Value)this.getP7SignerInfo(rs));
            }
            return new P7SignedData(digestAlgs, contentInfo, certs, new SET(), signers);
        }
        catch (InvalidBERException e) {
            throw new ASN1Exception(e.getMessage());
        }
    }

    public RawSignedData getRawSignedData(P7SignedData signedData) throws CertificateException, CertProfileException, IOException, ASN1Exception, AlgorithmSupportException {
        P7ContentInfo content = signedData.getContentInfo();
        RawSignedData rsData = new RawSignedData(ASN1Util.encode((ASN1Value)content));
        SET cers = signedData.getCertificates();
        ArrayList<CertProfile> cs = new ArrayList<CertProfile>();
        ArrayList<P7IssuerAndSerialNumber> cidx = new ArrayList<P7IssuerAndSerialNumber>();
        int i = 0;
        while (i < cers.size()) {
            CertProfile cp = CertProfile.getInstance(ASN1Util.encode((ASN1Value)cers.elementAt(i)));
            cs.add(cp);
            cidx.add(new P7IssuerAndSerialNumber(cp.getX509Cert()));
            ++i;
        }
        SET signers = signedData.getSignerInfos();
        int i2 = 0;
        while (i2 < signers.size()) {
            P7SignerInfo signer = (P7SignerInfo)signers.elementAt(i2);
            rsData.addSigner(this.getRawSignerInfo(signer, (CertProfile)cs.get(cidx.indexOf(signer.getIssuerAndSerialNumber()))));
            ++i2;
        }
        SET dAlgs = signedData.getDigestAlgorithmIdentifiers();
        int i3 = 0;
        while (i3 < dAlgs.size()) {
            rsData.addDigestAlgo(this.digestAlgos.findByOID(P7Utils.getOID((AlgorithmIdentifier)dAlgs.elementAt(i3))));
            ++i3;
        }
        return rsData;
    }

    public P7EncryptedContentInfo getP7EncryptedContentInfo(RawEncryptedInfo encInfo) throws ASN1Exception, IOException {
        try {
            OBJECT_IDENTIFIER contentType = P7Utils.getObjID(encInfo.getContentTypeOID());
            AlgorithmIdentifier encryptAlgorithm = P7Utils.getAlgoId(encInfo.getAlgorithm(), encInfo.getAlgorithmParameters());
            return new P7EncryptedContentInfo(contentType, encryptAlgorithm, encInfo.getCipherText());
        }
        catch (InvalidBERException e) {
            throw new ASN1Exception(e.getMessage());
        }
    }

    public RawEncryptedInfo getRawEncryptedInfo(P7EncryptedContentInfo encInfo) throws AlgorithmSupportException {
        byte[] params = encInfo.getAlgorithmParameters();
        byte[] cipherText = encInfo.getCipherText();
        AlgorithmProfile ap = this.dataEncryptAlgos.findByOID(P7Utils.getOID(encInfo.getContentEncryptionAlgorithm()));
        return new RawEncryptedInfo(cipherText, ap, params, P7Utils.getOID(encInfo.getContentType()));
    }

    public P7RecipientInfo getP7RecipientInfo(RawRecipientInfo rcpInfo) throws ASN1Exception {
        P7IssuerAndSerialNumber iASN = P7Utils.getP7IssuerAndSerialNumber(rcpInfo.getIssuerAndSerialNumber());
        AlgorithmIdentifier keyAlgID = P7Utils.getAlgoId(rcpInfo.getAlgorithm());
        byte[] encryptedKey = rcpInfo.getWrappedKey();
        return new P7RecipientInfo(iASN, keyAlgID, encryptedKey);
    }

    public RawRecipientInfo getRawRecipientInfo(P7RecipientInfo rcpInfo) throws AlgorithmSupportException, ASN1Exception {
        byte[] wrappedKey = rcpInfo.getEncryptedKeyByte();
        AlgorithmProfile algo = this.keyWrapAlgos.findByOID(P7Utils.getOID(rcpInfo.getKeyEncryptionAlgorithmID()));
        return new RawRecipientInfo(wrappedKey, algo, P7Utils.getRawIssuerAndSerialNumber(rcpInfo.getissuerAndSerialNumber()));
    }

    public P7EnvelopedData getP7EnvelopedData(RawEnvelopedData envData) throws ASN1Exception, IOException {
        SET rcps = new SET();
        Iterator itr = envData.getRecipients();
        while (itr.hasNext()) {
            rcps.addElement((ASN1Value)this.getP7RecipientInfo((RawRecipientInfo)itr.next()));
        }
        P7EncryptedContentInfo encInfo = this.getP7EncryptedContentInfo(envData.getEncryptedInfo());
        return new P7EnvelopedData(rcps, encInfo);
    }

    public RawEnvelopedData getRawEnvelopedData(P7EnvelopedData envData) throws AlgorithmSupportException, ASN1Exception {
        RawEnvelopedData renvData = new RawEnvelopedData(this.getRawEncryptedInfo(envData.getEncryptedContentInfo()));
        SET rcps = envData.getRecipientInfos();
        int i = 0;
        while (i < rcps.size()) {
            renvData.addRecipient(this.getRawRecipientInfo((P7RecipientInfo)rcps.elementAt(i)));
            ++i;
        }
        return renvData;
    }
}

