/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Packaging;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Iterator;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Attribute;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.CMS.CMSCertIdentifier;
import th.co.oga.security.pki.CMS.CMSContentInfo;
import th.co.oga.security.pki.CMS.CMSContentType;
import th.co.oga.security.pki.CMS.CMSDigestInfo;
import th.co.oga.security.pki.CMS.CMSEncapsulatedContentInfo;
import th.co.oga.security.pki.CMS.CMSEncryptedContentInfo;
import th.co.oga.security.pki.CMS.CMSEnvelopedData;
import th.co.oga.security.pki.CMS.CMSIssuerAndSerialNumber;
import th.co.oga.security.pki.CMS.CMSRecipientInfo;
import th.co.oga.security.pki.CMS.CMSSignedAttributes;
import th.co.oga.security.pki.CMS.CMSSignedData;
import th.co.oga.security.pki.CMS.CMSSignerInfo;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.Certification.Extension.SubjectKeyIdentifier;
import th.co.oga.security.pki.OIDs;
import th.co.oga.security.pki.Packaging.RawAttributes;
import th.co.oga.security.pki.Packaging.RawCertIdentifier;
import th.co.oga.security.pki.Packaging.RawContentInfo;
import th.co.oga.security.pki.Packaging.RawDigestInfo;
import th.co.oga.security.pki.Packaging.RawEncryptedInfo;
import th.co.oga.security.pki.Packaging.RawEnvelopedData;
import th.co.oga.security.pki.Packaging.RawIssuerAndSerialNumber;
import th.co.oga.security.pki.Packaging.RawRecipientInfo;
import th.co.oga.security.pki.Packaging.RawSignedData;
import th.co.oga.security.pki.Packaging.RawSignerInfo;
import th.co.oga.security.pki.X500.DName;

public class CMSAdapter {
    private AlgorithmSupportTable algoTable;
    private AlgorithmSet digestAlgos;
    private AlgorithmSet signingAlgos;
    private AlgorithmSet dataEncryptAlgos;
    private AlgorithmSet keyWrapAlgos;

    public CMSAdapter(AlgorithmSupportTable aTable) {
        this.algoTable = aTable;
        this.digestAlgos = this.algoTable.getMessageDigestAlgorithm();
        this.signingAlgos = this.algoTable.getSignatureAlgorithm();
        this.dataEncryptAlgos = this.algoTable.getSymetricEncryptionAlgorithm();
        this.keyWrapAlgos = this.algoTable.getAsymetricEncryptionAlgorithm();
    }

    public static OBJECT_IDENTIFIER getObjID(String oid) {
        return new OBJECT_IDENTIFIER(oid);
    }

    public static String getOID(OBJECT_IDENTIFIER objID) {
        return OIDs.fromLongs(objID.getNumbers());
    }

    public static AlgorithmIdentifier getAlgoId(AlgorithmProfile alg, AlgorithmParameters params) throws InvalidBERException, IOException {
        return CMSAdapter.getAlgoId(alg, params.getEncoded());
    }

    public static AlgorithmIdentifier getAlgoId(AlgorithmProfile alg, byte[] params) throws InvalidBERException, IOException {
        ANY param = null;
        if (params != null) {
            param = new ANY(params);
        }
        return new AlgorithmIdentifier(new OBJECT_IDENTIFIER(alg.getOID()), (ASN1Value)param);
    }

    public static AlgorithmIdentifier getAlgoId(AlgorithmProfile alg) {
        return new AlgorithmIdentifier(new OBJECT_IDENTIFIER(alg.getOID()), null);
    }

    public static byte[] getAlgorithmParamerters(AlgorithmIdentifier algId) {
        if (algId.getParameters() == null) {
            return null;
        }
        ANY param = (ANY)algId.getParameters();
        return param.getEncoded();
    }

    public static String getOID(AlgorithmIdentifier algID) {
        return OIDs.fromLongs(algID.getOID().getNumbers());
    }

    public static ASN1Value getCertificate(byte[] cer) throws ASN1Exception {
        try {
            return ASN1Util.decode((ASN1Template)Certificate.getTemplate(), (byte[])cer);
        }
        catch (Exception e) {
            throw new ASN1Exception("ASN.1 Operation fail, " + e.getMessage());
        }
    }

    public static ASN1Value getCertificate(CertProfile cer) throws ASN1Exception, CertificateEncodingException {
        return CMSAdapter.getCertificate(cer.getX509Cert().getEncoded());
    }

    public static CMSIssuerAndSerialNumber getIssuerAndSerialNumber(RawIssuerAndSerialNumber iasn) throws ASN1Exception {
        DName issuer = iasn.getIssuer();
        INTEGER sn = new INTEGER(iasn.getSerialNumber());
        return new CMSIssuerAndSerialNumber(issuer, sn);
    }

    public static RawIssuerAndSerialNumber getIssuerAndSerialNumber(CMSIssuerAndSerialNumber iasn) throws ASN1Exception {
        return new RawIssuerAndSerialNumber(iasn.getIssuer().getX500Principal(), (BigInteger)iasn.getSerialNumber());
    }

    public static CMSCertIdentifier getCertIdentifier(RawCertIdentifier sid) throws ASN1Exception {
        if (sid.isType(RawCertIdentifier.ISSUER_AND_SERIALNUMBER)) {
            return CMSCertIdentifier.createInstance(CMSAdapter.getIssuerAndSerialNumber(sid.getIssuerAndSerialNumber()));
        }
        return CMSCertIdentifier.createSubjectKeyIdentifier(sid.getSubjectKeyIdentifier());
    }

    public static RawCertIdentifier getCertIdentifier(CMSCertIdentifier sid) throws ASN1Exception {
        if (sid.isType(CMSCertIdentifier.ISSUER_AND_SERIALNUMBER)) {
            return RawCertIdentifier.createInstance(CMSAdapter.getIssuerAndSerialNumber(sid.getIssuerAndSerialNumber()));
        }
        return RawCertIdentifier.createSubjectKeyIdentifier(sid.getSubjectKeyIdentifier().toByteArray());
    }

    public static CMSContentInfo getContentInfo(RawContentInfo contentInfo) throws ASN1Exception {
        try {
            return new CMSContentInfo(new OBJECT_IDENTIFIER(contentInfo.getContentType()), contentInfo.getContent());
        }
        catch (InvalidBERException e) {
            throw new ASN1Exception((Exception)((Object)e));
        }
    }

    public static RawContentInfo getContentInfo(CMSContentInfo contentInfo) {
        return new RawContentInfo(CMSAdapter.getOID(contentInfo.getContentType()), contentInfo.getByteContent());
    }

    public static RawContentInfo getEcontentInfo(CMSEncapsulatedContentInfo contentInfo) {
        return new RawContentInfo(CMSAdapter.getOID(contentInfo.getContentType().getObjectIdentifier()), contentInfo.getContent().toByteArray());
    }

    public static CMSEncapsulatedContentInfo getEcontentInfo(RawContentInfo contentInfo) {
        return new CMSEncapsulatedContentInfo(new CMSContentType(contentInfo.getContentType()), (ASN1Value)new OCTET_STRING(contentInfo.getContent()));
    }

    public CMSDigestInfo getDigestedInfo(RawDigestInfo digestInfo) {
        return new CMSDigestInfo(digestInfo.getAlgorithm(), digestInfo.getDigest());
    }

    public RawDigestInfo getDigestInfo(CMSDigestInfo digestInfo) throws AlgorithmSupportException {
        return new RawDigestInfo(digestInfo.getDigestData(), this.digestAlgos.findByOID(CMSAdapter.getOID(digestInfo.getDigestAlgorithm())));
    }

    public RawAttributes getAttributes(SET attrs) throws ASN1Exception {
        try {
            RawAttributes ra = null;
            if (attrs != null) {
                ra = new RawAttributes(ASN1Util.encode((ASN1Value)attrs));
                int a = 0;
                while (a < attrs.size()) {
                    Attribute attr = (Attribute)attrs.elementAt(a);
                    String oid = OIDs.fromLongs(attr.getType().getNumbers());
                    String text = CMSSignedAttributes.getText(attr);
                    ra.setProperty(oid, text);
                    ++a;
                }
            }
            return ra;
        }
        catch (InvalidBERException e) {
            throw new ASN1Exception(e.getMessage());
        }
    }

    public SET getAttributes(RawAttributes attrs) throws ASN1Exception {
        if (attrs != null) {
            SET.OF_Template reader = new SET.OF_Template((ASN1Template)Attribute.getTemplate());
            try {
                SET set = (SET)reader.decode((InputStream)new ByteArrayInputStream(attrs.getSrc()));
                return set;
            }
            catch (Exception e) {
                throw new ASN1Exception(e);
            }
        }
        return null;
    }

    public CMSSignerInfo getSignerInfo(RawSignerInfo signerInfo) throws AlgorithmSupportException, ASN1Exception {
        CertProfile cert = signerInfo.getSignerCertificate();
        byte[] signature = signerInfo.getSignature();
        AlgorithmProfile signAlg = signerInfo.getSignatureAlgorithm();
        AlgorithmProfile digestAlg = signerInfo.getDigestAlgorithm();
        CMSCertIdentifier sid = CMSCertIdentifier.createInstance(new CMSIssuerAndSerialNumber(cert.getX509Cert()));
        SET signedAttributes = this.getAttributes(signerInfo.getSignedAttributes());
        SET unsignedAttributes = this.getAttributes(signerInfo.getUnsignedAttributes());
        return new CMSSignerInfo(sid, CMSAdapter.getAlgoId(digestAlg), signedAttributes, CMSAdapter.getAlgoId(signAlg), signature, unsignedAttributes);
    }

    public RawSignerInfo getSignerInfo(CMSSignerInfo signerInfo, CertProfile signerCert) throws AlgorithmSupportException, ASN1Exception {
        AlgorithmProfile encAlg = this.keyWrapAlgos.findByOID(CMSAdapter.getOID(signerInfo.getSignatureAlgorithmIdentifier()));
        AlgorithmProfile dsgAlg = this.digestAlgos.findByOID(CMSAdapter.getOID(signerInfo.getDigestAlgorithmIdentifier()));
        byte[] signature = signerInfo.getEncryptedDigest();
        RawCertIdentifier sid = CMSAdapter.getCertIdentifier(signerInfo.getSignerIdentifier());
        RawAttributes sa = this.getAttributes(signerInfo.getSignedAttributes());
        RawAttributes ua = this.getAttributes(signerInfo.getUnsignedAttributes());
        return new RawSignerInfo(signerCert, sid, dsgAlg, sa, encAlg, signature, ua);
    }

    public static boolean isMatch(CMSCertIdentifier sid, CertProfile cer) {
        try {
            String skd2;
            if (sid.isType(CMSCertIdentifier.ISSUER_AND_SERIALNUMBER)) {
                CMSIssuerAndSerialNumber iasn = new CMSIssuerAndSerialNumber(cer.getX509Cert());
                return iasn.equals(sid.getIssuerAndSerialNumber());
            }
            SubjectKeyIdentifier skid = cer.getSubjectKeyIdentifier();
            String skd = new String(skid.getValue());
            return skd.compareTo(skd2 = new String(sid.getSubjectKeyIdentifier().toByteArray())) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public CMSSignedData getSignedData(RawSignedData signedData) throws ASN1Exception, CertificateEncodingException, AlgorithmSupportException {
        try {
            SET digestAlgs = new SET();
            Iterator dgs = signedData.getDigestAlgos();
            while (dgs.hasNext()) {
                digestAlgs.addElement((ASN1Value)CMSAdapter.getAlgoId((AlgorithmProfile)dgs.next()));
            }
            SET certs = new SET();
            SET signers = new SET();
            Iterator sgs = signedData.getSigners();
            while (sgs.hasNext()) {
                RawSignerInfo rs = (RawSignerInfo)sgs.next();
                certs.addElement(CMSAdapter.getCertificate(rs.getSignerCertificate()));
                signers.addElement((ASN1Value)this.getSignerInfo(rs));
            }
            CMSEncapsulatedContentInfo contentInfo = CMSAdapter.getEcontentInfo(signedData.getContentInfo());
            SET crls = new SET();
            byte[] bcrls = signedData.getCRLs();
            if (bcrls != null) {
                crls = (SET)ASN1Util.decode((ASN1Template)new SET.Template(), (byte[])bcrls);
            }
            CMSSignedData rtn = new CMSSignedData(digestAlgs, contentInfo, certs, crls, signers);
            rtn.setVersion(signedData.getVersion());
            return rtn;
        }
        catch (InvalidBERException e) {
            throw new ASN1Exception(e.getMessage());
        }
    }

    public RawSignedData getSignedData(CMSSignedData signedData) throws CertificateException, CertProfileException, IOException, ASN1Exception, AlgorithmSupportException {
        RawContentInfo content = CMSAdapter.getEcontentInfo(signedData.getContentInfo());
        SET cers = signedData.getCertificates();
        ArrayList<CertProfile> cs = new ArrayList<CertProfile>();
        if (cers != null) {
            int i = 0;
            while (i < cers.size()) {
                CertProfile cp = CertProfile.getInstance(ASN1Util.encode((ASN1Value)cers.elementAt(i)));
                cs.add(cp);
                ++i;
            }
        }
        SET signers = signedData.getSignerInfos();
        ArrayList<RawSignerInfo> signerList = new ArrayList<RawSignerInfo>();
        if (signers != null) {
            int i = 0;
            while (i < signers.size()) {
                CMSSignerInfo signer = (CMSSignerInfo)signers.elementAt(i);
                CMSCertIdentifier sid = signer.getSignerIdentifier();
                CertProfile cert = null;
                int c = 0;
                while (c < cs.size()) {
                    cert = (CertProfile)cs.get(c);
                    if (CMSAdapter.isMatch(sid, cert)) break;
                    ++c;
                }
                signerList.add(this.getSignerInfo(signer, cert));
                ++i;
            }
        }
        SET set = signedData.getCrls();
        byte[] crls = null;
        crls = set != null && set.size() > 0 ? ASN1Util.encode((ASN1Value)set) : (byte[])null;
        SET dAlgs = signedData.getDigestAlgorithmIdentifiers();
        ArrayList<AlgorithmProfile> algList = new ArrayList<AlgorithmProfile>();
        if (dAlgs != null) {
            int i = 0;
            while (i < dAlgs.size()) {
                algList.add(this.digestAlgos.findByOID(CMSAdapter.getOID((AlgorithmIdentifier)dAlgs.elementAt(i))));
                ++i;
            }
        }
        return new RawSignedData(signedData.getVersion().intValue(), algList, signerList, crls, content);
    }

    public CMSEncryptedContentInfo getEncryptedContentInfo(RawEncryptedInfo encInfo) throws ASN1Exception, IOException {
        try {
            OBJECT_IDENTIFIER contentType = CMSAdapter.getObjID(encInfo.getContentTypeOID());
            AlgorithmIdentifier encryptAlgorithm = CMSAdapter.getAlgoId(encInfo.getAlgorithm(), encInfo.getAlgorithmParameters());
            return new CMSEncryptedContentInfo(contentType, encryptAlgorithm, encInfo.getCipherText());
        }
        catch (InvalidBERException e) {
            throw new ASN1Exception(e.getMessage());
        }
    }

    public RawEncryptedInfo getEncryptedInfo(CMSEncryptedContentInfo encInfo) throws AlgorithmSupportException {
        byte[] params = encInfo.getAlgorithmParameters();
        byte[] cipherText = encInfo.getCipherText();
        AlgorithmProfile ap = this.dataEncryptAlgos.findByOID(CMSAdapter.getOID(encInfo.getContentEncryptionAlgorithm()));
        return new RawEncryptedInfo(cipherText, ap, params, CMSAdapter.getOID(encInfo.getContentType()));
    }

    public CMSRecipientInfo getRecipientInfo(RawRecipientInfo rcpInfo) throws ASN1Exception {
        CMSCertIdentifier rid = CMSAdapter.getCertIdentifier(rcpInfo.getCertIdentifier());
        AlgorithmIdentifier keyAlgID = CMSAdapter.getAlgoId(rcpInfo.getAlgorithm());
        byte[] encryptedKey = rcpInfo.getWrappedKey();
        return new CMSRecipientInfo(rid, keyAlgID, encryptedKey);
    }

    public RawRecipientInfo getRecipientInfo(CMSRecipientInfo rcpInfo) throws AlgorithmSupportException, ASN1Exception {
        byte[] wrappedKey = rcpInfo.getEncryptedKeyByte();
        AlgorithmProfile algo = this.keyWrapAlgos.findByOID(CMSAdapter.getOID(rcpInfo.getKeyEncryptionAlgorithmID()));
        return new RawRecipientInfo(wrappedKey, algo, CMSAdapter.getCertIdentifier(rcpInfo.getRecipientIdentifier()));
    }

    public CMSEnvelopedData getEnvelopedData(RawEnvelopedData envData) throws ASN1Exception, IOException {
        SET rcps = new SET();
        Iterator itr = envData.getRecipients();
        while (itr.hasNext()) {
            rcps.addElement((ASN1Value)this.getRecipientInfo((RawRecipientInfo)itr.next()));
        }
        CMSEncryptedContentInfo encInfo = this.getEncryptedContentInfo(envData.getEncryptedInfo());
        return new CMSEnvelopedData(rcps, encInfo);
    }

    public RawEnvelopedData getEnvelopedData(CMSEnvelopedData envData) throws AlgorithmSupportException, ASN1Exception {
        RawEnvelopedData renvData = new RawEnvelopedData(this.getEncryptedInfo(envData.getEncryptedContentInfo()));
        SET rcps = envData.getRecipientInfos();
        int i = 0;
        while (i < rcps.size()) {
            renvData.addRecipient(this.getRecipientInfo((CMSRecipientInfo)rcps.elementAt(i)));
            ++i;
        }
        return renvData;
    }
}

