/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Packaging;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Attribute;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.CMS.CMSCertIdentifier;
import th.co.oga.security.pki.CMS.CMSContentInfo;
import th.co.oga.security.pki.CMS.CMSEncapsulatedContentInfo;
import th.co.oga.security.pki.CMS.CMSEnvelopedData;
import th.co.oga.security.pki.CMS.CMSIssuerAndSerialNumber;
import th.co.oga.security.pki.CMS.CMSSignedAttributes;
import th.co.oga.security.pki.CMS.CMSSignedData;
import th.co.oga.security.pki.CMS.CMSSignerInfo;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Operation.CryptoOperatorException;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operation.SecureStoreFindingFailException;
import th.co.oga.security.pki.Packaging.CMSAdapter;
import th.co.oga.security.pki.Packaging.RawContentInfo;
import th.co.oga.security.pki.Packaging.RawEnvelopedData;
import th.co.oga.security.pki.Packaging.RawSignedData;
import th.co.oga.security.pki.Packaging.RawSignerInfo;
import th.co.oga.security.pki.Packaging.SecurePackageEncodingFailException;
import th.co.oga.security.pki.Packaging.SecurePackageInvalidDataException;
import th.co.oga.security.pki.Packaging.SecurePackageSigningFailException;
import th.co.oga.security.pki.Packaging.SecurePackageVerifyFailException;
import th.co.oga.security.pki.Packaging.SecurePackager;
import th.co.oga.security.pki.x.XSigningTime;
import th.co.oga.security.utils.Assert;

public class CMSPackager
extends SecurePackager {
    public CMSAdapter adapter;

    public CMSPackager(Room room) throws AlgorithmSupportException, EntryNotFoundException, SecureStoreException {
        super(room.getSecureOperator());
        this.applyPolicy(room);
        this.adapter = new CMSAdapter(room.getCryptoOperator().getSupportAlgorithm());
    }

    public byte[] decodeData(byte[] content) {
        return content;
    }

    public byte[] encodeData(byte[] data) {
        return data;
    }

    public RawSignedData signData(byte[] data) throws AlgorithmSupportException, SecureStoreFindingFailException, SecurePackageSigningFailException {
        RawSignedData signedData = new RawSignedData(new RawContentInfo(data));
        this.sign(signedData);
        return signedData;
    }

    public void sign(RawSignedData signedData, CertProfile signerCert) throws AlgorithmSupportException, SecureStoreFindingFailException, SecurePackageSigningFailException {
        try {
            Assert._assert(signedData != null, "Supplied SignedData  is null ");
            CMSEncapsulatedContentInfo toBeSignedContent = CMSAdapter.getEcontentInfo(signedData.getContentInfo());
            Assert._assert(toBeSignedContent != null, "Supplied SignedData  must be encape e-Content ");
            CertProfile sCert = signerCert == null ? this.getDefaultCertificate() : signerCert;
            byte[] toBeHash = toBeSignedContent.getContentType().getObjectIdentifier().equals((Object)CMSContentInfo.DATA) ? toBeSignedContent.getContent().toByteArray() : ASN1Util.encode((ASN1Value)toBeSignedContent);
            AlgorithmProfile sgnAlgo = this.cTaker.getSigningAlgo();
            AlgorithmProfile digestAlgo = this.macAlgoSet.findByName(sgnAlgo.getMessageDigestAlgorithmName());
            AlgorithmProfile encAlgo = this.keyWrappingAlgoSet.findByName(sgnAlgo.getEncryptionAlgorithmName());
            CMSIssuerAndSerialNumber issuerAndSerialNumber = new CMSIssuerAndSerialNumber(sCert.getX509Cert());
            CMSCertIdentifier signerID = CMSCertIdentifier.createInstance(issuerAndSerialNumber);
            int signerInfoVersion = 1;
            byte[] digest = this.oper.hashing(toBeHash, digestAlgo);
            CMSSignedAttributes signedAttrs = new CMSSignedAttributes();
            signedAttrs.addContentType(toBeSignedContent.getContentType().getObjectIdentifier());
            signedAttrs.addSigningTime();
            signedAttrs.addMessageDigest(digest);
            signedAttrs.addSMIMECapabilities();
            signedAttrs.addMSOEEncryptionKeyPreference(signerID);
            signedAttrs.addSMIMEEncryptionKeyReference(issuerAndSerialNumber);
            byte[] toBeSigned = ASN1Util.encode((ASN1Value)signedAttrs.getAttributes());
            byte[] signature = this.oper.getSignature(toBeSigned, sgnAlgo, sCert);
            CMSSignerInfo signer = new CMSSignerInfo(signerInfoVersion, signerID, digestAlgo, signedAttrs.getAttributes(), encAlgo, signature);
            RawSignerInfo rSigner = this.adapter.getSignerInfo(signer, sCert);
            signedData.addSigner(rSigner);
            signedData.addDigestAlgo(digestAlgo);
        }
        catch (SecureStoreException e) {
            throw new SecurePackageSigningFailException("CMSPackager", "Error while get signer's certificate, " + e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new SecurePackageSigningFailException("CMSPackager", "Error while build signer, " + e.getMessage());
        }
        catch (SignatureException e) {
            throw new SecurePackageSigningFailException("CMSPackager", "Error while sign data, " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurePackageSigningFailException("CMSPackager", "Error while hash operation, " + e.getMessage());
        }
        catch (ASN1Exception e) {
            throw new SecurePackageSigningFailException("CMSPackager", "Error while convert signeddata, " + e.getMessage());
        }
    }

    public void signatureVerify(RawSignedData signedData, CertProfile cert) throws SecurePackageVerifyFailException, SignatureException {
        try {
            byte[] tbv;
            byte[] data = signedData.getContentInfo().getContent();
            RawSignerInfo rSigner = signedData.getSignerInfo(cert);
            CMSSignerInfo signer = this.adapter.getSignerInfo(rSigner);
            AlgorithmProfile dsgAlg = this.macAlgoSet.findByOID(signer.getDigestAlgorithmIdentifier().getOID().getNumbers());
            AlgorithmProfile encAlg = this.keyWrappingAlgoSet.findByOID(signer.getSignatureAlgorithmIdentifier().getOID().getNumbers());
            AlgorithmProfile sgnAlg = this.signingAlgoSet.find(encAlg, dsgAlg);
            AlgorithmIdentifier dsgAlgID = CMSAdapter.getAlgoId(dsgAlg);
            SET signedAttributes = signer.getSignedAttributes();
            if (signedAttributes == null) {
                tbv = data;
            } else {
                tbv = ASN1Util.encode((ASN1Value)signedAttributes);
                String dataDigested = new String(this.oper.hashing(data, dsgAlg));
                String signedDigest = null;
                String signingTime = null;
                int a = 0;
                while (a < signedAttributes.size()) {
                    Object st;
                    Attribute attr = (Attribute)signedAttributes.elementAt(a);
                    ANY value = (ANY)attr.getValues().elementAt(0);
                    if (CMSSignedAttributes.MESSAGE_DIGEST_OID.equals((Object)attr.getType())) {
                        st = (OCTET_STRING)value.decodeWith((ASN1Template)OCTET_STRING.getTemplate());
                        signedDigest = new String(st.toByteArray());
                    }
                    if (CMSSignedAttributes.SIGNING_TIME_OID.equals((Object)attr.getType())) {
                        st = (XSigningTime)value.decodeWith((ASN1Template)XSigningTime.getTemplate());
                        signingTime = ((XSigningTime)st).getText();
                    }
                    ++a;
                }
                if (signingTime == null) {
                    throw new SignatureException("Signature have no signing time signed attributes for signer " + cert.getX509Cert().getSubjectDN().getName());
                }
                if (signedDigest == null) {
                    throw new SignatureException("Signature have no message digest signed attributes for signer  " + cert.getX509Cert().getSubjectDN().getName());
                }
                if (signedDigest.compareTo(dataDigested) != 0) {
                    throw new SignatureException("Data was altered,  signer is " + cert.getX509Cert().getSubjectDN().getName());
                }
            }
            if (!this.oper.signatureVerify(signer.getEncryptedDigest(), tbv, sgnAlg, cert)) {
                throw new SignatureException("Signature not valid ,  signer is " + cert.getX509Cert().getSubjectDN().getName());
            }
        }
        catch (InvalidBERException e) {
            throw new SecurePackageVerifyFailException("CMSPackager", "Error while verify signature, " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurePackageVerifyFailException("CMSPackager", "Error while verify signature, " + e.getMessage());
        }
        catch (AlgorithmSupportException e) {
            throw new SecurePackageVerifyFailException("CMSPackager", "Error while verify signature, " + e.getMessage());
        }
        catch (ASN1Exception e) {
            throw new SecurePackageVerifyFailException("CMSPackager", "Error while verify signature, " + e.getMessage());
        }
        catch (CryptoOperatorException e) {
            throw new SecurePackageVerifyFailException("CMSPackager", "Error while verify signature, " + e.getMessage());
        }
    }

    public RawSignedData importSignedData(InputStream in) throws SecurePackageEncodingFailException {
        try {
            CMSSignedData.Template reader = new CMSSignedData.Template();
            return this.adapter.getSignedData((CMSSignedData)reader.decode(new BufferedInputStream(in)));
        }
        catch (Exception e) {
            throw new SecurePackageEncodingFailException(e.getMessage());
        }
    }

    public RawSignedData importSignedData(byte[] bytes) throws SecurePackageEncodingFailException {
        ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
        return this.importSignedData(bi);
    }

    public void exportSignedData(RawSignedData signedData, OutputStream out) throws SecurePackageInvalidDataException {
        try {
            this.adapter.getSignedData(signedData).encode(out);
        }
        catch (Exception e) {
            throw new SecurePackageInvalidDataException(e.getMessage());
        }
    }

    public byte[] exportSignedData(RawSignedData signedData) throws SecurePackageInvalidDataException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        this.exportSignedData(signedData, bo);
        return bo.toByteArray();
    }

    public RawEnvelopedData importEnvelopedData(InputStream in) throws SecurePackageEncodingFailException {
        try {
            CMSEnvelopedData.Template reader = new CMSEnvelopedData.Template();
            return this.adapter.getEnvelopedData((CMSEnvelopedData)reader.decode(new BufferedInputStream(in)));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SecurePackageEncodingFailException(e.getMessage());
        }
    }

    public RawEnvelopedData importEnvelopedData(byte[] bytes) throws SecurePackageEncodingFailException {
        ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
        return this.importEnvelopedData(bi);
    }

    public void exportEnvelopedData(RawEnvelopedData envelopedData, OutputStream out) throws SecurePackageInvalidDataException {
        try {
            this.adapter.getEnvelopedData(envelopedData).encode(out);
        }
        catch (Exception e) {
            throw new SecurePackageInvalidDataException(e.getMessage());
        }
    }

    public byte[] exportEnvelopedData(RawEnvelopedData envelopedData) throws SecurePackageInvalidDataException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        this.exportEnvelopedData(envelopedData, bo);
        return bo.toByteArray();
    }

    public void getData(byte[] contentInfo, OutputStream out) throws SecurePackageInvalidDataException {
        try {
            out.write(this.decodeData(contentInfo));
        }
        catch (Exception e) {
            throw new SecurePackageInvalidDataException("P7SecurePackager", "ContentInfo", e.getMessage());
        }
    }

    public byte[] getData(byte[] contentInfo) throws SecurePackageInvalidDataException {
        return this.decodeData(contentInfo);
    }

    public void getData(RawSignedData signedData, OutputStream out) throws SecurePackageInvalidDataException {
        try {
            out.write(this.decodeData(signedData.getData()));
        }
        catch (Exception e) {
            throw new SecurePackageInvalidDataException("P7SecurePackager", "ContentInfo", e.getMessage());
        }
    }

    public byte[] getData(RawSignedData signedData) throws SecurePackageInvalidDataException {
        return this.decodeData(signedData.getData());
    }
}

