/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Packaging;

import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Properties;
import th.co.oga.security.pki.CMS.CMSAttributeName;

class RawAttributes
extends Properties {
    private byte[] src;

    public RawAttributes(byte[] src) {
        this.src = src;
    }

    public byte[] getSrc() {
        return this.src;
    }

    public static String getAttributeName(String oid) {
        if (oid.equalsIgnoreCase(CMSAttributeName.CONTENT_TYPE)) {
            return "Content type";
        }
        if (oid.equalsIgnoreCase(CMSAttributeName.MESSAGE_DIGEST)) {
            return "Message digest";
        }
        if (oid.equalsIgnoreCase(CMSAttributeName.MSOE_ENCRYPTION_KEY_REFERENCE)) {
            return "MSEO Encryption key reference";
        }
        if (oid.equalsIgnoreCase(CMSAttributeName.SIGNING_TIME)) {
            return "Signing time";
        }
        if (oid.equalsIgnoreCase(CMSAttributeName.SMIME_CAPABILITIES)) {
            return "Smime Capabilities";
        }
        if (oid.equalsIgnoreCase(CMSAttributeName.SMIME_ENCRYPTION_LEY_PREFERENCE)) {
            return "SMIME Encryption Key Reference";
        }
        return "";
    }

    public String getSigningTime() {
        return this.getProperty(CMSAttributeName.SIGNING_TIME);
    }

    public void getText(StringWriter sw) {
        Enumeration<?> names = this.propertyNames();
        while (names.hasMoreElements()) {
            String oid = (String)names.nextElement();
            String value = this.getProperty(oid);
            sw.write(String.valueOf(RawAttributes.getAttributeName(oid)) + "=" + value + "\n");
        }
    }
}

