/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Packaging;

import java.util.ArrayList;
import java.util.Iterator;
import javax.crypto.SecretKey;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Packaging.RawEncryptedInfo;
import th.co.oga.security.pki.Packaging.RawRecipientInfo;

public class RawEnvelopedData {
    private RawEncryptedInfo encryptedInfo = null;
    private ArrayList recipients = new ArrayList();
    private int version = 0;
    private SecretKey encryptionKey;

    public RawEnvelopedData() {
    }

    public RawEnvelopedData(RawEncryptedInfo encryptedData) {
        this();
        this.encryptedInfo = encryptedData;
    }

    public RawEncryptedInfo getEncryptedInfo() {
        return this.encryptedInfo;
    }

    public RawRecipientInfo getRecipientInfo(CertProfile cert) throws ASN1Exception {
        RawRecipientInfo recp = null;
        int i = 0;
        while (i < this.recipients.size()) {
            RawRecipientInfo rcp = (RawRecipientInfo)this.recipients.get(i);
            if (rcp.isCert(cert)) {
                recp = rcp;
                break;
            }
            ++i;
        }
        return recp;
    }

    public Iterator getRecipients() {
        return this.recipients.iterator();
    }

    public void setEncryptedInfo(RawEncryptedInfo encData) {
        this.encryptedInfo = encData;
    }

    public void addRecipient(RawRecipientInfo recp) {
        this.recipients.add(recp);
    }

    protected SecretKey getEncryptionKey() {
        return this.encryptionKey;
    }

    protected void setEncryptionKey(SecretKey encKey) {
        this.encryptionKey = encKey;
    }
}

