/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Packaging;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.X500.DName;

public class RawIssuerAndSerialNumber {
    private DName issuer;
    private BigInteger sn;

    public RawIssuerAndSerialNumber(CertProfile cer) throws ASN1Exception {
        this(cer.getX509Cert());
    }

    public RawIssuerAndSerialNumber(X509Certificate cer) throws ASN1Exception {
        this.issuer = DName.getInstance(cer.getIssuerX500Principal());
        this.sn = cer.getSerialNumber();
    }

    public RawIssuerAndSerialNumber(X500Principal issuer, BigInteger sn) throws ASN1Exception {
        this.issuer = DName.getInstance(issuer);
        this.sn = sn;
    }

    public DName getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNumber() {
        return this.sn;
    }

    public boolean isCert(CertProfile cer) throws ASN1Exception {
        RawIssuerAndSerialNumber iasn = new RawIssuerAndSerialNumber(cer);
        return this.issuer.equals(iasn.getIssuer()) && this.sn.compareTo(iasn.getSerialNumber()) == 0;
    }
}

