/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Packaging;

import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.Extension.SubjectKeyIdentifier;
import th.co.oga.security.pki.Packaging.RawCertIdentifier;
import th.co.oga.security.pki.Packaging.RawIssuerAndSerialNumber;

public class RawRecipientInfo {
    private int version = 0;
    private AlgorithmProfile wrappingAlgo;
    private RawCertIdentifier recipientID;
    private byte[] wrappedKey;

    public RawRecipientInfo() {
    }

    public RawRecipientInfo(byte[] wrappedEncryptionKey, AlgorithmProfile algo, CertProfile recp) throws ASN1Exception {
        this(wrappedEncryptionKey, algo, new RawIssuerAndSerialNumber(recp));
    }

    public RawRecipientInfo(byte[] wrappedEncryptionKey, AlgorithmProfile algo, RawIssuerAndSerialNumber iasn) throws ASN1Exception {
        this(0, wrappedEncryptionKey, algo, RawCertIdentifier.createInstance(iasn));
    }

    public RawRecipientInfo(int v, byte[] wrappedEncryptionKey, AlgorithmProfile algo, RawCertIdentifier recipientID) {
        this.version = v;
        this.wrappedKey = wrappedEncryptionKey;
        this.wrappingAlgo = algo;
        this.recipientID = recipientID;
    }

    public RawRecipientInfo(byte[] wrappedEncryptionKey, AlgorithmProfile algo, RawCertIdentifier recipientID) {
        this.wrappedKey = wrappedEncryptionKey;
        this.wrappingAlgo = algo;
        this.recipientID = recipientID;
        this.version = recipientID.isType(RawCertIdentifier.ISSUER_AND_SERIALNUMBER) ? 0 : 2;
    }

    public void setWrappedData(byte[] encryptedKeyData) {
        this.wrappedKey = encryptedKeyData;
    }

    public void setAlgorithm(AlgorithmProfile algo) {
        this.wrappingAlgo = algo;
    }

    public void setRecipientCert(CertProfile cert) throws ASN1Exception {
        this.recipientID = RawCertIdentifier.createInstance(new RawIssuerAndSerialNumber(cert));
    }

    public byte[] getWrappedKey() {
        return this.wrappedKey;
    }

    public RawCertIdentifier getCertIdentifier() {
        return this.recipientID;
    }

    public RawIssuerAndSerialNumber getIssuerAndSerialNumber() {
        if (this.recipientID.isType(RawCertIdentifier.ISSUER_AND_SERIALNUMBER)) {
            return this.recipientID.getIssuerAndSerialNumber();
        }
        return null;
    }

    public AlgorithmProfile getAlgorithm() {
        return this.wrappingAlgo;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isCert(CertProfile cer) throws ASN1Exception {
        String skd2;
        if (this.recipientID.isType(RawCertIdentifier.ISSUER_AND_SERIALNUMBER)) {
            return this.recipientID.getIssuerAndSerialNumber().isCert(cer);
        }
        SubjectKeyIdentifier skid = cer.getSubjectKeyIdentifier();
        String skd = new String(skid.getValue());
        return skd.compareTo(skd2 = new String(this.recipientID.getSubjectKeyIdentifier())) == 0;
    }
}

