/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Packaging;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operator.CryptoOperator;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.Packaging.RawDigestInfo;
import th.co.oga.security.pki.Packaging.RawEncryptedInfo;
import th.co.oga.security.pki.Packaging.RawEnvelopedData;
import th.co.oga.security.pki.Packaging.RawRecipientInfo;
import th.co.oga.security.pki.Packaging.RawSignedData;
import th.co.oga.security.pki.Packaging.RawSignerInfo;
import th.co.oga.security.pki.Packaging.SecurePackageEncodingFailException;
import th.co.oga.security.pki.Packaging.SecurePackageInvalidDataException;
import th.co.oga.security.pki.Packaging.SecurePackager;

public class RawSecurePackager
extends SecurePackager {
    public RawSecurePackager(SecureStoreOperator storeOperator, CryptoOperator cryptoOperator) {
        super(storeOperator, cryptoOperator);
    }

    public RawSecurePackager(Room room) throws AlgorithmSupportException, SecureStoreException {
        super(room.getSecureOperator());
    }

    public byte[] decodeData(byte[] data) {
        return data;
    }

    public byte[] encodeData(byte[] data) {
        return data;
    }

    public void exportEnvelopedData(RawEnvelopedData envelopedData, OutputStream out) throws SecurePackageInvalidDataException {
    }

    public byte[] exportEnvelopedData(RawEnvelopedData envelopedData) throws SecurePackageInvalidDataException {
        return null;
    }

    public void exportSignedData(RawSignedData signedData, OutputStream out) throws SecurePackageInvalidDataException {
    }

    public byte[] exportSignedData(RawSignedData signedData) throws SecurePackageInvalidDataException {
        return null;
    }

    public RawEnvelopedData importEnvelopedData(byte[] envelopedData) throws SecurePackageEncodingFailException {
        return null;
    }

    public RawEnvelopedData importEnvelopedData(InputStream in) throws SecurePackageEncodingFailException {
        return null;
    }

    public RawSignedData importSignedData(byte[] bytes) throws SecurePackageEncodingFailException {
        return null;
    }

    public RawSignedData importSignedData(InputStream in) throws SecurePackageEncodingFailException {
        return null;
    }

    public void getData(byte[] contentInfo, OutputStream out) throws SecurePackageInvalidDataException {
        try {
            out.write(contentInfo);
        }
        catch (IOException e) {
            throw new SecurePackageInvalidDataException("RawSecurePackager", " Raw Data ", e.getMessage());
        }
    }

    public byte[] getData(byte[] contentInfo) throws SecurePackageInvalidDataException {
        return contentInfo;
    }

    public void getData(RawSignedData signedData, OutputStream out) throws SecurePackageInvalidDataException {
        try {
            out.write(signedData.getData());
        }
        catch (IOException e) {
            throw new SecurePackageInvalidDataException("RawSecurePackager", " Raw Data ", e.getMessage());
        }
    }

    public byte[] getData(RawSignedData signedData) throws SecurePackageInvalidDataException {
        return signedData.getData();
    }

    public RawSignedData getSignedData(byte[] data, RawDigestInfo[] digests, RawSignerInfo[] signers) throws AlgorithmSupportException, IOException, CertificateException, CertProfileException {
        RawSignedData sd = new RawSignedData(data);
        int i = 0;
        while (i < digests.length) {
            sd.addDigestAlgo(digests[i].getAlgorithm());
            ++i;
        }
        i = 0;
        while (i < signers.length) {
            sd.addSigner(signers[i]);
            ++i;
        }
        return sd;
    }

    public RawSignedData getSignedData(byte[] data, byte[] digest, String digestAlgorithm, byte[] signature, String signatureAlgorithm, byte[] signerCertificate) throws AlgorithmSupportException, IOException, CertProfileException, CertificateException {
        AlgorithmProfile digestAlgo = this.macAlgoSet.findByName(digestAlgorithm);
        AlgorithmProfile signAlgo = this.signingAlgoSet.findByName(signatureAlgorithm);
        CertProfile signCert = CertProfile.getInstance(signerCertificate);
        RawSignedData sd = new RawSignedData(data);
        RawDigestInfo[] digests = new RawDigestInfo[]{new RawDigestInfo(digest, digestAlgo)};
        RawSignerInfo[] signers = new RawSignerInfo[]{new RawSignerInfo(signature, signAlgo, signCert)};
        return this.getSignedData(data, digests, signers);
    }

    public RawSignedData getSignedData(byte[] data, byte[] digest, byte[] signature, String signatureAlgorithm, byte[] signerCertificate) throws AlgorithmSupportException, IOException, CertProfileException, CertificateException {
        AlgorithmProfile signAlgo = this.signingAlgoSet.findByName(signatureAlgorithm);
        String digestAlgorithm = signAlgo.getMessageDigestAlgorithmName();
        return this.getSignedData(data, digest, digestAlgorithm, signature, signatureAlgorithm, signerCertificate);
    }

    public RawEncryptedInfo getEncryptedData(byte[] cipherText, String algoName, byte[] params) throws AlgorithmSupportException, NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        AlgorithmProfile encAlgo = this.dataEncryptionAlgoSet.findByName(algoName);
        RawEncryptedInfo encData = new RawEncryptedInfo();
        encData.setAlgorithm(encAlgo);
        if (params != null) {
            encData.setAlgorithmParameters(params);
        }
        encData.setCipherText(cipherText);
        return encData;
    }

    public RawEnvelopedData getEnvelopedData(byte[] cipherText, String encryptionAlgoName, byte[] encryptionParameters, byte[] wrappedKey, String wrappingAlgoName, byte[] recipientCert) throws AlgorithmSupportException, IOException, CertProfileException, CertificateException, ASN1Exception {
        CertProfile recpCert = CertProfile.getInstance(recipientCert);
        AlgorithmProfile wrappingAlgo = this.keyWrappingAlgoSet.findByName(wrappingAlgoName);
        RawRecipientInfo recipient = new RawRecipientInfo(wrappedKey, wrappingAlgo, recpCert);
        AlgorithmProfile encryptionAlgo = this.dataEncryptionAlgoSet.findByName(encryptionAlgoName);
        RawEncryptedInfo encryptedData = new RawEncryptedInfo(cipherText, encryptionAlgo, encryptionParameters);
        RawEnvelopedData envData = new RawEnvelopedData(encryptedData);
        envData.addRecipient(recipient);
        return envData;
    }
}

