/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Packaging;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Packaging.RawContentInfo;
import th.co.oga.security.pki.Packaging.RawSignerInfo;
import th.co.oga.security.pki.Packaging.SecurePackageVerifyFailException;

public class RawSignedData {
    private int version = 1;
    private List digestAlgos = new ArrayList();
    private List signers = new ArrayList();
    private byte[] crls;
    private RawContentInfo content;

    public RawSignedData() {
    }

    public RawSignedData(RawContentInfo content) {
        this();
        this.content = content;
    }

    public RawSignedData(int v, List digestAlgo, List signers, byte[] crls, RawContentInfo content) {
        this();
        this.version = v;
        this.digestAlgos = digestAlgo;
        this.signers = signers;
        this.crls = crls;
        this.content = content;
    }

    public RawSignedData(byte[] data) {
        this(new RawContentInfo(data));
    }

    public Iterator getDigestAlgos() {
        return this.digestAlgos.iterator();
    }

    public Iterator getSigners() {
        return this.signers.iterator();
    }

    public int getVersion() {
        return this.version;
    }

    public RawContentInfo getContentInfo() {
        return this.content;
    }

    public byte[] getCRLs() {
        return this.crls;
    }

    public byte[] getData() {
        return this.content.getContent();
    }

    public RawSignerInfo getSignerInfo(CertProfile signerCert) throws SecurePackageVerifyFailException {
        RawSignerInfo signer = null;
        int i = 0;
        while (i < this.signers.size()) {
            RawSignerInfo sgn = (RawSignerInfo)this.signers.get(i);
            if (sgn.isCert(signerCert)) {
                signer = sgn;
                break;
            }
            ++i;
        }
        if (signer == null) {
            throw new SecurePackageVerifyFailException("RawPackager", "Signer as the search certificate not found.");
        }
        return signer;
    }

    public void setVersion(int v) {
        this.version = v;
    }

    public void setData(byte[] data) {
        this.content = new RawContentInfo(data);
    }

    public void addDigestAlgo(AlgorithmProfile dgsAlg) {
        if (this.digestAlgos.indexOf(dgsAlg) == -1) {
            this.digestAlgos.add(dgsAlg);
        }
    }

    public void addSigner(RawSignerInfo signer) {
        this.signers.add(signer);
    }
}

