/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Packaging;

import com.sun.mail.util.BASE64EncoderStream;
import java.io.StringWriter;
import java.security.cert.X509Certificate;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Packaging.RawAttributes;
import th.co.oga.security.pki.Packaging.RawCertIdentifier;

public class RawSignerInfo {
    public static int V0 = 0;
    public static int V1 = 1;
    public static int V2 = 2;
    public static int V3 = 3;
    public static int V4 = 4;
    private int version = 1;
    private AlgorithmProfile signingAlgo;
    private AlgorithmProfile digestAlgo;
    private CertProfile signer;
    private RawCertIdentifier sid;
    private byte[] signature;
    private RawAttributes authenAttribute;
    private RawAttributes unauthenAttribute;

    public RawSignerInfo() {
    }

    public RawSignerInfo(byte[] signature, AlgorithmProfile algo, CertProfile signer) {
        this(signature, algo, signer, null, null);
    }

    public RawSignerInfo(byte[] signature, AlgorithmProfile algo, CertProfile signer, RawAttributes authenAttr, RawAttributes unAuthenAttr) {
        this.signature = signature;
        this.signingAlgo = algo;
        this.signer = signer;
        this.authenAttribute = authenAttr;
        this.unauthenAttribute = unAuthenAttr;
    }

    public RawSignerInfo(CertProfile signer, RawCertIdentifier sid, AlgorithmProfile digestAlgo, RawAttributes signedAttr, AlgorithmProfile encAlgo, byte[] signature) {
        this(signer, sid, digestAlgo, signedAttr, encAlgo, signature, null);
    }

    public RawSignerInfo(CertProfile signer, RawCertIdentifier sid, AlgorithmProfile digestAlgo, RawAttributes signedAttr, AlgorithmProfile sgnAlgo, byte[] signature, RawAttributes unsignedAttr) {
        this.signer = signer;
        this.sid = sid;
        this.digestAlgo = digestAlgo;
        this.authenAttribute = signedAttr;
        this.signingAlgo = sgnAlgo;
        this.signature = signature;
        this.unauthenAttribute = unsignedAttr;
    }

    public String getText() {
        StringWriter sw = new StringWriter();
        sw.write("Signer Info:\n");
        sw.write("Digest Algorithm=" + this.digestAlgo.getAlgorithmName() + "\n");
        sw.write("Digest Encryption Algorithm=" + this.signingAlgo.getEncryptionAlgorithmName() + "\n");
        sw.write("Signature=" + new String(BASE64EncoderStream.encode((byte[])this.signature)) + "\n");
        if (this.authenAttribute != null) {
            sw.write("Signed Attributes:\n");
            this.authenAttribute.getText(sw);
        }
        return sw.toString();
    }

    public void setAlgorithm(AlgorithmProfile algo) {
        this.signingAlgo = algo;
    }

    public void setSignerCertificate(CertProfile cert) {
        this.signer = cert;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public CertProfile getSignerCertificate() {
        return this.signer;
    }

    public AlgorithmProfile getAlgorithm() {
        return this.signingAlgo;
    }

    public AlgorithmProfile getSignatureAlgorithm() {
        return this.signingAlgo;
    }

    public AlgorithmProfile getDigestAlgorithm() {
        return this.digestAlgo;
    }

    public RawCertIdentifier getSignerIdentifier() {
        return this.sid;
    }

    public RawAttributes getSignedAttributes() {
        return this.authenAttribute;
    }

    public String getSigningTime() {
        if (this.authenAttribute != null) {
            String st = this.authenAttribute.getSigningTime();
            if (st == null) {
                return "";
            }
            return st;
        }
        return "";
    }

    public RawAttributes getUnsignedAttributes() {
        return this.unauthenAttribute;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getAuthenAttributes() {
        return this.authenAttribute.getSrc();
    }

    public byte[] getUnauthenAttributes() {
        return this.unauthenAttribute.getSrc();
    }

    public boolean isCert(CertProfile compCert) {
        X509Certificate org = this.signer.getX509Cert();
        X509Certificate comp = compCert.getX509Cert();
        return org.getIssuerDN().equals(comp.getIssuerDN()) && org.getSerialNumber().equals(comp.getSerialNumber());
    }
}

