/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Packaging;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.crypto.SecretKey;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertificateInvalidateException;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.CRLList;
import th.co.oga.security.pki.HouseKeeping.CryptoPolicyTaker;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.HouseKeeping.TrustedPolicyTaker;
import th.co.oga.security.pki.Operation.CertificateVerifyFailException;
import th.co.oga.security.pki.Operation.CryptoOperatorException;
import th.co.oga.security.pki.Operation.DataEncryptionFailException;
import th.co.oga.security.pki.Operation.KeyGenerateFailException;
import th.co.oga.security.pki.Operation.KeyWrappingFailException;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operation.SecureStoreFindingFailException;
import th.co.oga.security.pki.Operator.CryptoOperator;
import th.co.oga.security.pki.Operator.SecureOperator;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.Packaging.RawContentInfo;
import th.co.oga.security.pki.Packaging.RawDigestInfo;
import th.co.oga.security.pki.Packaging.RawEncryptedInfo;
import th.co.oga.security.pki.Packaging.RawEnvelopedData;
import th.co.oga.security.pki.Packaging.RawRecipientInfo;
import th.co.oga.security.pki.Packaging.RawSignedData;
import th.co.oga.security.pki.Packaging.RawSignerInfo;
import th.co.oga.security.pki.Packaging.SecurePackageCRLException;
import th.co.oga.security.pki.Packaging.SecurePackageEncipherException;
import th.co.oga.security.pki.Packaging.SecurePackageEncodingFailException;
import th.co.oga.security.pki.Packaging.SecurePackageEnvelopeException;
import th.co.oga.security.pki.Packaging.SecurePackageInvalidDataException;
import th.co.oga.security.pki.Packaging.SecurePackageOpenEnvelopeException;
import th.co.oga.security.pki.Packaging.SecurePackageSigningFailException;
import th.co.oga.security.pki.Packaging.SecurePackageVerifyFailException;
import th.co.oga.security.pki.Trusted.DestinationDefineFailException;
import th.co.oga.security.pki.x.CRL.CRLProfile;
import th.co.oga.security.pki.x.OCSP.OCSPOperator;
import th.co.oga.security.pki.x.OCSP.OCSPRequestFailException;
import th.co.oga.security.pki.x.PKIXTransportFailException;
import th.co.oga.security.pki.x.Timestamp.TimestampOperator;
import th.co.oga.security.pki.x.XSigningTime;

public abstract class SecurePackager {
    protected SecureStoreOperator sOper;
    protected CryptoOperator cOper;
    protected SecureOperator oper;
    protected CryptoPolicyTaker cTaker;
    protected TrustedPolicyTaker tTaker;
    protected OCSPOperator ocspOper;
    protected TimestampOperator tspOper;
    private CertProfile defaultCert;
    private Room room = null;
    private AlgorithmSupportTable algoTable;
    protected AlgorithmSet signingAlgoSet;
    protected AlgorithmSet dataEncryptionAlgoSet;
    protected AlgorithmSet keyWrappingAlgoSet;
    protected AlgorithmSet encipherAlgoSet;
    protected AlgorithmSet macAlgoSet;
    private CRLList crlList;
    private boolean policied = false;

    protected SecurePackager() {
    }

    public SecurePackager(SecureStoreOperator storeOperator, CryptoOperator cryptoOperator) {
        this.assignSecureOperator(new SecureOperator(this.sOper, this.cOper));
    }

    public SecurePackager(SecureOperator secureOperator) {
        this.assignSecureOperator(secureOperator);
    }

    public void assignSecureOperator(SecureOperator oper) {
        this.oper = oper;
        this.cOper = oper.getCryptoOperator();
        this.sOper = oper.getStoreOperator();
        this.initial();
    }

    private void initial() {
        this.algoTable = this.cOper.getSupportAlgorithm();
        this.signingAlgoSet = this.algoTable.getSignatureAlgorithm();
        this.dataEncryptionAlgoSet = this.algoTable.getSymetricEncryptionAlgorithm();
        this.keyWrappingAlgoSet = this.algoTable.getAsymetricEncryptionAlgorithm();
        this.encipherAlgoSet = this.algoTable.getEncryptionAlgorithm();
        this.macAlgoSet = this.algoTable.getMessageDigestAlgorithm();
    }

    public void traceInfo(String info) {
        if (this.room != null) {
            this.room.traceInfo(info);
        }
    }

    public AlgorithmProfile getSignatureAlgorithm(String algoName) throws AlgorithmSupportException {
        return this.signingAlgoSet.findByName(algoName);
    }

    public AlgorithmProfile getEncryptionAlgorithm(String algoName) throws AlgorithmSupportException {
        return this.dataEncryptionAlgoSet.findByName(algoName);
    }

    public AlgorithmProfile getKeyWrappingAlgorithm(String algoName) throws AlgorithmSupportException {
        return this.keyWrappingAlgoSet.findByName(algoName);
    }

    public void applyPolicy(Room room) throws AlgorithmSupportException, EntryNotFoundException {
        this.room = room;
        this.policied = true;
        this.cTaker = room.getCryptoPolicyTaker();
        this.tTaker = room.getTrustedPolicyTaker();
        this.crlList = room.getCRLList();
        this.ocspOper = new OCSPOperator(room);
        this.tspOper = new TimestampOperator(room);
    }

    public CertProfile getDefaultCertificate() throws SecureStoreException {
        if (this.defaultCert == null) {
            return this.room.getFirstCertificate();
        }
        return this.defaultCert;
    }

    public void setDefaultCertificate(CertProfile cert) {
        this.defaultCert = cert;
    }

    public abstract byte[] encodeData(byte[] var1);

    public abstract byte[] decodeData(byte[] var1);

    public RawDigestInfo hashing(byte[] data) throws AlgorithmSupportException, NoSuchAlgorithmException {
        AlgorithmProfile sgnAlgo = this.cTaker.getSigningAlgo();
        AlgorithmProfile digestAlgo = this.macAlgoSet.findByName(sgnAlgo.getMessageDigestAlgorithmName());
        byte[] digest = this.oper.hashing(data, digestAlgo);
        RawDigestInfo digestedData = new RawDigestInfo();
        digestedData.setAlgorithm(digestAlgo);
        digestedData.setDigest(digest);
        return digestedData;
    }

    public RawSignedData signData(byte[] data) throws AlgorithmSupportException, SecureStoreFindingFailException, SecurePackageSigningFailException {
        RawSignedData signedData = new RawSignedData(new RawContentInfo(data));
        this.sign(signedData);
        return signedData;
    }

    public void sign(RawSignedData signedData) throws AlgorithmSupportException, SecureStoreFindingFailException, SecurePackageSigningFailException {
        this.sign(signedData, null);
    }

    public void sign(RawSignedData signedData, CertProfile signerCert) throws AlgorithmSupportException, SecureStoreFindingFailException, SecurePackageSigningFailException {
        try {
            CertProfile sCert = null;
            sCert = signerCert == null ? this.getDefaultCertificate() : signerCert;
            RawDigestInfo digestedData = this.hashing(signedData.getData());
            RawSignerInfo signer = new RawSignerInfo();
            signer.setAlgorithm(this.cTaker.getSigningAlgo());
            signer.setSignerCertificate(sCert);
            signer.setSignature(this.oper.getSignature(digestedData.getDigest(), this.cTaker.getSigningAlgo(), sCert));
            signedData.addDigestAlgo(digestedData.getAlgorithm());
            signedData.addSigner(signer);
        }
        catch (SecureStoreException e) {
            throw new SecurePackageSigningFailException("RawPackager", "Error while get default certificate, " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurePackageSigningFailException("RawPackager", "Error while hash operation, " + e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new SecurePackageSigningFailException("RawPackager", "Error while build signer, " + e.getMessage());
        }
        catch (SignatureException e) {
            throw new SecurePackageSigningFailException("RawPackager", "Error while sign data, " + e.getMessage());
        }
    }

    public void signerVerify(RawSignedData signedData, CertProfile cert) throws SecurePackageVerifyFailException, SecurePackageCRLException, SignatureException {
        RawSignerInfo signer = signedData.getSignerInfo(cert);
        try {
            this.signatureVerify(signedData, cert);
            String signingTime = signer.getSigningTime();
            Calendar cal = Calendar.getInstance();
            if (signingTime != null) {
                try {
                    Date d = XSigningTime.DATE_FORMAT.parse(signingTime);
                    cal.setTime(d);
                }
                catch (ParseException e) {
                    this.traceInfo("Warning ! CMS signing time can not be parsed, as value " + signingTime + ". the supported pattern must be " + XSigningTime.DATE_FORMAT.toString());
                }
            } else {
                this.certificateVerify(signer.getSignerCertificate(), null);
            }
        }
        catch (CertificateVerifyFailException e) {
            throw new SignatureException("Signature not verify, " + e.getMessage());
        }
    }

    public void certificateVerify(X509Certificate xcert, Calendar signingTime) throws SecurePackageVerifyFailException, SecurePackageCRLException, CertificateVerifyFailException {
        this.certificateVerify(new CertProfile(xcert), signingTime);
    }

    public void certificateVerify(CertProfile cert, Calendar signingTime) throws SecurePackageVerifyFailException, SecurePackageCRLException, CertificateVerifyFailException {
        try {
            try {
                if (signingTime == null) {
                    this.oper.certificateVerify(cert);
                } else {
                    this.traceInfo("SecurePackager Check validity of Certificate with signing time " + XSigningTime.DATE_FORMAT.format(signingTime.getTime()) + " and certificate validate on [" + XSigningTime.DATE_FORMAT.format(cert.getIssueDate()) + " - " + XSigningTime.DATE_FORMAT.format(cert.getExpireDate()) + "]");
                    this.oper.certificateVerify(cert, signingTime);
                }
            }
            catch (CertificateInvalidateException e) {
                throw new CertificateVerifyFailException("Certificate is invalidate , " + e.getMessage());
            }
            if (this.policied) {
                if (this.tTaker.isOCSPEnable()) {
                    this.traceInfo("SecurePackager do the OCSP  ");
                    this.ocspOper.verify(cert);
                } else if (this.tTaker.isCRLEnable()) {
                    this.traceInfo("SecurePackager verify certificate with CRL  ");
                    CRLProfile crl = this.crlList.getProfile(CRLProfile.getCRLIssuerName(cert));
                    if (crl == null) {
                        throw new SecurePackageCRLException("SecurePackager", "Error while online verify, CRL is not avariable on system");
                    }
                    X509CRLEntry revokedCert = crl.getRevokedCert(cert);
                    if (revokedCert != null) {
                        throw new CertificateVerifyFailException("Signature not verify,Signer's certificate was revoked, " + revokedCert.toString());
                    }
                }
            }
        }
        catch (DestinationDefineFailException e) {
            throw new SecurePackageVerifyFailException("SecurePackager", "Error while online verify, " + e.getMessage());
        }
        catch (PKIXTransportFailException e) {
            throw new SecurePackageVerifyFailException("SecurePackager", "Error while online verify, " + e.getMessage());
        }
        catch (OCSPRequestFailException e) {
            throw new SecurePackageVerifyFailException("SecurePackager", "Error while online verify, " + e.getMessage());
        }
        catch (ASN1Exception e) {
            throw new SecurePackageVerifyFailException("SecurePackager", "Error while online verify, " + e.getMessage());
        }
        catch (IOException e) {
            throw new SecurePackageVerifyFailException("SecurePackager", "Error while verify certificate, IO Error, " + e.toString());
        }
        catch (CertificateException e) {
            throw new SecurePackageVerifyFailException("SecurePackager", "Error while verify certificate, " + e.getMessage());
        }
    }

    public void signatureVerify(RawSignedData signedData, CertProfile cert) throws SecurePackageVerifyFailException, SignatureException {
        RawSignerInfo signer = signedData.getSignerInfo(cert);
        try {
            AlgorithmProfile digestAlgo = this.macAlgoSet.findByName(signer.getAlgorithm().getMessageDigestAlgorithmName());
            MessageDigest md = this.cOper.getMessageDigest(digestAlgo);
            RawDigestInfo digestedData = new RawDigestInfo(md.digest(signedData.getData()), digestAlgo);
            if (!this.oper.signatureVerify(signer.getSignature(), digestedData.getDigest(), signer.getAlgorithm(), signer.getSignerCertificate())) {
                throw new SignatureException("Signature not valid , " + signer.getSignerCertificate().getX509Cert().getSubjectDN().getName());
            }
        }
        catch (AlgorithmSupportException e) {
            throw new SecurePackageVerifyFailException("SecurePackager", "Error while verify signature, " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurePackageVerifyFailException("SecurePackager", "Error while verify signature, " + e.getMessage());
        }
        catch (CryptoOperatorException e) {
            throw new SecurePackageVerifyFailException("SecurePackager", "Error while verify signature, " + e.getMessage());
        }
    }

    public abstract RawSignedData importSignedData(InputStream var1) throws SecurePackageEncodingFailException;

    public abstract RawSignedData importSignedData(byte[] var1) throws SecurePackageEncodingFailException;

    public abstract void exportSignedData(RawSignedData var1, OutputStream var2) throws SecurePackageInvalidDataException;

    public abstract byte[] exportSignedData(RawSignedData var1) throws SecurePackageInvalidDataException;

    public abstract byte[] getData(RawSignedData var1) throws SecurePackageInvalidDataException;

    public abstract void getData(RawSignedData var1, OutputStream var2) throws SecurePackageInvalidDataException;

    public RawEncryptedInfo encryptData(byte[] data, SecretKey encryptionKey) throws SecurePackageEncipherException {
        try {
            String requiredParamAlgos = this.cOper.getCipherParamSupportAlgos();
            AlgorithmParameterSpec param = null;
            if (requiredParamAlgos.indexOf(this.cTaker.getEncryptionAlgo().getEncryptionName()) > -1) {
                param = this.oper.getAlgorithmParameterSpec(this.cTaker.getEncryptionAlgo());
            }
            byte[] cipherText = this.oper.encryptData(data, this.cTaker.getEncryptionAlgo(), encryptionKey, param);
            AlgorithmParameters params = null;
            if (param != null) {
                params = this.oper.getAlgorithmParameters(this.cTaker.getEncryptionAlgo(), param);
            }
            RawEncryptedInfo encryptedData = new RawEncryptedInfo();
            encryptedData.setAlgorithm(this.cTaker.getEncryptionAlgo());
            if (params != null) {
                encryptedData.setAlgorithmParameters(params.getEncoded());
            }
            encryptedData.setCipherText(cipherText);
            return encryptedData;
        }
        catch (IOException e) {
            throw new SecurePackageEncipherException("RawPackager", "Error while generate encryption algorithm parameter, " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurePackageEncipherException("RawPackager", "Error while generate encryption algorithm parameter, " + e.getMessage());
        }
        catch (AlgorithmSupportException e) {
            throw new SecurePackageEncipherException("RawPackager", "Error while generate encryption algorithm parameter, " + e.getMessage());
        }
        catch (DataEncryptionFailException e) {
            throw new SecurePackageEncipherException("RawPackager", "Error while initial cipher, " + e.getMessage());
        }
        catch (InvalidParameterSpecException e) {
            throw new SecurePackageEncipherException("RawPackager", "Error while initial cipher, " + e.getMessage());
        }
    }

    public byte[] decryptData(RawEncryptedInfo encryptedData, SecretKey encryptionKey) throws DataEncryptionFailException {
        AlgorithmProfile encAlg = encryptedData.getAlgorithm();
        byte[] cipherText = encryptedData.getCipherText();
        try {
            AlgorithmParameters params = this.oper.getAlgorithmParameters(encAlg, encryptedData.getAlgorithmParameters());
            return this.oper.decryptData(cipherText, encAlg, encryptionKey, params);
        }
        catch (IOException e) {
            throw new DataEncryptionFailException("SecurePackager", "Error while generate algorithm parameters, IOException ");
        }
        catch (NoSuchAlgorithmException e) {
            throw new DataEncryptionFailException("SecurePackager", "Error while generate algorithm parameters, " + e.getMessage());
        }
    }

    public RawRecipientInfo wrapKey(SecretKey encryptionKey, CertProfile cer) throws SecurePackageEnvelopeException {
        try {
            AlgorithmProfile encAlgo = this.oper.getAsymetricEncryptionAlgorithmByName(cer.getPublicKey().getAlgorithm());
            byte[] wrappedKey = this.oper.wrapKey(encryptionKey, cer);
            RawRecipientInfo rcp = new RawRecipientInfo();
            rcp.setAlgorithm(encAlgo);
            rcp.setRecipientCert(cer);
            rcp.setWrappedData(wrappedKey);
            return rcp;
        }
        catch (ASN1Exception e) {
            throw new SecurePackageEnvelopeException("RawPackager", e.toString());
        }
        catch (SecurityException e) {
            throw new SecurePackageEnvelopeException("RawPackager", e.toString());
        }
        catch (KeyWrappingFailException e) {
            throw new SecurePackageEnvelopeException("RawPackager", e.getMessage());
        }
        catch (AlgorithmSupportException e) {
            throw new SecurePackageEnvelopeException("RawPackager", "Recipient info fail, " + e.getMessage());
        }
    }

    public RawEnvelopedData envelopeData(byte[] data) throws SecurePackageEnvelopeException, SecurePackageEncipherException {
        try {
            SecretKey encryptionKey = this.cOper.genSecretKey(this.cTaker.getEncryptionAlgo(), null);
            RawEncryptedInfo encryptedData = this.encryptData(this.encodeData(data), encryptionKey);
            RawEnvelopedData envData = new RawEnvelopedData();
            envData.setEncryptedInfo(encryptedData);
            envData.setEncryptionKey(encryptionKey);
            return envData;
        }
        catch (KeyGenerateFailException e) {
            throw new SecurePackageEnvelopeException("RawPackager", "Error while generate key," + e.getMessage());
        }
    }

    public void addRecipient(RawEnvelopedData envData, CertProfile cert) throws SecurePackageEnvelopeException {
        envData.addRecipient(this.wrapKey(envData.getEncryptionKey(), cert));
    }

    public RawEnvelopedData envelopeData(byte[] data, CertProfile recipient) throws SecurePackageEnvelopeException, SecurePackageEncipherException {
        RawEnvelopedData envData = this.envelopeData(data);
        this.addRecipient(envData, recipient);
        return envData;
    }

    public byte[] openEnvelopedData(RawEnvelopedData enveloped) throws SecurePackageOpenEnvelopeException, SecurePackageEncipherException, ASN1Exception {
        try {
            CertProfile defaultCertificate = this.getDefaultCertificate();
            RawRecipientInfo recipient = enveloped.getRecipientInfo(defaultCertificate);
            if (recipient == null) {
                throw new SecurePackageOpenEnvelopeException("SecurePackager", "Recipient info not found for " + defaultCertificate.getX509Cert().getSubjectDN().getName());
            }
            RawEncryptedInfo encryptedData = enveloped.getEncryptedInfo();
            SecretKey key = this.oper.unwrapKey(recipient.getWrappedKey(), encryptedData.getAlgorithm(), defaultCertificate);
            return this.decryptData(encryptedData, key);
        }
        catch (SecureStoreException e) {
            throw new SecurePackageEncipherException("SecurePackager", e.getMessage());
        }
        catch (KeyWrappingFailException e) {
            throw new SecurePackageEncipherException("SecurePackager", e.getMessage());
        }
        catch (DataEncryptionFailException e) {
            throw new SecurePackageEncipherException("SecurePackager", e.getMessage());
        }
    }

    public abstract RawEnvelopedData importEnvelopedData(InputStream var1) throws SecurePackageEncodingFailException;

    public abstract RawEnvelopedData importEnvelopedData(byte[] var1) throws SecurePackageEncodingFailException;

    public abstract void exportEnvelopedData(RawEnvelopedData var1, OutputStream var2) throws SecurePackageInvalidDataException;

    public abstract byte[] exportEnvelopedData(RawEnvelopedData var1) throws SecurePackageInvalidDataException;

    public abstract void getData(byte[] var1, OutputStream var2) throws SecurePackageInvalidDataException;

    public abstract byte[] getData(byte[] var1) throws SecurePackageInvalidDataException;
}

