/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Packaging;

import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.CRLList;
import th.co.oga.security.pki.HouseKeeping.CryptoPolicyTaker;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.HouseKeeping.TrustedPolicyTaker;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operator.CryptoOperator;
import th.co.oga.security.pki.Operator.SecureOperator;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.x.OCSP.OCSPOperator;
import th.co.oga.security.pki.x.Timestamp.TimestampOperator;

public abstract class SecureTaker {
    protected SecureStoreOperator sOper;
    protected CryptoOperator cOper;
    protected SecureOperator oper;
    protected CryptoPolicyTaker cTaker;
    protected TrustedPolicyTaker tTaker;
    protected OCSPOperator ocspOper;
    protected TimestampOperator tspOper;
    protected AlgorithmSupportTable algoTable;
    protected AlgorithmSet signingAlgoSet;
    protected AlgorithmSet dataEncryptionAlgoSet;
    protected AlgorithmSet keyWrappingAlgoSet;
    protected AlgorithmSet encipherAlgoSet;
    protected AlgorithmSet macAlgoSet;
    protected CertProfile defaultCertificate;
    protected CRLList crlList;
    private boolean policied = false;

    protected SecureTaker() {
    }

    public SecureTaker(SecureStoreOperator storeOperator, CryptoOperator cryptoOperator) {
        this.assignSecureOperator(new SecureOperator(this.sOper, this.cOper));
    }

    public SecureTaker(SecureOperator secureOperator) {
        this.assignSecureOperator(secureOperator);
    }

    public void assignSecureOperator(SecureOperator oper) {
        this.oper = oper;
        this.cOper = oper.getCryptoOperator();
        this.sOper = oper.getStoreOperator();
        this.initial();
    }

    private void initial() {
        this.algoTable = this.cOper.getSupportAlgorithm();
        this.signingAlgoSet = this.algoTable.getSignatureAlgorithm();
        this.dataEncryptionAlgoSet = this.algoTable.getSymetricEncryptionAlgorithm();
        this.keyWrappingAlgoSet = this.algoTable.getAsymetricEncryptionAlgorithm();
        this.encipherAlgoSet = this.algoTable.getEncryptionAlgorithm();
        this.macAlgoSet = this.algoTable.getMessageDigestAlgorithm();
    }

    public AlgorithmProfile getSignatureAlgorithm(String algoName) throws AlgorithmSupportException {
        return this.signingAlgoSet.findByName(algoName);
    }

    public AlgorithmProfile getEncryptionAlgorithm(String algoName) throws AlgorithmSupportException {
        return this.dataEncryptionAlgoSet.findByName(algoName);
    }

    public AlgorithmProfile getKeyWrappingAlgorithm(String algoName) throws AlgorithmSupportException {
        return this.keyWrappingAlgoSet.findByName(algoName);
    }

    public void applyPolicy(Room room) throws AlgorithmSupportException, SecureStoreException, EntryNotFoundException {
        this.policied = true;
        this.cTaker = room.getCryptoPolicyTaker();
        this.tTaker = room.getTrustedPolicyTaker();
        this.defaultCertificate = room.getFirstCertificate();
        this.crlList = room.getCRLList();
        this.ocspOper = new OCSPOperator(room);
        this.tspOper = new TimestampOperator(room);
    }

    public void setDefaultCertificate(CertProfile selectedCertificate) {
        this.defaultCertificate = selectedCertificate;
    }

    public CertProfile getDefaultCertificate() {
        return this.defaultCertificate;
    }
}

