/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Packaging;

import java.security.KeyException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Packaging.X509KeySelectorResult;

public class X509KeySelector
extends KeySelector {
    public KeySelectorResult select(KeyInfo ki, KeySelector.Purpose purpose, AlgorithmMethod algoMethod, XMLCryptoContext cryptoContext) throws KeySelectorException {
        if (ki == null) {
            throw new KeySelectorException("KeyInfo is null ");
        }
        SignatureMethod sm = (SignatureMethod)algoMethod;
        X509Certificate xCert = this.getSignerCertificate(ki, cryptoContext);
        if (this.algEquals(sm.getAlgorithm(), xCert.getPublicKey().getAlgorithm())) {
            return new X509KeySelectorResult(xCert.getPublicKey());
        }
        throw new KeySelectorException("Signature method and key algorithm not compatible.");
    }

    public X509Certificate getSignerCertificate(KeyInfo ki, XMLCryptoContext cryptoContext) throws KeySelectorException {
        XMLStructure obj;
        PublicKey signerKey = null;
        Certificate signerCert = null;
        List<XMLStructure> list = ki.getContent();
        int i = 0;
        while (i < list.size()) {
            obj = list.get(i);
            if (obj instanceof KeyValue) {
                try {
                    signerKey = ((KeyValue)obj).getPublicKey();
                }
                catch (KeyException e) {
                    throw new KeySelectorException(e);
                }
            }
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            obj = list.get(i);
            if (obj instanceof X509Data) {
                X509Data data = (X509Data)obj;
                List<?> dataList = data.getContent();
                int d = 0;
                while (d < dataList.size()) {
                    Object dataObj = dataList.get(d);
                    if (dataObj instanceof X509Certificate) {
                        X509Certificate xCert = (X509Certificate)dataObj;
                        try {
                            if (signerKey == null) {
                                if (dataList.size() > 1) {
                                    CertProfile cp = new CertProfile(xCert);
                                    if (!cp.isCA()) {
                                        signerCert = xCert;
                                    }
                                } else {
                                    signerCert = xCert;
                                }
                            } else {
                                String p2;
                                String p1 = new String(signerKey.getEncoded());
                                if (p1.equals(p2 = new String(xCert.getPublicKey().getEncoded()))) {
                                    signerCert = xCert;
                                    break;
                                }
                            }
                        }
                        catch (ASN1Exception e) {
                            throw new KeySelectorException(e);
                        }
                    }
                    ++d;
                }
            }
            ++i;
        }
        if (signerCert != null) {
            signerKey = signerCert.getPublicKey();
            return signerCert;
        }
        if (list.size() > 0) {
            throw new KeySelectorException("Do not found any signer's certificate , X509Certificate not supply or not compatible with signature.");
        }
        throw new KeySelectorException("No any signers key element associated with signature.");
    }

    public boolean algEquals(String algURI, String algName) {
        if (algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return true;
        }
        return algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
    }
}

