/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.SMIME;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.OIDs;

public class SMIMECapability
implements ASN1Value {
    private OBJECT_IDENTIFIER algoId;
    private INTEGER size;
    public static final Tag TAG = SEQUENCE.TAG;

    private SMIMECapability() {
    }

    public SMIMECapability(AlgorithmProfile algo) throws IOException {
        this(new OBJECT_IDENTIFIER(algo.getOID()), null);
    }

    public SMIMECapability(String algo) {
        this(new OBJECT_IDENTIFIER(algo), null);
    }

    public SMIMECapability(String algo, int size) {
        this(new OBJECT_IDENTIFIER(algo), new INTEGER((long)size));
    }

    public SMIMECapability(AlgorithmProfile algo, int size) throws IOException {
        this(new OBJECT_IDENTIFIER(algo.getOID()), new INTEGER((long)size));
    }

    SMIMECapability(OBJECT_IDENTIFIER algoId, INTEGER size) {
        this.algoId = algoId;
        this.size = size;
    }

    public String getAlgoOID() {
        return OIDs.fromLongs(this.algoId.getNumbers());
    }

    public Integer getSize() {
        if (this.size == null) {
            return null;
        }
        return new Integer(this.size.intValue());
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.algoId);
        if (this.size != null) {
            seq.addElement((ASN1Value)this.size);
        }
        seq.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt = SEQUENCE.getTemplate();

        public Template() {
            this.seqt.addElement((ASN1Template)OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addOptionalElement(INTEGER.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            INTEGER size = null;
            if (seq.elementAt(1) != null) {
                size = (INTEGER)seq.elementAt(1);
            }
            return new SMIMECapability((OBJECT_IDENTIFIER)seq.elementAt(0), size);
        }
    }
}

