/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.SMIME;

import javax.mail.internet.ContentType;
import javax.mail.internet.ParameterList;
import javax.mail.internet.ParseException;
import th.co.oga.security.pki.SMIME.SMIMESPEC;

public class SMIMEContentType
extends ContentType
implements SMIMESPEC {
    public static int MULTIPART_SIGNED_MESSAGE = 0;
    public static int PKCS7_SMIME_SIGNED_DATA_MESSAGE = 1;
    public static int PKCS7_SMIME_ENVELOPED_DATA_MESSAGE = 2;
    public static int P7S_PART = 3;
    private int partType = -1;

    public SMIMEContentType(String arg0) throws ParseException {
        super(arg0);
        String contentType = this.getBaseType();
        if (CONTENT_TYPE_MULTIPART_SIGN.is(contentType)) {
            this.partType = MULTIPART_SIGNED_MESSAGE;
        } else if (CONTENT_TYPE_PKCS7_SIGNATURE.is(contentType)) {
            this.partType = P7S_PART;
        } else if (CONTENT_TYPE_PKCS7_NS_SIGNATURE.is(contentType)) {
            this.partType = P7S_PART;
        } else if (CONTENT_TYPE_PKCS7_MIME.is(contentType)) {
            String smimeType = this.getParameter("smime-type");
            if (smimeType.equalsIgnoreCase("signed-data")) {
                this.partType = PKCS7_SMIME_SIGNED_DATA_MESSAGE;
            } else if (smimeType.equalsIgnoreCase("enveloped-data")) {
                this.partType = PKCS7_SMIME_ENVELOPED_DATA_MESSAGE;
            }
        }
    }

    public String getFullSubType() {
        ParameterList pl = this.getParameterList();
        return String.valueOf(this.getSubType()) + this.getParameterList().toString();
    }

    SMIMEContentType(int msgType, String baseType) throws ParseException {
        super(baseType);
        this.partType = msgType;
    }

    public String getDigestAlgorithm() {
        return this.getParameter("micalg");
    }

    public static SMIMEContentType createMultipartSignContentType(String digestAlgo) throws ParseException {
        SMIMEContentType cType = new SMIMEContentType(MULTIPART_SIGNED_MESSAGE, MULTIPART_SIGN_CONTENT_TYPE_VALUE);
        cType.setParameter("protocol", "application/pkcs7-signature");
        cType.setParameter("micalg", digestAlgo);
        return cType;
    }

    public static SMIMEContentType createP7SContentType() throws ParseException {
        SMIMEContentType cType = new SMIMEContentType(P7S_PART, P7S_CONTENT_TYPE_VALUE);
        cType.setParameter("name", "smime.p7s");
        return cType;
    }

    public static SMIMEContentType createP7MSignedDataContentType() throws ParseException {
        SMIMEContentType cType = new SMIMEContentType(PKCS7_SMIME_SIGNED_DATA_MESSAGE, P7MIME_CONTENT_TYPE_VALUE);
        cType.setParameter("smime-type", "signed-data");
        cType.setParameter("name", "smime.p7m");
        return cType;
    }

    public static SMIMEContentType createP7MEnvelopedDataContentType() throws ParseException {
        SMIMEContentType cType = new SMIMEContentType(PKCS7_SMIME_ENVELOPED_DATA_MESSAGE, P7MIME_CONTENT_TYPE_VALUE);
        cType.setParameter("smime-type", "enveloped-data");
        cType.setParameter("name", "smime.p7m");
        return cType;
    }

    protected int getPartType() {
        return this.partType;
    }

    public boolean is(int partType) {
        return this.partType == partType;
    }

    public static boolean isInLength(SMIMEContentType contentType) {
        return contentType.getPartType() > -1 && contentType.getPartType() < 4;
    }

    public static boolean isInSigningLength(SMIMEContentType contentType) {
        return contentType.getPartType() == 0 || contentType.getPartType() == 1 || contentType.getPartType() == 3;
    }
}

