/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.SMIME;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.CMS.CMSContentInfo;
import th.co.oga.security.pki.CMS.CMSOperator;
import th.co.oga.security.pki.CMS.CMSSecurePackagerException;
import th.co.oga.security.pki.CMS.CMSSignedData;
import th.co.oga.security.pki.CMS.CMSSignerInfoNotValidateException;
import th.co.oga.security.pki.CMS.CMSSigningException;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.SMIME.P7MEnvelopedDataSource;
import th.co.oga.security.pki.SMIME.P7MSignedDataSource;
import th.co.oga.security.pki.SMIME.P7SDataSource;
import th.co.oga.security.pki.SMIME.SMIMEContentType;
import th.co.oga.security.pki.SMIME.SMIMEFormat;
import th.co.oga.security.pki.SMIME.SMIMEHeader;
import th.co.oga.security.pki.SMIME.SMIMESigningException;
import th.co.oga.security.pki.SMIME.UnknowSignatureFormatException;
import th.co.oga.security.utils.Assert;

public class SMIMEPackager
extends CMSOperator {
    public static SMIMEFormat P7M_SIGNING_FORMAT = new SMIMEFormat(SMIMEContentType.PKCS7_SMIME_SIGNED_DATA_MESSAGE);
    public static SMIMEFormat P7S_SIGNING_FORMAT = new SMIMEFormat(SMIMEContentType.MULTIPART_SIGNED_MESSAGE);
    public static SMIMEFormat P7M_ENVELOPE_FORMAT = new SMIMEFormat(SMIMEContentType.PKCS7_SMIME_ENVELOPED_DATA_MESSAGE);

    public SMIMEPackager(Room room) throws AlgorithmSupportException, EntryNotFoundException, SecureStoreException {
        super(room);
    }

    protected byte[] sign(MimeBodyPart part, boolean keepContent) throws CMSSigningException, IOException, MessagingException {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        part.writeTo((OutputStream)buff);
        System.out.println(new String(buff.toByteArray()));
        byte[] toBeSignedData = buff.toByteArray();
        buff.close();
        CMSContentInfo signedInfo = this.sMimeSign(toBeSignedData, keepContent);
        return ASN1Util.encode((ASN1Value)signedInfo);
    }

    public byte[] p7MSign(MimeBodyPart part) throws CMSSigningException, IOException, MessagingException {
        return this.sign(part, true);
    }

    public byte[] p7SSign(MimeBodyPart part) throws CMSSigningException, IOException, MessagingException {
        return this.sign(part, false);
    }

    public void sMimeSignatureSign(Message msg) throws IOException, MessagingException, UnknowSignatureFormatException, SMIMESigningException {
        this.sMimeSignatureSign(msg, P7S_SIGNING_FORMAT);
    }

    public void sMimeSignatureSign(Message msg, SMIMEFormat format) throws IOException, MessagingException, UnknowSignatureFormatException, SMIMESigningException {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)buff);
        MimeBodyPart mbp = this.sMimeSignatureSign(buff.toByteArray(), format);
        SMIMEPackager.copyHeaders(mbp, msg);
        SMIMEPackager.copyContent(mbp, msg);
        msg.saveChanges();
    }

    public void sMimeSignatureVerify(Message message) throws IOException, MessagingException, UnknowSignatureFormatException, CMSSignerInfoNotValidateException, CMSSecurePackagerException {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        message.writeTo((OutputStream)buff);
        this.sMimeSignatureVerify(buff.toByteArray());
    }

    public void sMimeSignatureVerify(byte[] message) throws IOException, MessagingException, UnknowSignatureFormatException, CMSSignerInfoNotValidateException, CMSSecurePackagerException {
        MimeBodyPart msg = SMIMEPackager.loadMessage(message);
        SMIMEContentType contentType = new SMIMEContentType(msg.getContentType());
        if (!SMIMEContentType.isInSigningLength(contentType)) {
            throw new UnknowSignatureFormatException("Content type is not S/Mime message, " + contentType.getBaseType());
        }
        CMSSignedData signedData = this.getSignedData(msg, contentType);
        this.sMimeVerify(signedData);
    }

    public MimeBodyPart sMimeSignatureSign(byte[] message, SMIMEFormat format) throws MessagingException, IOException, UnknowSignatureFormatException, SMIMESigningException {
        Assert._assert(format != null, "The format need to be specificed .");
        MimeBodyPart msg = SMIMEPackager.loadMessage(message);
        this.sign(msg, format);
        return msg;
    }

    public MimeBodyPart sMimeSignatureSign(byte[] message) throws MessagingException, IOException, UnknowSignatureFormatException, SMIMESigningException {
        return this.sMimeSignatureSign(message, P7S_SIGNING_FORMAT);
    }

    public void sign(MimeBodyPart msg) throws MessagingException, IOException, UnknowSignatureFormatException, SMIMESigningException {
        SMIMEContentType contentType = new SMIMEContentType(msg.getContentType());
        if (SMIMEContentType.isInSigningLength(contentType)) {
            this.sign(msg, new SMIMEFormat(contentType.getPartType()));
        } else {
            this.sign(msg, P7S_SIGNING_FORMAT);
        }
    }

    public void sign(MimeBodyPart msg, SMIMEFormat format) throws MessagingException, IOException, UnknowSignatureFormatException, SMIMESigningException {
        SMIMEContentType contentType = new SMIMEContentType(msg.getContentType());
        if (SMIMEContentType.isInSigningLength(contentType)) {
            this.addSign(msg, contentType);
        } else if (format.formatOf(SMIMEContentType.MULTIPART_SIGNED_MESSAGE)) {
            this.newSign(msg, P7S_SIGNING_FORMAT);
        } else if (format.formatOf(SMIMEContentType.PKCS7_SMIME_SIGNED_DATA_MESSAGE)) {
            this.newSign(msg, P7M_SIGNING_FORMAT);
        }
    }

    private void addSign(MimeBodyPart msg, SMIMEContentType contentType) throws IOException, MessagingException, UnknowSignatureFormatException, SMIMESigningException {
        CMSSignedData signedData = this.getSignedData(msg, contentType);
        this.sMimeSignatureSign(signedData);
        if (contentType.is(SMIMEContentType.MULTIPART_SIGNED_MESSAGE)) {
            MimeBodyPart signedDataPart = this.getP7SSginedDataPart(signedData);
            Object obj = msg.getContent();
            MimeMultipart mmp = (MimeMultipart)obj;
            if (mmp.getCount() == 2) {
                mmp.removeBodyPart(1);
            }
            mmp.addBodyPart((BodyPart)signedDataPart, 1);
            msg.setContent((Multipart)mmp);
        } else {
            this.removeAllParts(msg);
            msg.setDataHandler(new DataHandler((DataSource)new P7MSignedDataSource(ASN1Util.encode((ASN1Value)signedData))));
            this.setP7MSignedDataHeader(msg);
        }
    }

    private void newSign(MimeBodyPart msg, SMIMEFormat format) throws MessagingException, IOException, SMIMESigningException {
        MimeBodyPart tbsPart = SMIMEPackager.getToBeSMimeOperatePart(msg);
        CMSSignedData signedData = new CMSSignedData();
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        tbsPart.writeTo((OutputStream)buff);
        try {
            signedData.setDataContent(buff.toByteArray());
            signedData = this.sMimeSignatureSign(signedData);
            this.removeAllParts(msg);
            if (format.formatOf(SMIMEContentType.MULTIPART_SIGNED_MESSAGE)) {
                String dsgAlgsName = this.getDigestAlgorithmsName(signedData);
                MimeBodyPart signedDataPart = this.getP7SSginedDataPart(signedData);
                SMIMEContentType ct = new SMIMEContentType(msg.getContentType());
                MimeMultipart mmp = new MimeMultipart(SMIMEContentType.createMultipartSignContentType(dsgAlgsName).getFullSubType());
                mmp.addBodyPart((BodyPart)tbsPart);
                mmp.addBodyPart((BodyPart)signedDataPart);
                msg.setContent((Multipart)mmp);
                this.setMultipartSignHeader(msg, dsgAlgsName);
            } else {
                CMSContentInfo cmsContent = new CMSContentInfo(CMSContentInfo.SIGNED_DATA, signedData);
                msg.setDataHandler(new DataHandler((DataSource)new P7MSignedDataSource(ASN1Util.encode((ASN1Value)cmsContent))));
                this.setP7MSignedDataHeader(msg);
            }
        }
        catch (AlgorithmSupportException e) {
            throw new SMIMESigningException(e.getMessage());
        }
    }

    public void attachP7MData(Message msg, SMIMEFormat format, byte[] p7mData) throws IOException, MessagingException, UnknowSignatureFormatException, SMIMESigningException, ASN1Exception {
        MimeBodyPart mbp = new MimeBodyPart();
        if (format.isEnvelope()) {
            this.attachEnvelopeData(mbp, p7mData);
        } else {
            this.attachSignedData(mbp, p7mData);
        }
        SMIMEPackager.copyHeaders(mbp, msg);
        SMIMEPackager.copyContent(mbp, msg);
        msg.saveChanges();
    }

    public void attachSignedData(MimeBodyPart msg, byte[] signedData) throws MessagingException, IOException, ASN1Exception {
        try {
            this.removeAllParts(msg);
            CMSContentInfo cmsContent = new CMSContentInfo(CMSContentInfo.SIGNED_DATA, signedData);
            msg.setDataHandler(new DataHandler((DataSource)new P7MSignedDataSource(ASN1Util.encode((ASN1Value)cmsContent))));
            this.setP7MSignedDataHeader(msg);
        }
        catch (InvalidBERException e) {
            throw new ASN1Exception((Exception)((Object)e));
        }
    }

    public void attachEnvelopeData(MimeBodyPart msg, byte[] envData) throws MessagingException, IOException, ASN1Exception {
        try {
            this.removeAllParts(msg);
            CMSContentInfo cmsContent = new CMSContentInfo(CMSContentInfo.ENVELOPED_DATA, envData);
            msg.setDataHandler(new DataHandler((DataSource)new P7MEnvelopedDataSource(ASN1Util.encode((ASN1Value)cmsContent))));
            this.setP7MEnvelopedDataHeader(msg);
        }
        catch (InvalidBERException e) {
            throw new ASN1Exception((Exception)((Object)e));
        }
    }

    private CMSSignedData sMimeSignatureSign(CMSSignedData signedData) throws SMIMESigningException {
        try {
            return this.sMimeSign(signedData);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SMIMESigningException(e.toString());
        }
    }

    public CMSSignedData getSignedData(MimeBodyPart msg, SMIMEContentType contentType) throws IOException, MessagingException, UnknowSignatureFormatException {
        try {
            CMSContentInfo.Template reader = new CMSContentInfo.Template();
            CMSSignedData signedData = null;
            Object msgContent = msg.getContent();
            if (contentType.is(SMIMEContentType.MULTIPART_SIGNED_MESSAGE)) {
                Assert._assert(msgContent instanceof Multipart, "Message have no multiple parts");
                Multipart parts = (Multipart)msg.getContent();
                BodyPart dataPart = parts.getBodyPart(0);
                BodyPart signaturePart = parts.getBodyPart(1);
                CMSContentInfo readedContent = (CMSContentInfo)CMSContentInfo.getTemplate().decode(new BufferedInputStream(signaturePart.getInputStream()));
                signedData = (CMSSignedData)readedContent.getInterpretedContent();
                ByteArrayOutputStream buff = new ByteArrayOutputStream();
                dataPart.writeTo((OutputStream)buff);
                signedData.setDataContent(buff.toByteArray());
            } else if (contentType.is(SMIMEContentType.PKCS7_SMIME_SIGNED_DATA_MESSAGE)) {
                CMSContentInfo readedContent = (CMSContentInfo)reader.decode(new BufferedInputStream(msg.getInputStream()));
                signedData = (CMSSignedData)readedContent.getInterpretedContent();
            }
            Assert._assert(signedData != null, "Not support content type " + contentType.getBaseType());
            return signedData;
        }
        catch (InvalidBERException e) {
            throw new UnknowSignatureFormatException("Signature can not read, " + e.getMessage());
        }
    }

    private void applyMultipartSignedContent(MimeBodyPart msg, CMSContentInfo cmsContent, boolean isNew) throws InvalidBERException {
        CMSSignedData signedData = (CMSSignedData)cmsContent.getInterpretedContent();
        byte[] data = signedData.getContentInfo().getContent().toByteArray();
    }

    private MimeBodyPart getP7SSginedDataPart(CMSSignedData signedData) throws MessagingException {
        signedData.purgeContentData();
        CMSContentInfo cmsContent = new CMSContentInfo(CMSContentInfo.SIGNED_DATA, signedData);
        MimeBodyPart signedDataPart = new MimeBodyPart();
        signedDataPart.setDataHandler(new DataHandler((DataSource)new P7SDataSource(ASN1Util.encode((ASN1Value)cmsContent))));
        signedDataPart.setFileName("smime.p7s");
        return signedDataPart;
    }

    private void setP7MSginedDataPart(MimeBodyPart part, CMSSignedData signedData) throws MessagingException {
        CMSContentInfo cmsContent = new CMSContentInfo(CMSContentInfo.SIGNED_DATA, signedData);
        part.setDataHandler(new DataHandler((DataSource)new P7MSignedDataSource(ASN1Util.encode((ASN1Value)cmsContent))));
        part.setFileName("smime.p7m");
    }

    private void setP7MSignedDataHeader(MimeBodyPart part) throws MessagingException {
        this.setHeaders(part, new SMIMEHeader(SMIMEContentType.createP7MSignedDataContentType()));
    }

    private void setP7MEnvelopedDataHeader(MimeBodyPart part) throws MessagingException {
        this.setHeaders(part, new SMIMEHeader(SMIMEContentType.createP7MEnvelopedDataContentType()));
    }

    private void setP7SSignedDataHeader(MimeBodyPart part) throws MessagingException {
        this.setHeaders(part, new SMIMEHeader(SMIMEContentType.createP7SContentType()));
    }

    private void setMultipartSignHeader(MimeBodyPart part, String digestAlgo) throws MessagingException {
        this.setHeaders(part, new SMIMEHeader(SMIMEContentType.createMultipartSignContentType(digestAlgo)));
    }

    private void setHeaders(MimeBodyPart part, InternetHeaders headers) throws MessagingException {
        Enumeration enu = headers.getAllHeaders();
        while (enu.hasMoreElements()) {
            Header hdr = (Header)enu.nextElement();
            part.setHeader(hdr.getName(), hdr.getValue());
        }
    }

    private void removeAllParts(MimeBodyPart part) throws IOException, MessagingException {
        Object obj;
        if (part.getSize() > 0 && (obj = part.getContent()) instanceof MimeMultipart) {
            MimeMultipart mmp = (MimeMultipart)obj;
            int p = 0;
            while (p < mmp.getCount()) {
                mmp.removeBodyPart(p);
                ++p;
            }
        }
    }

    public static MimeBodyPart getToBeSMimeOperatePart(MimeBodyPart msg) throws IOException, MessagingException {
        InternetHeaders newHeaders = new InternetHeaders();
        Object content = msg.getContent();
        MimeBodyPart newPart = new MimeBodyPart();
        if (content instanceof Multipart) {
            Multipart mPart = (Multipart)content;
            newPart.setContent(mPart);
        } else {
            newPart.setText((String)content);
        }
        ContentType contentType = new ContentType(msg.getContentType());
        newPart.setHeader("Content-Type", contentType.toString());
        return newPart;
    }

    public static MimeBodyPart loadMessage(byte[] bytes) throws MessagingException {
        return new MimeBodyPart((InputStream)new ByteArrayInputStream(bytes));
    }

    public static MimeBodyPart loadMessage(InputStream in) throws MessagingException {
        return new MimeBodyPart(in);
    }

    public static MimeBodyPart getMessageContent(CMSSignedData signedData) throws MessagingException {
        return SMIMEPackager.loadMessage(signedData.getContentInfo().getContent().toByteArray());
    }

    public static SMIMEContentType getContentType(Part part) throws MessagingException {
        return new SMIMEContentType(part.getContentType());
    }

    public void attachFile(String attachFile, MimeMultipart parts) throws MessagingException {
        this.attachFile(new File(attachFile), (Multipart)parts);
    }

    public void attachFile(File attachFile, Part part) throws IOException, MessagingException {
        Multipart parts;
        Object obj = part.getContent();
        if (obj instanceof Multipart) {
            parts = (Multipart)obj;
        } else {
            MimeBodyPart text = new MimeBodyPart();
            text.setText((String)obj);
            parts = new MimeMultipart();
            parts.addBodyPart((BodyPart)text);
            part.setContent(parts);
        }
        this.attachFile(attachFile, parts);
    }

    private void attachFile(File attachFile, Multipart parts) throws MessagingException {
        FileDataSource fds = new FileDataSource(attachFile);
        MimeBodyPart part = new MimeBodyPart();
        part.setDataHandler(new DataHandler((DataSource)fds));
        part.setFileName(fds.getName());
        parts.addBodyPart((BodyPart)part);
    }

    public static void copyHeaders(MimeBodyPart part, Message msg) throws MessagingException {
        Enumeration headers = part.getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            msg.setHeader(header.getName(), header.getValue());
        }
    }

    public static void copyContent(MimeBodyPart part, Message msg) throws MessagingException, IOException {
        Object obj = part.getContent();
        if (obj instanceof Multipart) {
            Multipart mp = (Multipart)obj;
            msg.setContent(mp);
        } else if (obj instanceof String) {
            msg.setText((String)obj);
        } else {
            msg.setDataHandler(part.getDataHandler());
            msg.setFileName(part.getDataHandler().getDataSource().getName());
        }
    }
}

