/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Transport;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Properties;
import sun.misc.BASE64Encoder;
import th.co.oga.security.pki.Transport.HTTPProtocolProperties;
import th.co.oga.security.pki.Transport.HTTPTrnsLoader;
import th.co.oga.security.pki.Transport.MultipartTransportHeader;
import th.co.oga.security.pki.Transport.ProtocolProperties;
import th.co.oga.security.pki.Transport.TransportAuthenticator;
import th.co.oga.security.pki.Transport.TransportConnector;
import th.co.oga.security.pki.Transport.TransportHeader;
import th.co.oga.security.pki.Transport.TransportLoader;
import th.co.oga.security.pki.Transport.TransportPackage;
import th.co.oga.security.pki.Transport.TransportProtocol;
import th.co.oga.security.pki.Transport.UnSupportProtocolPropertyException;
import th.co.oga.security.pki.Trusted.ProtocolName;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.utils.Assert;

public class HTTPConnector
implements TransportConnector {
    public static TransportHeader MULTIPART = new MultipartTransportHeader(ProtocolName.HTTP);
    private HttpURLConnection connection;
    private PrintStream requester;
    private BufferedInputStream responder;
    private boolean avariable;
    private TransportLoader loader;
    private boolean tracing;
    private int state = 0;
    private HTTPProtocolProperties props;
    private TransportAuthenticator authen = new TransportAuthenticator();

    protected HTTPConnector() {
        Authenticator.setDefault(this.authen);
    }

    public HTTPConnector(String url) throws IOException {
        this(null, url);
    }

    public HTTPConnector(PasswordAuthentication authenToken, String url) throws IOException {
        this();
        this.open(authenToken, url, true, true);
    }

    public HTTPConnector(PasswordAuthentication authenToken, String url, ProtocolProperties props) throws UnSupportProtocolPropertyException, IOException {
        this();
        this.setProps(props);
        this.open(authenToken, url, true, true);
    }

    public TransportLoader getLoader() throws IOException {
        this.loader.setConnection(this.connection);
        return this.loader;
    }

    private void init() {
        this.loader = new HTTPTrnsLoader();
        this.connection.setAllowUserInteraction(true);
        this.connection.setUseCaches(false);
        this.connection.setDefaultUseCaches(false);
        this.connection.setRequestProperty("sun.net.client.defaultConnectTimeout", "600");
        this.connection.setRequestProperty("sun.net.client.defaultReadTimeout", "600");
        this.connection.setRequestProperty("Accept-Charset", "iso-8859-2,*,utf-8");
        this.connection.setRequestProperty("Accept-Language", "en");
        if (this.props != null) {
            String proxySet = this.props.getProperty(HTTPProtocolProperties.PROXY_SET);
            String proxyHost = this.props.getProperty(HTTPProtocolProperties.PROXY_HOST);
            String proxyPort = this.props.getProperty(HTTPProtocolProperties.PROXY_PORT);
            String proxyUser = this.props.getProperty(HTTPProtocolProperties.PROXY_USER);
            String proxyPassword = this.props.getProperty(HTTPProtocolProperties.PROXY_PASSWORD);
            if (proxyUser.length() == 0) {
                proxyUser = "USER";
                proxyPassword = "PASSWORD";
            }
            String proxyAuthorization = null;
            String auth = String.valueOf(proxyUser) + ":" + proxyPassword;
            proxyAuthorization = "Basic " + new BASE64Encoder().encode(auth.getBytes());
            if (proxySet.toUpperCase().equals("TRUE")) {
                this.connection.setRequestProperty("Proxy-Authorization", proxyAuthorization);
                System.getProperties().put(HTTPProtocolProperties.PROXY_SET, proxySet);
                System.getProperties().put(HTTPProtocolProperties.PROXY_HOST, proxyHost);
                System.getProperties().put(HTTPProtocolProperties.PROXY_PORT, proxyPort);
            }
        }
    }

    public void open(PasswordAuthentication authenToken, String urlString, boolean readable, boolean writable) throws IOException {
        URL url = new URL(urlString);
        this.connection = (HttpURLConnection)url.openConnection();
        this.connection.setDoOutput(writable);
        this.connection.setDoInput(readable);
        this.init();
        this.setAuthen(authenToken);
    }

    public void setRequestParams(TransportHeader header) {
        Properties reqParams = header.getRequestParam();
        for (String string : reqParams.keySet()) {
            this.connection.addRequestProperty(string, (String)reqParams.get(string));
        }
    }

    public void setMethod(String method) throws ProtocolException {
        this.connection.setRequestMethod(method);
    }

    public void setTraceMode(boolean tracing) {
        this.tracing = tracing;
    }

    public void submit() throws IOException {
        this.connection.connect();
    }

    public void setAuthen(PasswordAuthentication authenToken) {
        if (authenToken != null) {
            this.authen.setPasswordAuthentication(authenToken);
        }
    }

    public void lock() {
        this.avariable = false;
    }

    public void release() {
        this.avariable = true;
    }

    public void close() {
        this.connection.disconnect();
    }

    public void send(TransportPackage pkg) throws IOException {
        Assert._assert(this.avariable, "The connection have not avariable ...");
        this.setRequestParams(pkg.getHeader());
        this.loader.setConnection(this.connection);
        this.loader.openOutContainer(pkg.getHeader());
        this.loader.write(pkg);
        this.loader.closeOutContainer();
        this.submit();
    }

    public void receive(TransportPackage pkg) throws IOException {
        this.loader.setConnection(this.connection);
        this.loader.openInContainer();
        this.loader.read(pkg);
        this.loader.closeInContainer();
    }

    public void addRecipient(String addr) throws IllegalArgumentException {
    }

    public void setSender(String addr) throws IllegalArgumentException {
    }

    public void setContentType(String contentType) throws IllegalArgumentException {
        this.connection.setRequestProperty("Content-type", contentType);
    }

    public void multipartRequest(TransportPackage req, TransportPackage res) throws IOException {
        if (req.getHeader().getEncoding() != null) {
            this.connection.setRequestProperty("Content-transfer-encoding", req.getHeader().getEncoding());
        }
        req.encode(this.connection.getOutputStream());
        this.submit();
        this.receive(res);
    }

    public void inLineRequest(TransportPackage req, TransportPackage res) throws IOException {
        this.submit();
        this.receive(res);
    }

    private void snapshot(TransportPackage pkg) {
        try {
            String fileName = "./Matterial/http_snapshot";
            File file = new File(String.valueOf(fileName) + "_" + Utils.getWacthTime() + ".der");
            FileOutputStream out = new FileOutputStream(file);
            pkg.encode(out);
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addQuery(String key, String value) {
        this.connection.addRequestProperty(key, value);
    }

    public void addRequest(String key, String value) {
        this.connection.addRequestProperty(key, value);
    }

    public String getField(String pfield) {
        return this.connection.getHeaderField(pfield);
    }

    public boolean isRequestCompleate() {
        boolean rtn = false;
        try {
            if (this.connection.getHeaderField("req-status").equalsIgnoreCase("Finish")) {
                rtn = true;
            }
        }
        catch (NullPointerException e) {
            rtn = false;
        }
        return rtn;
    }

    public void getContent(OutputStream out) throws MalformedURLException, IOException {
        int c;
        String rtn = "";
        InputStream in = this.connection.getInputStream();
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
    }

    public void showHeader() {
        int i = 1;
        while (i < this.connection.getContentLength()) {
            if (this.connection.getHeaderFieldKey(i) == null) break;
            System.out.println(String.valueOf(this.connection.getHeaderFieldKey(i)) + " = " + this.connection.getHeaderField(i));
            ++i;
        }
    }

    public void showContent() throws IOException {
        int c;
        InputStream in = this.connection.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        System.out.println(out.toString());
        in.close();
        out.close();
    }

    public void showError() throws IOException {
        InputStream in = this.connection.getErrorStream();
        if (in != null) {
            int c;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            System.out.println(out.toString());
            in.close();
            out.close();
        }
    }

    public void setProps(ProtocolProperties props) throws UnSupportProtocolPropertyException {
        if (props != null) {
            if (props instanceof HTTPProtocolProperties) {
                this.props = (HTTPProtocolProperties)props;
            } else {
                throw new UnSupportProtocolPropertyException(TransportProtocol.HTTP.getName(), props.getProtocolName());
            }
        }
    }
}

