/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Transport;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import th.co.oga.security.pki.Transport.MultiPartSPEC;

public class HTTPPartContent
implements MultiPartSPEC {
    private String disposition = null;
    private String name = null;
    private String filename = null;
    private String mimeType = null;
    private String encoding = null;
    private boolean isTransparent = false;
    private InputStream reader;
    public int length = 0;
    public int headLines = 0;
    public boolean EOC = false;
    public boolean EOH = false;
    public boolean EOP = false;
    public ByteArrayOutputStream cached = new ByteArrayOutputStream();

    public HTTPPartContent(InputStream reader) throws IOException {
        this(reader, false);
    }

    public HTTPPartContent(InputStream reader, boolean transparent) throws IOException {
        this.reader = reader;
        this.isTransparent = transparent;
        if (!this.isTransparent) {
            this.interplete();
        }
    }

    public void interplete() throws IOException {
        int b;
        int len = 0;
        boolean cons = false;
        String partParams = "";
        while (!this.EOH) {
            len = 0;
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            b = this.reader.read();
            while (b != -1) {
                if (b == 13) {
                    if (len > 0) {
                        partParams = buff.toString();
                        break;
                    }
                    this.EOH = true;
                    break;
                }
                buff.write(b);
                ++len;
                b = this.reader.read();
            }
            if (!this.EOH && partParams != null) {
                ++this.headLines;
                this.extractHeaderLine(partParams);
            }
            if (b != -1) continue;
            this.EOC = true;
            break;
        }
        int lineLength = 0;
        if (!this.EOC) {
            b = this.reader.read();
            while (b != -1) {
                if (b == 13) {
                    if (lineLength == 0) {
                        this.EOP = true;
                        break;
                    }
                    lineLength = 0;
                }
                ++lineLength;
                this.cached.write(b);
                b = this.reader.read();
                if (b != -1) continue;
                this.EOC = true;
                break;
            }
        }
    }

    public BufferedInputStream getInputStream() {
        if (this.isTransparent) {
            return new BufferedInputStream(this.reader);
        }
        return new BufferedInputStream(new ByteArrayInputStream(this.cached.toByteArray()));
    }

    private void extractHeaderLine(String headerLine) {
        boolean offset = false;
        Object got = null;
        String[] params = headerLine.split("; ");
        if (params.length > 0) {
            String[] values = params[0].split(": ");
            String key = values[0];
            String value = "";
            if (params.length > 1) {
                value = values[1];
            }
            if (key.equalsIgnoreCase("Content-Disposition")) {
                this.disposition = value;
                this.extractDisposition(values);
            } else if (key.equalsIgnoreCase("Content-type")) {
                this.mimeType = value;
            } else if (key.equalsIgnoreCase("Content-transfer-encoding")) {
                this.encoding = value;
            } else if (key.equalsIgnoreCase("Content-Length")) {
                this.length = new BigInteger(value).intValue();
            }
        }
    }

    private void extractDisposition(String[] params) {
        int i = 1;
        while (i < params.length) {
            String[] values = params[i].split("=");
            if (values[0].equalsIgnoreCase("filename")) {
                this.filename = values[1];
            } else if (values[0].equalsIgnoreCase("name")) {
                this.name = values[1];
            }
            ++i;
        }
    }
}

