/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLClientCertificateSelectionCallback;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.TestClientCertificateSelectionCallback;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.Transport.JSSCertApprovalCallback;

public class HTTPSOperator {
    private SecureStoreOperator sso;
    private SSLSocket socket;
    private String hostName;
    private int portNumber = 443;
    SSLHandshakeCompletedListener listener = null;
    static final int[] cipherSuites;

    static {
        int[] nArray = new int[7];
        nArray[0] = 4;
        nArray[1] = 10;
        nArray[2] = 9;
        nArray[3] = 3;
        nArray[4] = 6;
        nArray[5] = 1;
        cipherSuites = nArray;
    }

    public HTTPSOperator(SecureStoreOperator oper, String host) throws SocketException {
        this.hostName = host;
        this.sso = oper;
        SSLSocket.setCipherPreferenceDefault((int)4, (boolean)true);
        this.listener = new ClientHandshakeCB(this);
    }

    public void openConnect() throws IOException {
        JSSCertApprovalCallback approvalCallback = new JSSCertApprovalCallback(this.sso);
        TestClientCertificateSelectionCallback certSelectionCallback = new TestClientCertificateSelectionCallback();
        Socket js = new Socket(InetAddress.getByName(this.hostName), this.portNumber);
        this.socket = new SSLSocket(js, this.hostName, (SSLCertificateApprovalCallback)approvalCallback, (SSLClientCertificateSelectionCallback)certSelectionCallback);
        this.socket.forceHandshake();
        this.socket.addHandshakeCompletedListener(this.listener);
    }

    public void download(String fileName) throws IOException {
        this.setRequest("GET " + fileName);
    }

    public void setRequest(String command) throws IOException {
        PrintWriter writer = new PrintWriter(this.socket.getOutputStream());
        String req = String.valueOf(command) + "\r";
        writer.write(req);
        writer.close();
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            this.socket = null;
        }
    }

    public void getResponse() throws IOException {
        int x;
        InputStream reader = this.socket.getInputStream();
        System.out.println("Read the data from connection ...");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while ((x = reader.read()) > -1) {
            buffer.write(x);
        }
        reader.close();
        System.out.println("Read finished ....");
        System.out.println("Data:" + new String(buffer.toByteArray()));
        buffer.close();
    }

    public void getResponse(SSLSecurityStatus status) throws IOException {
        int x;
        System.out.println("Socket Cipher is:" + status.getCipher());
        System.out.println("Socket status is:" + status.toString());
        InputStream reader = this.socket.getInputStream();
        System.out.println("Read the data from connection ...");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while ((x = reader.read()) > -1) {
            buffer.write(x);
        }
        reader.close();
        System.out.println("Read finished ....");
        System.out.println("Data:" + new String(buffer.toByteArray()));
        buffer.close();
    }

    class ClientHandshakeCB
    implements SSLHandshakeCompletedListener {
        HTTPSOperator oper;

        ClientHandshakeCB(HTTPSOperator oper) {
            this.oper = oper;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent event) {
            try {
                this.oper.getResponse(event.getStatus());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

