/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Transport;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.util.ArrayList;
import th.co.oga.security.pki.Transport.HTTPPartContent;
import th.co.oga.security.pki.Transport.MultiPartSPEC;
import th.co.oga.security.pki.Transport.TransportHeader;
import th.co.oga.security.pki.Transport.TransportMimeType;
import th.co.oga.security.pki.Trusted.ProtocolName;

public class HTTPTrnsContent
extends ArrayList
implements MultiPartSPEC {
    private TransportHeader header = new TransportHeader(ProtocolName.HTTP);
    private String contentBoundary;
    private BufferedInputStream reader;
    private String delemeter;
    private String terminator;
    private boolean isMultiPart = false;

    public HTTPTrnsContent(URLConnection conn) throws IOException {
        String ct;
        this.header.setContentType(conn.getContentType());
        this.header.setEncoding(conn.getContentEncoding());
        this.header.setContentLength(conn.getContentLength());
        this.header.setLastModify(conn.getLastModified());
        this.header.setStatusText(conn.getHeaderField("req-status"));
        this.header.putAll(conn.getHeaderFields());
        String string = ct = this.header.getContentType() == null ? "" : this.header.getContentType();
        if (ct.startsWith(MULTIPART)) {
            String header = conn.getHeaderField("Content-type");
            String[] params = header.split("; ");
            int i = 1;
            while (i < params.length) {
                String[] values = params[i].split("=");
                if (values[0].equalsIgnoreCase("boundary")) {
                    this.contentBoundary = values[1];
                    break;
                }
                ++i;
            }
            this.delemeter = "--" + this.contentBoundary;
            this.terminator = String.valueOf(this.delemeter) + "--";
            this.isMultiPart = true;
            this.reader = new BufferedInputStream(conn.getInputStream());
            this.extractContent();
        } else {
            this.isMultiPart = false;
            this.reader = new BufferedInputStream(conn.getInputStream());
            HTTPPartContent part = new HTTPPartContent(this.reader, true);
            this.add(part);
        }
    }

    public boolean isMultipart() {
        return this.isMultiPart;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public TransportHeader getHeader() {
        return this.header;
    }

    public void extractContent() throws IOException {
        boolean EOC = false;
        if (this.header.getContentType().startsWith(TransportMimeType.MUTIPART)) {
            while (!EOC) {
                ByteArrayOutputStream lineBuff = new ByteArrayOutputStream();
                boolean lineLen = false;
                int b = this.reader.read();
                while (b != -1) {
                    if (b == 13) {
                        if (!lineLen) break;
                        lineLen = false;
                    }
                    lineBuff.write(b);
                    b = this.reader.read();
                    if (b != -1) continue;
                    EOC = true;
                    break;
                }
                if (EOC) continue;
                String line = lineBuff.toString();
                if (line.startsWith(this.terminator)) {
                    EOC = true;
                    continue;
                }
                if (!line.startsWith(this.delemeter)) continue;
                HTTPPartContent part = new HTTPPartContent(this.reader);
                this.add(part);
                EOC = part.EOC;
            }
        }
        if (this.header.getContentType().startsWith(TransportMimeType.APPLICATION)) {
            while (!EOC) {
                HTTPPartContent part = new HTTPPartContent(this.reader);
                this.add(part);
                EOC = part.EOC;
            }
        }
    }
}

