/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Transport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import th.co.oga.security.pki.Transport.HTTPPartContent;
import th.co.oga.security.pki.Transport.HTTPTrnsContent;
import th.co.oga.security.pki.Transport.MultiPartSPEC;
import th.co.oga.security.pki.Transport.TransportHeader;
import th.co.oga.security.pki.Transport.TransportLoader;
import th.co.oga.security.pki.Transport.TransportPackage;

public class HTTPTrnsLoader
implements TransportLoader,
MultiPartSPEC {
    public static String REQUEST_BOUNDARY = "6618418474";
    public static String REQUEST_DELEMETER = "--";
    private URLConnection conn;
    private TransportHeader header;
    private PrintStream requester;
    private BufferedInputStream responder;
    private HTTPTrnsContent reponseContent;
    private Iterator parts;

    protected HTTPTrnsLoader() {
    }

    public void setConnection(URLConnection conn) throws IOException {
        this.conn = conn;
    }

    public void openOutContainer(TransportHeader header) throws IOException {
        this.header = header;
        if (header.getContentType().startsWith(MULTIPART)) {
            this.conn.setRequestProperty("Content-type", String.valueOf(header.getContentType()) + "; boundary=" + REQUEST_BOUNDARY);
            this.conn.setRequestProperty("Content-Length", "1234");
        } else {
            this.conn.setRequestProperty("Content-type", header.getContentType());
        }
        this.requester = new PrintStream(this.conn.getOutputStream());
    }

    private void setEncoding() {
        if (this.header.getEncoding() != null) {
            this.conn.setRequestProperty("Content-transfer-encoding", this.header.getEncoding());
        }
    }

    public void write(TransportPackage pkg) throws IOException {
        if (this.header.getContentType().startsWith(MULTIPART)) {
            TransportHeader hdr = pkg.getHeader();
            this.requester.println(String.valueOf(REQUEST_DELEMETER) + REQUEST_BOUNDARY);
            if (hdr.getContentType().equalsIgnoreCase(MULTIPART_FORM.getMimeType())) {
                this.requester.println("Content-Disposition: form-data; name=" + hdr.getName() + ";  filename=\"" + hdr.getFileName() + "\"");
            }
            this.requester.println("Content-type: " + hdr.getContentType());
            this.requester.println("");
            pkg.encode(this.requester);
            this.requester.println("");
        } else {
            this.requester.println("");
            pkg.encode(this.requester);
            this.requester.println("");
        }
    }

    public void closeOutContainer() throws IOException {
        this.requester.println(String.valueOf(REQUEST_DELEMETER) + REQUEST_BOUNDARY + REQUEST_DELEMETER);
        this.requester.println("");
        this.requester.flush();
        this.requester.close();
    }

    public void openInContainer() throws IOException {
        this.reponseContent = new HTTPTrnsContent(this.conn);
        this.parts = this.reponseContent.iterator();
    }

    public boolean hasNext() {
        return this.parts.hasNext();
    }

    public void read(TransportPackage pkg) throws IOException, NoSuchElementException {
        if (!this.parts.hasNext()) {
            throw new NoSuchElementException("Can not get next part content, There are no part in list.");
        }
        pkg.setHeader(this.reponseContent.getHeader());
        BufferedInputStream partReader = ((HTTPPartContent)this.parts.next()).getInputStream();
        pkg.decode(partReader);
    }

    public void closeInContainer() throws IOException {
        this.reponseContent.close();
    }

    public void uploadFile(File file, String name) throws IOException {
        this.requester.println(String.valueOf(REQUEST_DELEMETER) + REQUEST_BOUNDARY);
        this.requester.println("Content-Disposition: form-data; name=" + name + ";  filename=\"" + file.getName() + "\"");
        this.requester.println("Content-type: *");
        this.requester.println("");
        FileInputStream fin = new FileInputStream(file);
        this.loadFromStream(fin);
        fin.close();
        this.requester.println("");
    }

    public void loadLocalFile(File file) throws IOException {
        this.requester.println(String.valueOf(REQUEST_DELEMETER) + REQUEST_BOUNDARY);
        this.requester.println("Content-Disposition: attachment; filename=\"" + file.getName() + "\"");
        this.requester.println("Content-type: *");
        this.requester.println("");
        FileInputStream fin = new FileInputStream(file);
        this.loadFromStream(fin);
        fin.close();
        this.requester.println("");
    }

    private void loadFromStream(InputStream in) throws IOException {
        int bytesAvailable = in.available();
        int maxBufferSize = 1024;
        int bufferSize = Math.min(bytesAvailable, maxBufferSize);
        byte[] buffer = new byte[bufferSize];
        int b = in.read(buffer, 0, bufferSize);
        while (b > 0) {
            this.requester.write(buffer, 0, bufferSize);
            bytesAvailable = in.available();
            bufferSize = Math.min(bytesAvailable, maxBufferSize);
            b = in.read(buffer, 0, bufferSize);
        }
    }
}

