/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Transport;

import java.util.Enumeration;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Operator.SecureStoreOperator;

public class JSSCertApprovalCallback
implements SSLCertificateApprovalCallback {
    private SecureStoreOperator storeOper;

    public JSSCertApprovalCallback(SecureStoreOperator oper) {
        this.storeOper = oper;
    }

    public boolean approve(X509Certificate servercert, SSLCertificateApprovalCallback.ValidityStatus status) {
        CertProfile cert;
        boolean trust_the_server_cert = false;
        Enumeration errors = status.getReasons();
        int i = 0;
        while (errors.hasMoreElements()) {
            ++i;
            SSLCertificateApprovalCallback.ValidityItem item = (SSLCertificateApprovalCallback.ValidityItem)errors.nextElement();
            cert = item.getCert();
            if (item.getReason() != -8172) continue;
            trust_the_server_cert = true;
        }
        if (trust_the_server_cert) {
            try {
                cert = CertProfile.getInstance(servercert.getEncoded());
                this.storeOper.trustCert(cert);
            }
            catch (Exception e) {
                System.out.println("thrown exception: " + e);
            }
        }
        return true;
    }
}

