/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Transport.ProtocolProperties;
import th.co.oga.security.pki.Transport.TransportConnector;
import th.co.oga.security.pki.Transport.TransportPackage;
import th.co.oga.security.pki.Transport.UnSupportProtocolPropertyException;

public class LDAPConnector
implements TransportConnector {
    private String crlUrl;
    private String securityAuthentication;
    private String securityPrincaipal;
    private String securityCredentials;
    protected final Hashtable env = new Hashtable();
    private DirContext ctx;
    private String distinguishName;
    private String baseDN;
    private String svcHost;

    protected LDAPConnector() {
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.env.put("java.naming.security.authentication", "simple");
    }

    public LDAPConnector(PasswordAuthentication pa, String urlStr) throws IOException {
        this();
        this.open(pa, urlStr, true, true);
    }

    private void interpleteURL() {
        String url = new String(this.crlUrl);
        String part = "";
        String svcPnt = "";
        String ptc = "ldap://";
        if (url.indexOf("://") > -1) {
            url = url.substring(url.indexOf("://") + 3, url.length());
        }
        if (url.indexOf("/") > -1) {
            svcPnt = url.substring(0, url.indexOf("/"));
            part = url.substring(url.indexOf("/") + 1, url.length());
        } else {
            svcPnt = url;
            part = "/";
        }
        this.svcHost = String.valueOf(ptc) + svcPnt;
        if (part.indexOf(",") > -1) {
            this.baseDN = part.substring(0, part.indexOf(","));
            this.distinguishName = part.substring(part.indexOf(",") + 1, part.length());
        } else {
            this.baseDN = part;
            this.distinguishName = null;
        }
        System.out.println("svcHost : " + this.svcHost);
        System.out.println("baseDN : " + this.baseDN);
        System.out.println("distinguishName : " + this.distinguishName);
    }

    public void open(PasswordAuthentication authen, String url, boolean readable, boolean writable) throws IOException {
        if (authen != null) {
            this.setAuthen(authen);
        }
        this.crlUrl = url;
        this.interpleteURL();
        if (this.baseDN != null) {
            this.env.put("java.naming.provider.url", String.valueOf(this.svcHost) + "/" + this.baseDN);
        } else {
            this.env.put("java.naming.provider.url", this.svcHost);
        }
        try {
            this.ctx = new InitialDirContext(this.env);
        }
        catch (NamingException e) {
            throw new IllegalArgumentException("Namming exception while close the Directory Context, " + e.getMessage());
        }
    }

    public void lock() {
    }

    public void release() {
    }

    public void close() {
        try {
            this.ctx.close();
        }
        catch (NamingException e) {
            throw new IllegalArgumentException("Namming exception while close the Directory Context, " + e.getMessage());
        }
    }

    public void setAuthen(PasswordAuthentication authenToken) {
        if (authenToken != null) {
            this.securityPrincaipal = authenToken.getUserName();
            this.securityCredentials = new String(authenToken.getPassword());
            this.env.put("java.naming.security.principal", this.securityPrincaipal);
            this.env.put("java.naming.security.credentials", this.securityCredentials);
        }
    }

    public void setSender(String addr) throws IllegalArgumentException {
    }

    public void setContentType(String contentType) throws IllegalArgumentException {
    }

    public void addRecipient(String addr) throws IllegalArgumentException {
    }

    public void setMethod(String method) throws ProtocolException {
    }

    public void send(TransportPackage pkg) throws IOException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            pkg.encode(out);
            this.ctx.rebind(this.distinguishName, (Object)out.toByteArray());
            out.close();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public void receive(TransportPackage pkg) throws IOException {
        try {
            byte[] bs = (byte[])this.ctx.lookup(this.distinguishName);
            ByteArrayInputStream in = new ByteArrayInputStream(bs);
            pkg.decode(in);
            in.close();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public void multipartRequest(TransportPackage req, TransportPackage res) throws IOException, ASN1Exception {
    }

    public void inLineRequest(TransportPackage req, TransportPackage res) throws IOException, ASN1Exception {
        this.receive(res);
    }

    public void setTraceMode(boolean tracing) {
    }

    public void setProps(ProtocolProperties props) throws UnSupportProtocolPropertyException {
    }
}

