/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Transport;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import th.co.oga.security.pki.CryptOGAFormat;
import th.co.oga.security.pki.Transport.HTTPProtocolProperties;
import th.co.oga.security.pki.Transport.HTTPsProtocolProperties;
import th.co.oga.security.pki.Transport.LDAPProtocolProperties;
import th.co.oga.security.pki.Transport.LDAPsProtocolProperties;
import th.co.oga.security.pki.Transport.SMTPProtocolProperties;
import th.co.oga.security.pki.Transport.TransportProtocol;
import th.co.oga.security.pki.Transport.UnSupportProtocolException;
import th.co.oga.security.utils.UnknowMadatoryException;
import th.co.oga.security.xml.XMLNodeConversionException;
import th.co.oga.security.xml.XMLRecord;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public class ProtocolProperties
extends Properties
implements XMLRecord {
    public static String UNDEFINE = "Undefine";
    private String protocolName;

    public ProtocolProperties(String protocolName) {
        this.protocolName = protocolName;
    }

    protected ProtocolProperties() {
    }

    public static ProtocolProperties getGeneral() {
        return new ProtocolProperties();
    }

    public static ProtocolProperties getInstance(TransportProtocol ptc) throws UnSupportProtocolException {
        if (ptc.getName().equals(TransportProtocol.HTTP_PROTOCOL)) {
            return new HTTPProtocolProperties();
        }
        if (ptc.getName().equals(TransportProtocol.HTTPS_PROTOCOL)) {
            return new HTTPsProtocolProperties();
        }
        if (ptc.getName().equals(TransportProtocol.LDAP_PROTOCOL)) {
            return new LDAPProtocolProperties();
        }
        if (ptc.getName().equals(TransportProtocol.LDAPS_PROTOCOL)) {
            return new LDAPsProtocolProperties();
        }
        if (ptc.getName().equals(TransportProtocol.SMTP_PROTOCOL)) {
            return new SMTPProtocolProperties();
        }
        throw new UnSupportProtocolException("ProtocolPropertis", "Unsupport protocol " + ptc.getName());
    }

    public void setProps(Properties props) {
        Enumeration<Object> enu = props.keys();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            this.setProperty(key, props.getProperty(key));
        }
    }

    protected void setParameter(String mandat, String defaultValue) {
        String value = this.getProperty(mandat);
        if (value == null) {
            this.setProperty(mandat, defaultValue);
        }
    }

    protected void setParameter(String mandat) {
        this.setParameter(mandat, UNDEFINE);
    }

    public Enumeration getMandatories() {
        return this.keys();
    }

    public String getValue(String mandatory) throws UnknowMadatoryException {
        String value = this.getProperty(mandatory);
        if (value == null) {
            throw new UnknowMadatoryException(mandatory);
        }
        return value;
    }

    public void setValue(String mandatory, String value) throws UnknowMadatoryException {
        String ovalue = this.getProperty(mandatory);
        if (ovalue == null) {
            throw new UnknowMadatoryException(mandatory);
        }
        this.setProperty(mandatory, value);
    }

    public void dumpXML(OutputStream out) throws IOException {
        this.storeToXML(out, "Dump all props");
    }

    public void dumpString(OutputStream out) throws IOException {
        this.store(out, "Dump all props");
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public String getElementName() {
        return CryptOGAFormat.CA_SVC_PROTOCOL_PARAMETERS;
    }

    public String getParentElementName() {
        return CryptOGAFormat.CA_SERVICE;
    }

    public Node getXMLNode(Document doc) throws XMLNodeConversionException {
        Element node = doc.createElement(this.getElementName());
        try {
            Enumeration enums = this.getMandatories();
            while (enums.hasMoreElements()) {
                String mandat = (String)enums.nextElement();
                String value = this.getValue(mandat);
                Element child = doc.createElement(mandat);
                child.appendChild(doc.createTextNode(value));
                node.appendChild(child);
            }
        }
        catch (Exception e) {
            throw new XMLNodeConversionException(this.toString(), this.getElementName(), e.toString());
        }
        return node;
    }

    public boolean isXMLNode(Node node) throws XMLRecordDataException {
        return false;
    }

    public void setXMLRecord(Node node) throws XMLRecordDataException {
        NodeList nodeList = node.getChildNodes();
        try {
            int i = 0;
            while (i < nodeList.getLength()) {
                if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                    this.setParameter(XMLUtils.nodeName(nodeList.item(i)), XMLUtils.nodeValue(nodeList.item(i)));
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new XMLRecordDataException("DName", e.toString());
        }
    }
}

